/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.openshift.api.model.v6_13.miscellaneous.metal3.v1alpha1.CPU;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CPUFluent<A extends CPUFluent<A>>
extends BaseFluent<A> {
    private String arch;
    private Double clockMegahertz;
    private Integer count;
    private List<String> flags = new ArrayList<String>();
    private String model;
    private Map<String, Object> additionalProperties;

    public CPUFluent() {
    }

    public CPUFluent(CPU instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CPU instance) {
        CPU cPU = instance = instance != null ? instance : new CPU();
        if (instance != null) {
            this.withArch(instance.getArch());
            this.withClockMegahertz(instance.getClockMegahertz());
            this.withCount(instance.getCount());
            this.withFlags(instance.getFlags());
            this.withModel(instance.getModel());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getArch() {
        return this.arch;
    }

    public A withArch(String arch) {
        this.arch = arch;
        return (A)this;
    }

    public boolean hasArch() {
        return this.arch != null;
    }

    public Double getClockMegahertz() {
        return this.clockMegahertz;
    }

    public A withClockMegahertz(Double clockMegahertz) {
        this.clockMegahertz = clockMegahertz;
        return (A)this;
    }

    public boolean hasClockMegahertz() {
        return this.clockMegahertz != null;
    }

    public Integer getCount() {
        return this.count;
    }

    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    public boolean hasCount() {
        return this.count != null;
    }

    public A addToFlags(int index, String item) {
        if (this.flags == null) {
            this.flags = new ArrayList<String>();
        }
        this.flags.add(index, item);
        return (A)this;
    }

    public A setToFlags(int index, String item) {
        if (this.flags == null) {
            this.flags = new ArrayList<String>();
        }
        this.flags.set(index, item);
        return (A)this;
    }

    public A addToFlags(String ... items) {
        if (this.flags == null) {
            this.flags = new ArrayList<String>();
        }
        for (String item : items) {
            this.flags.add(item);
        }
        return (A)this;
    }

    public A addAllToFlags(Collection<String> items) {
        if (this.flags == null) {
            this.flags = new ArrayList<String>();
        }
        for (String item : items) {
            this.flags.add(item);
        }
        return (A)this;
    }

    public A removeFromFlags(String ... items) {
        if (this.flags == null) {
            return (A)this;
        }
        for (String item : items) {
            this.flags.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromFlags(Collection<String> items) {
        if (this.flags == null) {
            return (A)this;
        }
        for (String item : items) {
            this.flags.remove(item);
        }
        return (A)this;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public String getFlag(int index) {
        return this.flags.get(index);
    }

    public String getFirstFlag() {
        return this.flags.get(0);
    }

    public String getLastFlag() {
        return this.flags.get(this.flags.size() - 1);
    }

    public String getMatchingFlag(Predicate<String> predicate) {
        for (String item : this.flags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFlag(Predicate<String> predicate) {
        for (String item : this.flags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFlags(List<String> flags) {
        if (flags != null) {
            this.flags = new ArrayList<String>();
            for (String item : flags) {
                this.addToFlags(item);
            }
        } else {
            this.flags = null;
        }
        return (A)this;
    }

    public A withFlags(String ... flags) {
        if (this.flags != null) {
            this.flags.clear();
            this._visitables.remove("flags");
        }
        if (flags != null) {
            for (String item : flags) {
                this.addToFlags(item);
            }
        }
        return (A)this;
    }

    public boolean hasFlags() {
        return this.flags != null && !this.flags.isEmpty();
    }

    public String getModel() {
        return this.model;
    }

    public A withModel(String model) {
        this.model = model;
        return (A)this;
    }

    public boolean hasModel() {
        return this.model != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CPUFluent that = (CPUFluent)o;
        if (!Objects.equals(this.arch, that.arch)) {
            return false;
        }
        if (!Objects.equals(this.clockMegahertz, that.clockMegahertz)) {
            return false;
        }
        if (!Objects.equals(this.count, that.count)) {
            return false;
        }
        if (!Objects.equals(this.flags, that.flags)) {
            return false;
        }
        if (!Objects.equals(this.model, that.model)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arch, this.clockMegahertz, this.count, this.flags, this.model, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arch != null) {
            sb.append("arch:");
            sb.append(this.arch + ",");
        }
        if (this.clockMegahertz != null) {
            sb.append("clockMegahertz:");
            sb.append(this.clockMegahertz + ",");
        }
        if (this.count != null) {
            sb.append("count:");
            sb.append(this.count + ",");
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            sb.append("flags:");
            sb.append(this.flags + ",");
        }
        if (this.model != null) {
            sb.append("model:");
            sb.append(this.model + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

