/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.installer.gcp.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_13.installer.gcp.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.v6_13.installer.gcp.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.v6_13.installer.gcp.v1.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private String computeSubnet;
    private String controlPlaneSubnet;
    private MachinePoolBuilder defaultMachinePlatform;
    private List<String> licenses = new ArrayList<String>();
    private String network;
    private String networkProjectID;
    private String projectID;
    private String region;
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withComputeSubnet(instance.getComputeSubnet());
            this.withControlPlaneSubnet(instance.getControlPlaneSubnet());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withLicenses(instance.getLicenses());
            this.withNetwork(instance.getNetwork());
            this.withNetworkProjectID(instance.getNetworkProjectID());
            this.withProjectID(instance.getProjectID());
            this.withRegion(instance.getRegion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getComputeSubnet() {
        return this.computeSubnet;
    }

    public A withComputeSubnet(String computeSubnet) {
        this.computeSubnet = computeSubnet;
        return (A)this;
    }

    public boolean hasComputeSubnet() {
        return this.computeSubnet != null;
    }

    public String getControlPlaneSubnet() {
        return this.controlPlaneSubnet;
    }

    public A withControlPlaneSubnet(String controlPlaneSubnet) {
        this.controlPlaneSubnet = controlPlaneSubnet;
        return (A)this;
    }

    public boolean hasControlPlaneSubnet() {
        return this.controlPlaneSubnet != null;
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove("defaultMachinePlatform");
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public A addToLicenses(int index, String item) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<String>();
        }
        this.licenses.add(index, item);
        return (A)this;
    }

    public A setToLicenses(int index, String item) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<String>();
        }
        this.licenses.set(index, item);
        return (A)this;
    }

    public A addToLicenses(String ... items) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<String>();
        }
        for (String item : items) {
            this.licenses.add(item);
        }
        return (A)this;
    }

    public A addAllToLicenses(Collection<String> items) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<String>();
        }
        for (String item : items) {
            this.licenses.add(item);
        }
        return (A)this;
    }

    public A removeFromLicenses(String ... items) {
        if (this.licenses == null) {
            return (A)this;
        }
        for (String item : items) {
            this.licenses.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromLicenses(Collection<String> items) {
        if (this.licenses == null) {
            return (A)this;
        }
        for (String item : items) {
            this.licenses.remove(item);
        }
        return (A)this;
    }

    public List<String> getLicenses() {
        return this.licenses;
    }

    public String getLicense(int index) {
        return this.licenses.get(index);
    }

    public String getFirstLicense() {
        return this.licenses.get(0);
    }

    public String getLastLicense() {
        return this.licenses.get(this.licenses.size() - 1);
    }

    public String getMatchingLicense(Predicate<String> predicate) {
        for (String item : this.licenses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingLicense(Predicate<String> predicate) {
        for (String item : this.licenses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLicenses(List<String> licenses) {
        if (licenses != null) {
            this.licenses = new ArrayList<String>();
            for (String item : licenses) {
                this.addToLicenses(item);
            }
        } else {
            this.licenses = null;
        }
        return (A)this;
    }

    public A withLicenses(String ... licenses) {
        if (this.licenses != null) {
            this.licenses.clear();
            this._visitables.remove("licenses");
        }
        if (licenses != null) {
            for (String item : licenses) {
                this.addToLicenses(item);
            }
        }
        return (A)this;
    }

    public boolean hasLicenses() {
        return this.licenses != null && !this.licenses.isEmpty();
    }

    public String getNetwork() {
        return this.network;
    }

    public A withNetwork(String network) {
        this.network = network;
        return (A)this;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public String getNetworkProjectID() {
        return this.networkProjectID;
    }

    public A withNetworkProjectID(String networkProjectID) {
        this.networkProjectID = networkProjectID;
        return (A)this;
    }

    public boolean hasNetworkProjectID() {
        return this.networkProjectID != null;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public A withProjectID(String projectID) {
        this.projectID = projectID;
        return (A)this;
    }

    public boolean hasProjectID() {
        return this.projectID != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)o;
        if (!Objects.equals(this.computeSubnet, that.computeSubnet)) {
            return false;
        }
        if (!Objects.equals(this.controlPlaneSubnet, that.controlPlaneSubnet)) {
            return false;
        }
        if (!Objects.equals(this.defaultMachinePlatform, that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.licenses, that.licenses)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.networkProjectID, that.networkProjectID)) {
            return false;
        }
        if (!Objects.equals(this.projectID, that.projectID)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.computeSubnet, this.controlPlaneSubnet, this.defaultMachinePlatform, this.licenses, this.network, this.networkProjectID, this.projectID, this.region, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeSubnet != null) {
            sb.append("computeSubnet:");
            sb.append(this.computeSubnet + ",");
        }
        if (this.controlPlaneSubnet != null) {
            sb.append("controlPlaneSubnet:");
            sb.append(this.controlPlaneSubnet + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.licenses != null && !this.licenses.isEmpty()) {
            sb.append("licenses:");
            sb.append(this.licenses + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.networkProjectID != null) {
            sb.append("networkProjectID:");
            sb.append(this.networkProjectID + ",");
        }
        if (this.projectID != null) {
            sb.append("projectID:");
            sb.append(this.projectID + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

