/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.hive.aws.v1.AwsMetadata;
import io.fabric8.openshift.api.model.v6_13.hive.aws.v1.AwsMetadataBuilder;
import io.fabric8.openshift.api.model.v6_13.hive.aws.v1.AwsMetadataFluent;
import io.fabric8.openshift.api.model.v6_13.hive.azure.v1.AzureMetadata;
import io.fabric8.openshift.api.model.v6_13.hive.azure.v1.AzureMetadataBuilder;
import io.fabric8.openshift.api.model.v6_13.hive.azure.v1.AzureMetadataFluent;
import io.fabric8.openshift.api.model.v6_13.hive.v1.ClusterPlatformMetadata;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClusterPlatformMetadataFluent<A extends ClusterPlatformMetadataFluent<A>>
extends BaseFluent<A> {
    private AwsMetadataBuilder aws;
    private AzureMetadataBuilder azure;
    private Map<String, Object> additionalProperties;

    public ClusterPlatformMetadataFluent() {
    }

    public ClusterPlatformMetadataFluent(ClusterPlatformMetadata instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterPlatformMetadata instance) {
        ClusterPlatformMetadata clusterPlatformMetadata = instance = instance != null ? instance : new ClusterPlatformMetadata();
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withAzure(instance.getAzure());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AwsMetadata buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    public A withAws(AwsMetadata aws) {
        this._visitables.remove("aws");
        if (aws != null) {
            this.aws = new AwsMetadataBuilder(aws);
            this._visitables.get("aws").add(this.aws);
        } else {
            this.aws = null;
            this._visitables.get("aws").remove(this.aws);
        }
        return (A)this;
    }

    public boolean hasAws() {
        return this.aws != null;
    }

    public A withNewAws(String hostedZoneRole) {
        return this.withAws(new AwsMetadata(hostedZoneRole));
    }

    public AwsNested<A> withNewAws() {
        return new AwsNested(null);
    }

    public AwsNested<A> withNewAwsLike(AwsMetadata item) {
        return new AwsNested(item);
    }

    public AwsNested<A> editAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(null));
    }

    public AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(new AwsMetadataBuilder().build()));
    }

    public AwsNested<A> editOrNewAwsLike(AwsMetadata item) {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(item));
    }

    public AzureMetadata buildAzure() {
        return this.azure != null ? this.azure.build() : null;
    }

    public A withAzure(AzureMetadata azure) {
        this._visitables.remove("azure");
        if (azure != null) {
            this.azure = new AzureMetadataBuilder(azure);
            this._visitables.get("azure").add(this.azure);
        } else {
            this.azure = null;
            this._visitables.get("azure").remove(this.azure);
        }
        return (A)this;
    }

    public boolean hasAzure() {
        return this.azure != null;
    }

    public A withNewAzure(String resourceGroupName) {
        return this.withAzure(new AzureMetadata(resourceGroupName));
    }

    public AzureNested<A> withNewAzure() {
        return new AzureNested(null);
    }

    public AzureNested<A> withNewAzureLike(AzureMetadata item) {
        return new AzureNested(item);
    }

    public AzureNested<A> editAzure() {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(null));
    }

    public AzureNested<A> editOrNewAzure() {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(new AzureMetadataBuilder().build()));
    }

    public AzureNested<A> editOrNewAzureLike(AzureMetadata item) {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterPlatformMetadataFluent that = (ClusterPlatformMetadataFluent)o;
        if (!Objects.equals(this.aws, that.aws)) {
            return false;
        }
        if (!Objects.equals(this.azure, that.azure)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aws, this.azure, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append(this.aws + ",");
        }
        if (this.azure != null) {
            sb.append("azure:");
            sb.append(this.azure + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AzureNested<N>
    extends AzureMetadataFluent<AzureNested<N>>
    implements Nested<N> {
        AzureMetadataBuilder builder;

        AzureNested(AzureMetadata item) {
            this.builder = new AzureMetadataBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPlatformMetadataFluent.this.withAzure(this.builder.build());
        }

        public N endAzure() {
            return this.and();
        }
    }

    public class AwsNested<N>
    extends AwsMetadataFluent<AwsNested<N>>
    implements Nested<N> {
        AwsMetadataBuilder builder;

        AwsNested(AwsMetadata item) {
            this.builder = new AwsMetadataBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPlatformMetadataFluent.this.withAws(this.builder.build());
        }

        public N endAws() {
            return this.and();
        }
    }
}

