/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_13;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.openshift.api.model.v6_13.BuildVolume;
import io.fabric8.openshift.api.model.v6_13.BuildVolumeMount;
import io.fabric8.openshift.api.model.v6_13.BuildVolumeMountBuilder;
import io.fabric8.openshift.api.model.v6_13.BuildVolumeMountFluent;
import io.fabric8.openshift.api.model.v6_13.BuildVolumeSource;
import io.fabric8.openshift.api.model.v6_13.BuildVolumeSourceBuilder;
import io.fabric8.openshift.api.model.v6_13.BuildVolumeSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BuildVolumeFluent<A extends BuildVolumeFluent<A>>
extends BaseFluent<A> {
    private ArrayList<BuildVolumeMountBuilder> mounts = new ArrayList();
    private String name;
    private BuildVolumeSourceBuilder source;
    private Map<String, Object> additionalProperties;

    public BuildVolumeFluent() {
    }

    public BuildVolumeFluent(BuildVolume instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BuildVolume instance) {
        BuildVolume buildVolume = instance = instance != null ? instance : new BuildVolume();
        if (instance != null) {
            this.withMounts(instance.getMounts());
            this.withName(instance.getName());
            this.withSource(instance.getSource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToMounts(int index, BuildVolumeMount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
        if (index < 0 || index >= this.mounts.size()) {
            this._visitables.get("mounts").add(builder);
            this.mounts.add(builder);
        } else {
            this._visitables.get("mounts").add(index, builder);
            this.mounts.add(index, builder);
        }
        return (A)this;
    }

    public A setToMounts(int index, BuildVolumeMount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
        if (index < 0 || index >= this.mounts.size()) {
            this._visitables.get("mounts").add(builder);
            this.mounts.add(builder);
        } else {
            this._visitables.get("mounts").set(index, builder);
            this.mounts.set(index, builder);
        }
        return (A)this;
    }

    public A addToMounts(BuildVolumeMount ... items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        for (BuildVolumeMount item : items) {
            BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
            this._visitables.get("mounts").add(builder);
            this.mounts.add(builder);
        }
        return (A)this;
    }

    public A addAllToMounts(Collection<BuildVolumeMount> items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        for (BuildVolumeMount item : items) {
            BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
            this._visitables.get("mounts").add(builder);
            this.mounts.add(builder);
        }
        return (A)this;
    }

    public A removeFromMounts(BuildVolumeMount ... items) {
        if (this.mounts == null) {
            return (A)this;
        }
        for (BuildVolumeMount item : items) {
            BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
            this._visitables.get("mounts").remove(builder);
            this.mounts.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMounts(Collection<BuildVolumeMount> items) {
        if (this.mounts == null) {
            return (A)this;
        }
        for (BuildVolumeMount item : items) {
            BuildVolumeMountBuilder builder = new BuildVolumeMountBuilder(item);
            this._visitables.get("mounts").remove(builder);
            this.mounts.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMounts(Predicate<BuildVolumeMountBuilder> predicate) {
        if (this.mounts == null) {
            return (A)this;
        }
        Iterator<BuildVolumeMountBuilder> each = this.mounts.iterator();
        Object visitables = this._visitables.get("mounts");
        while (each.hasNext()) {
            BuildVolumeMountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<BuildVolumeMount> buildMounts() {
        return this.mounts != null ? BuildVolumeFluent.build(this.mounts) : null;
    }

    public BuildVolumeMount buildMount(int index) {
        return this.mounts.get(index).build();
    }

    public BuildVolumeMount buildFirstMount() {
        return this.mounts.get(0).build();
    }

    public BuildVolumeMount buildLastMount() {
        return this.mounts.get(this.mounts.size() - 1).build();
    }

    public BuildVolumeMount buildMatchingMount(Predicate<BuildVolumeMountBuilder> predicate) {
        for (BuildVolumeMountBuilder item : this.mounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMount(Predicate<BuildVolumeMountBuilder> predicate) {
        for (BuildVolumeMountBuilder item : this.mounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMounts(List<BuildVolumeMount> mounts) {
        if (this.mounts != null) {
            this._visitables.get("mounts").clear();
        }
        if (mounts != null) {
            this.mounts = new ArrayList();
            for (BuildVolumeMount item : mounts) {
                this.addToMounts(item);
            }
        } else {
            this.mounts = null;
        }
        return (A)this;
    }

    public A withMounts(BuildVolumeMount ... mounts) {
        if (this.mounts != null) {
            this.mounts.clear();
            this._visitables.remove("mounts");
        }
        if (mounts != null) {
            for (BuildVolumeMount item : mounts) {
                this.addToMounts(item);
            }
        }
        return (A)this;
    }

    public boolean hasMounts() {
        return this.mounts != null && !this.mounts.isEmpty();
    }

    public A addNewMount(String destinationPath) {
        return this.addToMounts(new BuildVolumeMount(destinationPath));
    }

    public MountsNested<A> addNewMount() {
        return new MountsNested(-1, null);
    }

    public MountsNested<A> addNewMountLike(BuildVolumeMount item) {
        return new MountsNested(-1, item);
    }

    public MountsNested<A> setNewMountLike(int index, BuildVolumeMount item) {
        return new MountsNested(index, item);
    }

    public MountsNested<A> editMount(int index) {
        if (this.mounts.size() <= index) {
            throw new RuntimeException("Can't edit mounts. Index exceeds size.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    public MountsNested<A> editFirstMount() {
        if (this.mounts.size() == 0) {
            throw new RuntimeException("Can't edit first mounts. The list is empty.");
        }
        return this.setNewMountLike(0, this.buildMount(0));
    }

    public MountsNested<A> editLastMount() {
        int index = this.mounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last mounts. The list is empty.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    public MountsNested<A> editMatchingMount(Predicate<BuildVolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.mounts.size(); ++i) {
            if (!predicate.test(this.mounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching mounts. No match found.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public BuildVolumeSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(BuildVolumeSource source) {
        this._visitables.remove("source");
        if (source != null) {
            this.source = new BuildVolumeSourceBuilder(source);
            this._visitables.get("source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get("source").remove(this.source);
        }
        return (A)this;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(BuildVolumeSource item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new BuildVolumeSourceBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(BuildVolumeSource item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildVolumeFluent that = (BuildVolumeFluent)o;
        if (!Objects.equals(this.mounts, that.mounts)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mounts, this.name, this.source, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mounts != null && !this.mounts.isEmpty()) {
            sb.append("mounts:");
            sb.append(this.mounts + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SourceNested<N>
    extends BuildVolumeSourceFluent<SourceNested<N>>
    implements Nested<N> {
        BuildVolumeSourceBuilder builder;

        SourceNested(BuildVolumeSource item) {
            this.builder = new BuildVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildVolumeFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }

    public class MountsNested<N>
    extends BuildVolumeMountFluent<MountsNested<N>>
    implements Nested<N> {
        BuildVolumeMountBuilder builder;
        int index;

        MountsNested(int index, BuildVolumeMount item) {
            this.index = index;
            this.builder = new BuildVolumeMountBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildVolumeFluent.this.setToMounts(this.index, this.builder.build());
        }

        public N endMount() {
            return this.and();
        }
    }
}

