/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_13.dsl.internal;

import io.fabric8.kubernetes.api.model.v6_13.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_13.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v6_13.ListOptions;
import io.fabric8.kubernetes.api.model.v6_13.Status;
import io.fabric8.kubernetes.clnt.v6_13.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_13.Watcher;
import io.fabric8.kubernetes.clnt.v6_13.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.clnt.v6_13.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.clnt.v6_13.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.clnt.v6_13.dsl.internal.WatcherWebSocketListener;
import io.fabric8.kubernetes.clnt.v6_13.http.HttpClient;
import io.fabric8.kubernetes.clnt.v6_13.http.WebSocket;
import io.fabric8.kubernetes.clnt.v6_13.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.clnt.v6_13.http.WebSocketUpgradeResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class WatchConnectionManager<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends AbstractWatchManager<T> {
    private final long connectTimeoutMillis;
    protected WatcherWebSocketListener<T> listener;
    private volatile CompletableFuture<WebSocket> websocketFuture;
    volatile boolean ready;

    public WatchConnectionManager(HttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long websocketTimeout) throws MalformedURLException {
        super(watcher, baseOperation, listOptions, reconnectLimit, reconnectInterval, client);
        this.connectTimeoutMillis = websocketTimeout;
    }

    @Override
    protected void closeCurrentRequest() {
        Optional.ofNullable(this.websocketFuture).ifPresent(theFuture -> theFuture.whenComplete((w, t) -> Optional.ofNullable(w).ifPresent(ws -> ws.sendClose(1000, null))));
    }

    public CompletableFuture<WebSocket> getWebsocketFuture() {
        return this.websocketFuture;
    }

    @Override
    protected void start(URL url, Map<String, String> headers, AbstractWatchManager.WatchRequestState state) {
        this.listener = new WatcherWebSocketListener(this, state);
        WebSocket.Builder builder = this.client.newWebSocketBuilder();
        headers.forEach((arg_0, arg_1) -> ((WebSocket.Builder)builder).header(arg_0, arg_1));
        builder.uri(URI.create(url.toString())).connectTimeout(this.connectTimeoutMillis, TimeUnit.MILLISECONDS);
        this.websocketFuture = builder.buildAsync(this.listener).handle((w, t) -> {
            if (t != null) {
                try {
                    if (t instanceof WebSocketHandshakeException) {
                        WebSocketHandshakeException wshe = (WebSocketHandshakeException)t;
                        WebSocketUpgradeResponse response = wshe.getResponse();
                        int code = response.code();
                        Status status = OperationSupport.createStatus(response, this.baseOperation.getKubernetesSerialization());
                        t = OperationSupport.requestFailure(this.client.newHttpRequestBuilder().url(url).build(), status, "Received " + code + " on websocket");
                    }
                    throw KubernetesClientException.launderThrowable((Throwable)t);
                }
                catch (Throwable throwable) {
                    if (this.ready) {
                        this.watchEnded((Throwable)t, state);
                    }
                    throw throwable;
                }
            }
            this.ready = true;
            return w;
        });
    }
}

