/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.resource.v1alpha2.ResourceClaimParametersReference;
import io.fabric8.kubernetes.api.model.v6_13.resource.v1alpha2.ResourceClaimParametersReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_13.resource.v1alpha2.ResourceClaimParametersReferenceFluent;
import io.fabric8.kubernetes.api.model.v6_13.resource.v1alpha2.ResourceClaimSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceClaimSpecFluent<A extends ResourceClaimSpecFluent<A>>
extends BaseFluent<A> {
    private String allocationMode;
    private ResourceClaimParametersReferenceBuilder parametersRef;
    private String resourceClassName;
    private Map<String, Object> additionalProperties;

    public ResourceClaimSpecFluent() {
    }

    public ResourceClaimSpecFluent(ResourceClaimSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceClaimSpec instance) {
        ResourceClaimSpec resourceClaimSpec = instance = instance != null ? instance : new ResourceClaimSpec();
        if (instance != null) {
            this.withAllocationMode(instance.getAllocationMode());
            this.withParametersRef(instance.getParametersRef());
            this.withResourceClassName(instance.getResourceClassName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAllocationMode() {
        return this.allocationMode;
    }

    public A withAllocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
        return (A)this;
    }

    public boolean hasAllocationMode() {
        return this.allocationMode != null;
    }

    public ResourceClaimParametersReference buildParametersRef() {
        return this.parametersRef != null ? this.parametersRef.build() : null;
    }

    public A withParametersRef(ResourceClaimParametersReference parametersRef) {
        this._visitables.remove("parametersRef");
        if (parametersRef != null) {
            this.parametersRef = new ResourceClaimParametersReferenceBuilder(parametersRef);
            this._visitables.get("parametersRef").add(this.parametersRef);
        } else {
            this.parametersRef = null;
            this._visitables.get("parametersRef").remove(this.parametersRef);
        }
        return (A)this;
    }

    public boolean hasParametersRef() {
        return this.parametersRef != null;
    }

    public A withNewParametersRef(String apiGroup, String kind, String name) {
        return this.withParametersRef(new ResourceClaimParametersReference(apiGroup, kind, name));
    }

    public ParametersRefNested<A> withNewParametersRef() {
        return new ParametersRefNested(null);
    }

    public ParametersRefNested<A> withNewParametersRefLike(ResourceClaimParametersReference item) {
        return new ParametersRefNested(item);
    }

    public ParametersRefNested<A> editParametersRef() {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(null));
    }

    public ParametersRefNested<A> editOrNewParametersRef() {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(new ResourceClaimParametersReferenceBuilder().build()));
    }

    public ParametersRefNested<A> editOrNewParametersRefLike(ResourceClaimParametersReference item) {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(item));
    }

    public String getResourceClassName() {
        return this.resourceClassName;
    }

    public A withResourceClassName(String resourceClassName) {
        this.resourceClassName = resourceClassName;
        return (A)this;
    }

    public boolean hasResourceClassName() {
        return this.resourceClassName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceClaimSpecFluent that = (ResourceClaimSpecFluent)o;
        if (!Objects.equals(this.allocationMode, that.allocationMode)) {
            return false;
        }
        if (!Objects.equals(this.parametersRef, that.parametersRef)) {
            return false;
        }
        if (!Objects.equals(this.resourceClassName, that.resourceClassName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocationMode, this.parametersRef, this.resourceClassName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocationMode != null) {
            sb.append("allocationMode:");
            sb.append(this.allocationMode + ",");
        }
        if (this.parametersRef != null) {
            sb.append("parametersRef:");
            sb.append(this.parametersRef + ",");
        }
        if (this.resourceClassName != null) {
            sb.append("resourceClassName:");
            sb.append(this.resourceClassName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ParametersRefNested<N>
    extends ResourceClaimParametersReferenceFluent<ParametersRefNested<N>>
    implements Nested<N> {
        ResourceClaimParametersReferenceBuilder builder;

        ParametersRefNested(ResourceClaimParametersReference item) {
            this.builder = new ResourceClaimParametersReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceClaimSpecFluent.this.withParametersRef(this.builder.build());
        }

        public N endParametersRef() {
            return this.and();
        }
    }
}

