/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.node.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_13.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_13.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.v6_13.node.v1beta1.Overhead;
import io.fabric8.kubernetes.api.model.v6_13.node.v1beta1.OverheadBuilder;
import io.fabric8.kubernetes.api.model.v6_13.node.v1beta1.OverheadFluent;
import io.fabric8.kubernetes.api.model.v6_13.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.v6_13.node.v1beta1.Scheduling;
import io.fabric8.kubernetes.api.model.v6_13.node.v1beta1.SchedulingBuilder;
import io.fabric8.kubernetes.api.model.v6_13.node.v1beta1.SchedulingFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RuntimeClassFluent<A extends RuntimeClassFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String handler;
    private String kind;
    private ObjectMetaBuilder metadata;
    private OverheadBuilder overhead;
    private SchedulingBuilder scheduling;
    private Map<String, Object> additionalProperties;

    public RuntimeClassFluent() {
    }

    public RuntimeClassFluent(RuntimeClass instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RuntimeClass instance) {
        RuntimeClass runtimeClass = instance = instance != null ? instance : new RuntimeClass();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withHandler(instance.getHandler());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withOverhead(instance.getOverhead());
            this.withScheduling(instance.getScheduling());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getHandler() {
        return this.handler;
    }

    public A withHandler(String handler) {
        this.handler = handler;
        return (A)this;
    }

    public boolean hasHandler() {
        return this.handler != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public Overhead buildOverhead() {
        return this.overhead != null ? this.overhead.build() : null;
    }

    public A withOverhead(Overhead overhead) {
        this._visitables.remove("overhead");
        if (overhead != null) {
            this.overhead = new OverheadBuilder(overhead);
            this._visitables.get("overhead").add(this.overhead);
        } else {
            this.overhead = null;
            this._visitables.get("overhead").remove(this.overhead);
        }
        return (A)this;
    }

    public boolean hasOverhead() {
        return this.overhead != null;
    }

    public OverheadNested<A> withNewOverhead() {
        return new OverheadNested(null);
    }

    public OverheadNested<A> withNewOverheadLike(Overhead item) {
        return new OverheadNested(item);
    }

    public OverheadNested<A> editOverhead() {
        return this.withNewOverheadLike(Optional.ofNullable(this.buildOverhead()).orElse(null));
    }

    public OverheadNested<A> editOrNewOverhead() {
        return this.withNewOverheadLike(Optional.ofNullable(this.buildOverhead()).orElse(new OverheadBuilder().build()));
    }

    public OverheadNested<A> editOrNewOverheadLike(Overhead item) {
        return this.withNewOverheadLike(Optional.ofNullable(this.buildOverhead()).orElse(item));
    }

    public Scheduling buildScheduling() {
        return this.scheduling != null ? this.scheduling.build() : null;
    }

    public A withScheduling(Scheduling scheduling) {
        this._visitables.remove("scheduling");
        if (scheduling != null) {
            this.scheduling = new SchedulingBuilder(scheduling);
            this._visitables.get("scheduling").add(this.scheduling);
        } else {
            this.scheduling = null;
            this._visitables.get("scheduling").remove(this.scheduling);
        }
        return (A)this;
    }

    public boolean hasScheduling() {
        return this.scheduling != null;
    }

    public SchedulingNested<A> withNewScheduling() {
        return new SchedulingNested(null);
    }

    public SchedulingNested<A> withNewSchedulingLike(Scheduling item) {
        return new SchedulingNested(item);
    }

    public SchedulingNested<A> editScheduling() {
        return this.withNewSchedulingLike(Optional.ofNullable(this.buildScheduling()).orElse(null));
    }

    public SchedulingNested<A> editOrNewScheduling() {
        return this.withNewSchedulingLike(Optional.ofNullable(this.buildScheduling()).orElse(new SchedulingBuilder().build()));
    }

    public SchedulingNested<A> editOrNewSchedulingLike(Scheduling item) {
        return this.withNewSchedulingLike(Optional.ofNullable(this.buildScheduling()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuntimeClassFluent that = (RuntimeClassFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.handler, that.handler)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.overhead, that.overhead)) {
            return false;
        }
        if (!Objects.equals(this.scheduling, that.scheduling)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.handler, this.kind, this.metadata, this.overhead, this.scheduling, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.handler != null) {
            sb.append("handler:");
            sb.append(this.handler + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.overhead != null) {
            sb.append("overhead:");
            sb.append(this.overhead + ",");
        }
        if (this.scheduling != null) {
            sb.append("scheduling:");
            sb.append(this.scheduling + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SchedulingNested<N>
    extends SchedulingFluent<SchedulingNested<N>>
    implements Nested<N> {
        SchedulingBuilder builder;

        SchedulingNested(Scheduling item) {
            this.builder = new SchedulingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RuntimeClassFluent.this.withScheduling(this.builder.build());
        }

        public N endScheduling() {
            return this.and();
        }
    }

    public class OverheadNested<N>
    extends OverheadFluent<OverheadNested<N>>
    implements Nested<N> {
        OverheadBuilder builder;

        OverheadNested(Overhead item) {
            this.builder = new OverheadBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RuntimeClassFluent.this.withOverhead(this.builder.build());
        }

        public N endOverhead() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RuntimeClassFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

