/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.flowcontrol.v1beta3;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_13.flowcontrol.v1beta3.NonResourcePolicyRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NonResourcePolicyRuleFluent<A extends NonResourcePolicyRuleFluent<A>>
extends BaseFluent<A> {
    private List<String> nonResourceURLs = new ArrayList<String>();
    private List<String> verbs = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public NonResourcePolicyRuleFluent() {
    }

    public NonResourcePolicyRuleFluent(NonResourcePolicyRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NonResourcePolicyRule instance) {
        NonResourcePolicyRule nonResourcePolicyRule = instance = instance != null ? instance : new NonResourcePolicyRule();
        if (instance != null) {
            this.withNonResourceURLs(instance.getNonResourceURLs());
            this.withVerbs(instance.getVerbs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToNonResourceURLs(int index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(index, item);
        return (A)this;
    }

    public A setToNonResourceURLs(int index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.set(index, item);
        return (A)this;
    }

    public A addToNonResourceURLs(String ... items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    public A addAllToNonResourceURLs(Collection<String> items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    public A removeFromNonResourceURLs(String ... items) {
        if (this.nonResourceURLs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNonResourceURLs(Collection<String> items) {
        if (this.nonResourceURLs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    public String getNonResourceURL(int index) {
        return this.nonResourceURLs.get(index);
    }

    public String getFirstNonResourceURL() {
        return this.nonResourceURLs.get(0);
    }

    public String getLastNonResourceURL() {
        return this.nonResourceURLs.get(this.nonResourceURLs.size() - 1);
    }

    public String getMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNonResourceURLs(List<String> nonResourceURLs) {
        if (nonResourceURLs != null) {
            this.nonResourceURLs = new ArrayList<String>();
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        } else {
            this.nonResourceURLs = null;
        }
        return (A)this;
    }

    public A withNonResourceURLs(String ... nonResourceURLs) {
        if (this.nonResourceURLs != null) {
            this.nonResourceURLs.clear();
            this._visitables.remove("nonResourceURLs");
        }
        if (nonResourceURLs != null) {
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        }
        return (A)this;
    }

    public boolean hasNonResourceURLs() {
        return this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty();
    }

    public A addToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    public A setToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)this;
    }

    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    public A removeFromVerbs(String ... items) {
        if (this.verbs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.verbs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVerbs(Collection<String> items) {
        if (this.verbs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.verbs.remove(item);
        }
        return (A)this;
    }

    public List<String> getVerbs() {
        return this.verbs;
    }

    public String getVerb(int index) {
        return this.verbs.get(index);
    }

    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVerbs(List<String> verbs) {
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
            this._visitables.remove("verbs");
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    public boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NonResourcePolicyRuleFluent that = (NonResourcePolicyRuleFluent)o;
        if (!Objects.equals(this.nonResourceURLs, that.nonResourceURLs)) {
            return false;
        }
        if (!Objects.equals(this.verbs, that.verbs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonResourceURLs, this.verbs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty()) {
            sb.append("nonResourceURLs:");
            sb.append(this.nonResourceURLs + ",");
        }
        if (this.verbs != null && !this.verbs.isEmpty()) {
            sb.append("verbs:");
            sb.append(this.verbs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

