/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.extensions;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.extensions.IngressLoadBalancerIngress;
import io.fabric8.kubernetes.api.model.v6_13.extensions.IngressPortStatus;
import io.fabric8.kubernetes.api.model.v6_13.extensions.IngressPortStatusBuilder;
import io.fabric8.kubernetes.api.model.v6_13.extensions.IngressPortStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressLoadBalancerIngressFluent<A extends IngressLoadBalancerIngressFluent<A>>
extends BaseFluent<A> {
    private String hostname;
    private String ip;
    private ArrayList<IngressPortStatusBuilder> ports = new ArrayList();
    private Map<String, Object> additionalProperties;

    public IngressLoadBalancerIngressFluent() {
    }

    public IngressLoadBalancerIngressFluent(IngressLoadBalancerIngress instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressLoadBalancerIngress instance) {
        IngressLoadBalancerIngress ingressLoadBalancerIngress = instance = instance != null ? instance : new IngressLoadBalancerIngress();
        if (instance != null) {
            this.withHostname(instance.getHostname());
            this.withIp(instance.getIp());
            this.withPorts(instance.getPorts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public String getIp() {
        return this.ip;
    }

    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    public boolean hasIp() {
        return this.ip != null;
    }

    public A addToPorts(int index, IngressPortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        IngressPortStatusBuilder builder = new IngressPortStatusBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, IngressPortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        IngressPortStatusBuilder builder = new IngressPortStatusBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(IngressPortStatus ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (IngressPortStatus item : items) {
            IngressPortStatusBuilder builder = new IngressPortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<IngressPortStatus> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (IngressPortStatus item : items) {
            IngressPortStatusBuilder builder = new IngressPortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(IngressPortStatus ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (IngressPortStatus item : items) {
            IngressPortStatusBuilder builder = new IngressPortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<IngressPortStatus> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (IngressPortStatus item : items) {
            IngressPortStatusBuilder builder = new IngressPortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<IngressPortStatusBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<IngressPortStatusBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            IngressPortStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<IngressPortStatus> buildPorts() {
        return this.ports != null ? IngressLoadBalancerIngressFluent.build(this.ports) : null;
    }

    public IngressPortStatus buildPort(int index) {
        return this.ports.get(index).build();
    }

    public IngressPortStatus buildFirstPort() {
        return this.ports.get(0).build();
    }

    public IngressPortStatus buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public IngressPortStatus buildMatchingPort(Predicate<IngressPortStatusBuilder> predicate) {
        for (IngressPortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<IngressPortStatusBuilder> predicate) {
        for (IngressPortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<IngressPortStatus> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (IngressPortStatus item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(IngressPortStatus ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (IngressPortStatus item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public A addNewPort(String error, Integer port, String protocol) {
        return this.addToPorts(new IngressPortStatus(error, port, protocol));
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(IngressPortStatus item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, IngressPortStatus item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<IngressPortStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressLoadBalancerIngressFluent that = (IngressLoadBalancerIngressFluent)o;
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.ip, that.ip)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.ports, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortsNested<N>
    extends IngressPortStatusFluent<PortsNested<N>>
    implements Nested<N> {
        IngressPortStatusBuilder builder;
        int index;

        PortsNested(int index, IngressPortStatus item) {
            this.index = index;
            this.builder = new IngressPortStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressLoadBalancerIngressFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

