/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.batch.v1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_13.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v6_13.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.v6_13.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v6_13.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v6_13.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v6_13.batch.v1.JobSpec;
import io.fabric8.kubernetes.api.model.v6_13.batch.v1.PodFailurePolicy;
import io.fabric8.kubernetes.api.model.v6_13.batch.v1.PodFailurePolicyBuilder;
import io.fabric8.kubernetes.api.model.v6_13.batch.v1.PodFailurePolicyFluent;
import io.fabric8.kubernetes.api.model.v6_13.batch.v1.SuccessPolicy;
import io.fabric8.kubernetes.api.model.v6_13.batch.v1.SuccessPolicyBuilder;
import io.fabric8.kubernetes.api.model.v6_13.batch.v1.SuccessPolicyFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JobSpecFluent<A extends JobSpecFluent<A>>
extends BaseFluent<A> {
    private Long activeDeadlineSeconds;
    private Integer backoffLimit;
    private Integer backoffLimitPerIndex;
    private String completionMode;
    private Integer completions;
    private String managedBy;
    private Boolean manualSelector;
    private Integer maxFailedIndexes;
    private Integer parallelism;
    private PodFailurePolicyBuilder podFailurePolicy;
    private String podReplacementPolicy;
    private LabelSelectorBuilder selector;
    private SuccessPolicyBuilder successPolicy;
    private Boolean suspend;
    private PodTemplateSpecBuilder template;
    private Integer ttlSecondsAfterFinished;
    private Map<String, Object> additionalProperties;

    public JobSpecFluent() {
    }

    public JobSpecFluent(JobSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JobSpec instance) {
        JobSpec jobSpec = instance = instance != null ? instance : new JobSpec();
        if (instance != null) {
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
            this.withBackoffLimit(instance.getBackoffLimit());
            this.withBackoffLimitPerIndex(instance.getBackoffLimitPerIndex());
            this.withCompletionMode(instance.getCompletionMode());
            this.withCompletions(instance.getCompletions());
            this.withManagedBy(instance.getManagedBy());
            this.withManualSelector(instance.getManualSelector());
            this.withMaxFailedIndexes(instance.getMaxFailedIndexes());
            this.withParallelism(instance.getParallelism());
            this.withPodFailurePolicy(instance.getPodFailurePolicy());
            this.withPodReplacementPolicy(instance.getPodReplacementPolicy());
            this.withSelector(instance.getSelector());
            this.withSuccessPolicy(instance.getSuccessPolicy());
            this.withSuspend(instance.getSuspend());
            this.withTemplate(instance.getTemplate());
            this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    public boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public A withBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return (A)this;
    }

    public boolean hasBackoffLimit() {
        return this.backoffLimit != null;
    }

    public Integer getBackoffLimitPerIndex() {
        return this.backoffLimitPerIndex;
    }

    public A withBackoffLimitPerIndex(Integer backoffLimitPerIndex) {
        this.backoffLimitPerIndex = backoffLimitPerIndex;
        return (A)this;
    }

    public boolean hasBackoffLimitPerIndex() {
        return this.backoffLimitPerIndex != null;
    }

    public String getCompletionMode() {
        return this.completionMode;
    }

    public A withCompletionMode(String completionMode) {
        this.completionMode = completionMode;
        return (A)this;
    }

    public boolean hasCompletionMode() {
        return this.completionMode != null;
    }

    public Integer getCompletions() {
        return this.completions;
    }

    public A withCompletions(Integer completions) {
        this.completions = completions;
        return (A)this;
    }

    public boolean hasCompletions() {
        return this.completions != null;
    }

    public String getManagedBy() {
        return this.managedBy;
    }

    public A withManagedBy(String managedBy) {
        this.managedBy = managedBy;
        return (A)this;
    }

    public boolean hasManagedBy() {
        return this.managedBy != null;
    }

    public Boolean getManualSelector() {
        return this.manualSelector;
    }

    public A withManualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
        return (A)this;
    }

    public boolean hasManualSelector() {
        return this.manualSelector != null;
    }

    public Integer getMaxFailedIndexes() {
        return this.maxFailedIndexes;
    }

    public A withMaxFailedIndexes(Integer maxFailedIndexes) {
        this.maxFailedIndexes = maxFailedIndexes;
        return (A)this;
    }

    public boolean hasMaxFailedIndexes() {
        return this.maxFailedIndexes != null;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public A withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return (A)this;
    }

    public boolean hasParallelism() {
        return this.parallelism != null;
    }

    public PodFailurePolicy buildPodFailurePolicy() {
        return this.podFailurePolicy != null ? this.podFailurePolicy.build() : null;
    }

    public A withPodFailurePolicy(PodFailurePolicy podFailurePolicy) {
        this._visitables.remove("podFailurePolicy");
        if (podFailurePolicy != null) {
            this.podFailurePolicy = new PodFailurePolicyBuilder(podFailurePolicy);
            this._visitables.get("podFailurePolicy").add(this.podFailurePolicy);
        } else {
            this.podFailurePolicy = null;
            this._visitables.get("podFailurePolicy").remove(this.podFailurePolicy);
        }
        return (A)this;
    }

    public boolean hasPodFailurePolicy() {
        return this.podFailurePolicy != null;
    }

    public PodFailurePolicyNested<A> withNewPodFailurePolicy() {
        return new PodFailurePolicyNested(null);
    }

    public PodFailurePolicyNested<A> withNewPodFailurePolicyLike(PodFailurePolicy item) {
        return new PodFailurePolicyNested(item);
    }

    public PodFailurePolicyNested<A> editPodFailurePolicy() {
        return this.withNewPodFailurePolicyLike(Optional.ofNullable(this.buildPodFailurePolicy()).orElse(null));
    }

    public PodFailurePolicyNested<A> editOrNewPodFailurePolicy() {
        return this.withNewPodFailurePolicyLike(Optional.ofNullable(this.buildPodFailurePolicy()).orElse(new PodFailurePolicyBuilder().build()));
    }

    public PodFailurePolicyNested<A> editOrNewPodFailurePolicyLike(PodFailurePolicy item) {
        return this.withNewPodFailurePolicyLike(Optional.ofNullable(this.buildPodFailurePolicy()).orElse(item));
    }

    public String getPodReplacementPolicy() {
        return this.podReplacementPolicy;
    }

    public A withPodReplacementPolicy(String podReplacementPolicy) {
        this.podReplacementPolicy = podReplacementPolicy;
        return (A)this;
    }

    public boolean hasPodReplacementPolicy() {
        return this.podReplacementPolicy != null;
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove("selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public SuccessPolicy buildSuccessPolicy() {
        return this.successPolicy != null ? this.successPolicy.build() : null;
    }

    public A withSuccessPolicy(SuccessPolicy successPolicy) {
        this._visitables.remove("successPolicy");
        if (successPolicy != null) {
            this.successPolicy = new SuccessPolicyBuilder(successPolicy);
            this._visitables.get("successPolicy").add(this.successPolicy);
        } else {
            this.successPolicy = null;
            this._visitables.get("successPolicy").remove(this.successPolicy);
        }
        return (A)this;
    }

    public boolean hasSuccessPolicy() {
        return this.successPolicy != null;
    }

    public SuccessPolicyNested<A> withNewSuccessPolicy() {
        return new SuccessPolicyNested(null);
    }

    public SuccessPolicyNested<A> withNewSuccessPolicyLike(SuccessPolicy item) {
        return new SuccessPolicyNested(item);
    }

    public SuccessPolicyNested<A> editSuccessPolicy() {
        return this.withNewSuccessPolicyLike(Optional.ofNullable(this.buildSuccessPolicy()).orElse(null));
    }

    public SuccessPolicyNested<A> editOrNewSuccessPolicy() {
        return this.withNewSuccessPolicyLike(Optional.ofNullable(this.buildSuccessPolicy()).orElse(new SuccessPolicyBuilder().build()));
    }

    public SuccessPolicyNested<A> editOrNewSuccessPolicyLike(SuccessPolicy item) {
        return this.withNewSuccessPolicyLike(Optional.ofNullable(this.buildSuccessPolicy()).orElse(item));
    }

    public Boolean getSuspend() {
        return this.suspend;
    }

    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)this;
    }

    public boolean hasSuspend() {
        return this.suspend != null;
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove("template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return (A)this;
    }

    public boolean hasTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobSpecFluent that = (JobSpecFluent)o;
        if (!Objects.equals(this.activeDeadlineSeconds, that.activeDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.backoffLimit, that.backoffLimit)) {
            return false;
        }
        if (!Objects.equals(this.backoffLimitPerIndex, that.backoffLimitPerIndex)) {
            return false;
        }
        if (!Objects.equals(this.completionMode, that.completionMode)) {
            return false;
        }
        if (!Objects.equals(this.completions, that.completions)) {
            return false;
        }
        if (!Objects.equals(this.managedBy, that.managedBy)) {
            return false;
        }
        if (!Objects.equals(this.manualSelector, that.manualSelector)) {
            return false;
        }
        if (!Objects.equals(this.maxFailedIndexes, that.maxFailedIndexes)) {
            return false;
        }
        if (!Objects.equals(this.parallelism, that.parallelism)) {
            return false;
        }
        if (!Objects.equals(this.podFailurePolicy, that.podFailurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.podReplacementPolicy, that.podReplacementPolicy)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.successPolicy, that.successPolicy)) {
            return false;
        }
        if (!Objects.equals(this.suspend, that.suspend)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals(this.ttlSecondsAfterFinished, that.ttlSecondsAfterFinished)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.backoffLimit, this.backoffLimitPerIndex, this.completionMode, this.completions, this.managedBy, this.manualSelector, this.maxFailedIndexes, this.parallelism, this.podFailurePolicy, this.podReplacementPolicy, this.selector, this.successPolicy, this.suspend, this.template, this.ttlSecondsAfterFinished, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.backoffLimit != null) {
            sb.append("backoffLimit:");
            sb.append(this.backoffLimit + ",");
        }
        if (this.backoffLimitPerIndex != null) {
            sb.append("backoffLimitPerIndex:");
            sb.append(this.backoffLimitPerIndex + ",");
        }
        if (this.completionMode != null) {
            sb.append("completionMode:");
            sb.append(this.completionMode + ",");
        }
        if (this.completions != null) {
            sb.append("completions:");
            sb.append(this.completions + ",");
        }
        if (this.managedBy != null) {
            sb.append("managedBy:");
            sb.append(this.managedBy + ",");
        }
        if (this.manualSelector != null) {
            sb.append("manualSelector:");
            sb.append(this.manualSelector + ",");
        }
        if (this.maxFailedIndexes != null) {
            sb.append("maxFailedIndexes:");
            sb.append(this.maxFailedIndexes + ",");
        }
        if (this.parallelism != null) {
            sb.append("parallelism:");
            sb.append(this.parallelism + ",");
        }
        if (this.podFailurePolicy != null) {
            sb.append("podFailurePolicy:");
            sb.append(this.podFailurePolicy + ",");
        }
        if (this.podReplacementPolicy != null) {
            sb.append("podReplacementPolicy:");
            sb.append(this.podReplacementPolicy + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.successPolicy != null) {
            sb.append("successPolicy:");
            sb.append(this.successPolicy + ",");
        }
        if (this.suspend != null) {
            sb.append("suspend:");
            sb.append(this.suspend + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.ttlSecondsAfterFinished != null) {
            sb.append("ttlSecondsAfterFinished:");
            sb.append(this.ttlSecondsAfterFinished + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withManualSelector() {
        return this.withManualSelector(true);
    }

    public A withSuspend() {
        return this.withSuspend(true);
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)JobSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class SuccessPolicyNested<N>
    extends SuccessPolicyFluent<SuccessPolicyNested<N>>
    implements Nested<N> {
        SuccessPolicyBuilder builder;

        SuccessPolicyNested(SuccessPolicy item) {
            this.builder = new SuccessPolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)JobSpecFluent.this.withSuccessPolicy(this.builder.build());
        }

        public N endSuccessPolicy() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)JobSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class PodFailurePolicyNested<N>
    extends PodFailurePolicyFluent<PodFailurePolicyNested<N>>
    implements Nested<N> {
        PodFailurePolicyBuilder builder;

        PodFailurePolicyNested(PodFailurePolicy item) {
            this.builder = new PodFailurePolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)JobSpecFluent.this.withPodFailurePolicy(this.builder.build());
        }

        public N endPodFailurePolicy() {
            return this.and();
        }
    }
}

