/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_13.Nested;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1beta1.CustomResourceConversion;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1beta1.WebhookClientConfig;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1beta1.WebhookClientConfigBuilder;
import io.fabric8.kubernetes.api.model.v6_13.apiextensions.v1beta1.WebhookClientConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CustomResourceConversionFluent<A extends CustomResourceConversionFluent<A>>
extends BaseFluent<A> {
    private List<String> conversionReviewVersions = new ArrayList<String>();
    private String strategy;
    private WebhookClientConfigBuilder webhookClientConfig;
    private Map<String, Object> additionalProperties;

    public CustomResourceConversionFluent() {
    }

    public CustomResourceConversionFluent(CustomResourceConversion instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CustomResourceConversion instance) {
        CustomResourceConversion customResourceConversion = instance = instance != null ? instance : new CustomResourceConversion();
        if (instance != null) {
            this.withConversionReviewVersions(instance.getConversionReviewVersions());
            this.withStrategy(instance.getStrategy());
            this.withWebhookClientConfig(instance.getWebhookClientConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.set(index, item);
        return (A)this;
    }

    public A addToConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    public A removeFromConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    public String getConversionReviewVersion(int index) {
        return this.conversionReviewVersions.get(index);
    }

    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(this.conversionReviewVersions.size() - 1);
    }

    public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (conversionReviewVersions != null) {
            this.conversionReviewVersions = new ArrayList<String>();
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        } else {
            this.conversionReviewVersions = null;
        }
        return (A)this;
    }

    public A withConversionReviewVersions(String ... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {
            this.conversionReviewVersions.clear();
            this._visitables.remove("conversionReviewVersions");
        }
        if (conversionReviewVersions != null) {
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConversionReviewVersions() {
        return this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty();
    }

    public String getStrategy() {
        return this.strategy;
    }

    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public WebhookClientConfig buildWebhookClientConfig() {
        return this.webhookClientConfig != null ? this.webhookClientConfig.build() : null;
    }

    public A withWebhookClientConfig(WebhookClientConfig webhookClientConfig) {
        this._visitables.remove("webhookClientConfig");
        if (webhookClientConfig != null) {
            this.webhookClientConfig = new WebhookClientConfigBuilder(webhookClientConfig);
            this._visitables.get("webhookClientConfig").add(this.webhookClientConfig);
        } else {
            this.webhookClientConfig = null;
            this._visitables.get("webhookClientConfig").remove(this.webhookClientConfig);
        }
        return (A)this;
    }

    public boolean hasWebhookClientConfig() {
        return this.webhookClientConfig != null;
    }

    public WebhookClientConfigNested<A> withNewWebhookClientConfig() {
        return new WebhookClientConfigNested(null);
    }

    public WebhookClientConfigNested<A> withNewWebhookClientConfigLike(WebhookClientConfig item) {
        return new WebhookClientConfigNested(item);
    }

    public WebhookClientConfigNested<A> editWebhookClientConfig() {
        return this.withNewWebhookClientConfigLike(Optional.ofNullable(this.buildWebhookClientConfig()).orElse(null));
    }

    public WebhookClientConfigNested<A> editOrNewWebhookClientConfig() {
        return this.withNewWebhookClientConfigLike(Optional.ofNullable(this.buildWebhookClientConfig()).orElse(new WebhookClientConfigBuilder().build()));
    }

    public WebhookClientConfigNested<A> editOrNewWebhookClientConfigLike(WebhookClientConfig item) {
        return this.withNewWebhookClientConfigLike(Optional.ofNullable(this.buildWebhookClientConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceConversionFluent that = (CustomResourceConversionFluent)o;
        if (!Objects.equals(this.conversionReviewVersions, that.conversionReviewVersions)) {
            return false;
        }
        if (!Objects.equals(this.strategy, that.strategy)) {
            return false;
        }
        if (!Objects.equals(this.webhookClientConfig, that.webhookClientConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conversionReviewVersions, this.strategy, this.webhookClientConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty()) {
            sb.append("conversionReviewVersions:");
            sb.append(this.conversionReviewVersions + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.webhookClientConfig != null) {
            sb.append("webhookClientConfig:");
            sb.append(this.webhookClientConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WebhookClientConfigNested<N>
    extends WebhookClientConfigFluent<WebhookClientConfigNested<N>>
    implements Nested<N> {
        WebhookClientConfigBuilder builder;

        WebhookClientConfigNested(WebhookClientConfig item) {
            this.builder = new WebhookClientConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceConversionFluent.this.withWebhookClientConfig(this.builder.build());
        }

        public N endWebhookClientConfig() {
            return this.and();
        }
    }
}

