/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_13;

import io.fabric8.kubernetes.api.builder.v6_13.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_13.Capabilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CapabilitiesFluent<A extends CapabilitiesFluent<A>>
extends BaseFluent<A> {
    private List<String> add = new ArrayList<String>();
    private List<String> drop = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public CapabilitiesFluent() {
    }

    public CapabilitiesFluent(Capabilities instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Capabilities instance) {
        Capabilities capabilities = instance = instance != null ? instance : new Capabilities();
        if (instance != null) {
            this.withAdd(instance.getAdd());
            this.withDrop(instance.getDrop());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdd(int index, String item) {
        if (this.add == null) {
            this.add = new ArrayList<String>();
        }
        this.add.add(index, item);
        return (A)this;
    }

    public A setToAdd(int index, String item) {
        if (this.add == null) {
            this.add = new ArrayList<String>();
        }
        this.add.set(index, item);
        return (A)this;
    }

    public A addToAdd(String ... items) {
        if (this.add == null) {
            this.add = new ArrayList<String>();
        }
        for (String item : items) {
            this.add.add(item);
        }
        return (A)this;
    }

    public A addAllToAdd(Collection<String> items) {
        if (this.add == null) {
            this.add = new ArrayList<String>();
        }
        for (String item : items) {
            this.add.add(item);
        }
        return (A)this;
    }

    public A removeFromAdd(String ... items) {
        if (this.add == null) {
            return (A)this;
        }
        for (String item : items) {
            this.add.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAdd(Collection<String> items) {
        if (this.add == null) {
            return (A)this;
        }
        for (String item : items) {
            this.add.remove(item);
        }
        return (A)this;
    }

    public List<String> getAdd() {
        return this.add;
    }

    public String getAdd(int index) {
        return this.add.get(index);
    }

    public String getFirstAdd() {
        return this.add.get(0);
    }

    public String getLastAdd() {
        return this.add.get(this.add.size() - 1);
    }

    public String getMatchingAdd(Predicate<String> predicate) {
        for (String item : this.add) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAdd(Predicate<String> predicate) {
        for (String item : this.add) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdd(List<String> add) {
        if (add != null) {
            this.add = new ArrayList<String>();
            for (String item : add) {
                this.addToAdd(item);
            }
        } else {
            this.add = null;
        }
        return (A)this;
    }

    public A withAdd(String ... add) {
        if (this.add != null) {
            this.add.clear();
            this._visitables.remove("add");
        }
        if (add != null) {
            for (String item : add) {
                this.addToAdd(item);
            }
        }
        return (A)this;
    }

    public boolean hasAdd() {
        return this.add != null && !this.add.isEmpty();
    }

    public A addToDrop(int index, String item) {
        if (this.drop == null) {
            this.drop = new ArrayList<String>();
        }
        this.drop.add(index, item);
        return (A)this;
    }

    public A setToDrop(int index, String item) {
        if (this.drop == null) {
            this.drop = new ArrayList<String>();
        }
        this.drop.set(index, item);
        return (A)this;
    }

    public A addToDrop(String ... items) {
        if (this.drop == null) {
            this.drop = new ArrayList<String>();
        }
        for (String item : items) {
            this.drop.add(item);
        }
        return (A)this;
    }

    public A addAllToDrop(Collection<String> items) {
        if (this.drop == null) {
            this.drop = new ArrayList<String>();
        }
        for (String item : items) {
            this.drop.add(item);
        }
        return (A)this;
    }

    public A removeFromDrop(String ... items) {
        if (this.drop == null) {
            return (A)this;
        }
        for (String item : items) {
            this.drop.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromDrop(Collection<String> items) {
        if (this.drop == null) {
            return (A)this;
        }
        for (String item : items) {
            this.drop.remove(item);
        }
        return (A)this;
    }

    public List<String> getDrop() {
        return this.drop;
    }

    public String getDrop(int index) {
        return this.drop.get(index);
    }

    public String getFirstDrop() {
        return this.drop.get(0);
    }

    public String getLastDrop() {
        return this.drop.get(this.drop.size() - 1);
    }

    public String getMatchingDrop(Predicate<String> predicate) {
        for (String item : this.drop) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDrop(Predicate<String> predicate) {
        for (String item : this.drop) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDrop(List<String> drop) {
        if (drop != null) {
            this.drop = new ArrayList<String>();
            for (String item : drop) {
                this.addToDrop(item);
            }
        } else {
            this.drop = null;
        }
        return (A)this;
    }

    public A withDrop(String ... drop) {
        if (this.drop != null) {
            this.drop.clear();
            this._visitables.remove("drop");
        }
        if (drop != null) {
            for (String item : drop) {
                this.addToDrop(item);
            }
        }
        return (A)this;
    }

    public boolean hasDrop() {
        return this.drop != null && !this.drop.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CapabilitiesFluent that = (CapabilitiesFluent)o;
        if (!Objects.equals(this.add, that.add)) {
            return false;
        }
        if (!Objects.equals(this.drop, that.drop)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.add, this.drop, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.add != null && !this.add.isEmpty()) {
            sb.append("add:");
            sb.append(this.add + ",");
        }
        if (this.drop != null && !this.drop.isEmpty()) {
            sb.append("drop:");
            sb.append(this.drop + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

