/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v6_13;

import io.fabric8.kubernetes.api.builder.v6_13.DelegatingVisitor;
import io.fabric8.kubernetes.api.builder.v6_13.Visitor;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public final class Visitors {
    private Visitors() {
    }

    public static <T> Visitor<T> newVisitor(Class<T> type, Visitor<T> visitor) {
        return new DelegatingVisitor<T>(type, visitor);
    }

    protected static <T> List<Class> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        LinkedHashMap resolvedTypes = new LinkedHashMap();
        Type type = childClass;
        Class<?> cl = Visitors.getClass(type);
        while (cl != null && cl != Object.class && !baseClass.getName().equals(cl.getName())) {
            if (type instanceof Class) {
                Optional nextInterface;
                Class<T> c = type;
                Optional<Object> optional = nextInterface = baseClass.isInterface() ? Visitors.getMatchingInterface(baseClass, c.getGenericInterfaces()) : Optional.empty();
                type = nextInterface.isPresent() ? (Type)nextInterface.get() : type.getGenericSuperclass();
            } else if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type t = parameterizedType.getRawType();
                if (!(t instanceof Class)) break;
                Class rawType = (Class)parameterizedType.getRawType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
                }
                if (!baseClass.equals(rawType)) {
                    type = rawType.getGenericSuperclass();
                }
            }
            cl = Visitors.getClass(type);
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList<Class> typeArgumentsAsClasses = new ArrayList<Class>();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(Visitors.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    private static String getRawName(Type type) {
        return type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType().getTypeName() : type.getTypeName();
    }

    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Visitors.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = Visitors.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    private static <T> Optional<Type> getMatchingInterface(Class<?> targetInterface, Type ... candidates) {
        if (candidates == null || candidates.length == 0) {
            return Optional.empty();
        }
        Optional<Type> match = Arrays.stream(candidates).filter(c -> Visitors.getRawName(c).equals(targetInterface.getTypeName())).findFirst();
        if (match.isPresent()) {
            return match;
        }
        for (Type candidate : candidates) {
            Class c2;
            Optional<Type> next;
            if (!(candidate instanceof Class) || !(next = Visitors.getMatchingInterface(targetInterface, (c2 = (Class)candidate).getGenericInterfaces())).isPresent()) continue;
            return Optional.of(c2);
        }
        return Optional.empty();
    }
}

