/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.openshift.api.model.v6_12.operatorhub.v1alpha1.StatusDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StatusDescriptorFluent<A extends StatusDescriptorFluent<A>>
extends BaseFluent<A> {
    private String description;
    private String displayName;
    private String path;
    private String value;
    private List<String> xDescriptors = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public StatusDescriptorFluent() {
    }

    public StatusDescriptorFluent(StatusDescriptor instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StatusDescriptor instance) {
        StatusDescriptor statusDescriptor = instance = instance != null ? instance : new StatusDescriptor();
        if (instance != null) {
            this.withDescription(instance.getDescription());
            this.withDisplayName(instance.getDisplayName());
            this.withPath(instance.getPath());
            this.withValue(instance.getValue());
            this.withXDescriptors(instance.getXDescriptors());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)this;
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public A addToXDescriptors(int index, String item) {
        if (this.xDescriptors == null) {
            this.xDescriptors = new ArrayList<String>();
        }
        this.xDescriptors.add(index, item);
        return (A)this;
    }

    public A setToXDescriptors(int index, String item) {
        if (this.xDescriptors == null) {
            this.xDescriptors = new ArrayList<String>();
        }
        this.xDescriptors.set(index, item);
        return (A)this;
    }

    public A addToXDescriptors(String ... items) {
        if (this.xDescriptors == null) {
            this.xDescriptors = new ArrayList<String>();
        }
        for (String item : items) {
            this.xDescriptors.add(item);
        }
        return (A)this;
    }

    public A addAllToXDescriptors(Collection<String> items) {
        if (this.xDescriptors == null) {
            this.xDescriptors = new ArrayList<String>();
        }
        for (String item : items) {
            this.xDescriptors.add(item);
        }
        return (A)this;
    }

    public A removeFromXDescriptors(String ... items) {
        if (this.xDescriptors == null) {
            return (A)this;
        }
        for (String item : items) {
            this.xDescriptors.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromXDescriptors(Collection<String> items) {
        if (this.xDescriptors == null) {
            return (A)this;
        }
        for (String item : items) {
            this.xDescriptors.remove(item);
        }
        return (A)this;
    }

    public List<String> getXDescriptors() {
        return this.xDescriptors;
    }

    public String getXDescriptor(int index) {
        return this.xDescriptors.get(index);
    }

    public String getFirstXDescriptor() {
        return this.xDescriptors.get(0);
    }

    public String getLastXDescriptor() {
        return this.xDescriptors.get(this.xDescriptors.size() - 1);
    }

    public String getMatchingXDescriptor(Predicate<String> predicate) {
        for (String item : this.xDescriptors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingXDescriptor(Predicate<String> predicate) {
        for (String item : this.xDescriptors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withXDescriptors(List<String> xDescriptors) {
        if (xDescriptors != null) {
            this.xDescriptors = new ArrayList<String>();
            for (String item : xDescriptors) {
                this.addToXDescriptors(item);
            }
        } else {
            this.xDescriptors = null;
        }
        return (A)this;
    }

    public A withXDescriptors(String ... xDescriptors) {
        if (this.xDescriptors != null) {
            this.xDescriptors.clear();
            this._visitables.remove("xDescriptors");
        }
        if (xDescriptors != null) {
            for (String item : xDescriptors) {
                this.addToXDescriptors(item);
            }
        }
        return (A)this;
    }

    public boolean hasXDescriptors() {
        return this.xDescriptors != null && !this.xDescriptors.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusDescriptorFluent that = (StatusDescriptorFluent)o;
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.displayName, that.displayName)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        if (!Objects.equals(this.xDescriptors, that.xDescriptors)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.description, this.displayName, this.path, this.value, this.xDescriptors, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.displayName != null) {
            sb.append("displayName:");
            sb.append(this.displayName + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.xDescriptors != null && !this.xDescriptors.isEmpty()) {
            sb.append("xDescriptors:");
            sb.append(this.xDescriptors + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

