/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.openshift.api.model.v6_12.operator.v1.FeaturesMigration;
import io.fabric8.openshift.api.model.v6_12.operator.v1.FeaturesMigrationBuilder;
import io.fabric8.openshift.api.model.v6_12.operator.v1.FeaturesMigrationFluent;
import io.fabric8.openshift.api.model.v6_12.operator.v1.MTUMigration;
import io.fabric8.openshift.api.model.v6_12.operator.v1.MTUMigrationBuilder;
import io.fabric8.openshift.api.model.v6_12.operator.v1.MTUMigrationFluent;
import io.fabric8.openshift.api.model.v6_12.operator.v1.NetworkMigration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkMigrationFluent<A extends NetworkMigrationFluent<A>>
extends BaseFluent<A> {
    private FeaturesMigrationBuilder features;
    private MTUMigrationBuilder mtu;
    private String networkType;
    private Map<String, Object> additionalProperties;

    public NetworkMigrationFluent() {
    }

    public NetworkMigrationFluent(NetworkMigration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkMigration instance) {
        NetworkMigration networkMigration = instance = instance != null ? instance : new NetworkMigration();
        if (instance != null) {
            this.withFeatures(instance.getFeatures());
            this.withMtu(instance.getMtu());
            this.withNetworkType(instance.getNetworkType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FeaturesMigration buildFeatures() {
        return this.features != null ? this.features.build() : null;
    }

    public A withFeatures(FeaturesMigration features) {
        this._visitables.remove("features");
        if (features != null) {
            this.features = new FeaturesMigrationBuilder(features);
            this._visitables.get("features").add(this.features);
        } else {
            this.features = null;
            this._visitables.get("features").remove(this.features);
        }
        return (A)this;
    }

    public boolean hasFeatures() {
        return this.features != null;
    }

    public A withNewFeatures(Boolean egressFirewall, Boolean egressIP, Boolean multicast) {
        return this.withFeatures(new FeaturesMigration(egressFirewall, egressIP, multicast));
    }

    public FeaturesNested<A> withNewFeatures() {
        return new FeaturesNested(null);
    }

    public FeaturesNested<A> withNewFeaturesLike(FeaturesMigration item) {
        return new FeaturesNested(item);
    }

    public FeaturesNested<A> editFeatures() {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(null));
    }

    public FeaturesNested<A> editOrNewFeatures() {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(new FeaturesMigrationBuilder().build()));
    }

    public FeaturesNested<A> editOrNewFeaturesLike(FeaturesMigration item) {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(item));
    }

    public MTUMigration buildMtu() {
        return this.mtu != null ? this.mtu.build() : null;
    }

    public A withMtu(MTUMigration mtu) {
        this._visitables.remove("mtu");
        if (mtu != null) {
            this.mtu = new MTUMigrationBuilder(mtu);
            this._visitables.get("mtu").add(this.mtu);
        } else {
            this.mtu = null;
            this._visitables.get("mtu").remove(this.mtu);
        }
        return (A)this;
    }

    public boolean hasMtu() {
        return this.mtu != null;
    }

    public MtuNested<A> withNewMtu() {
        return new MtuNested(null);
    }

    public MtuNested<A> withNewMtuLike(MTUMigration item) {
        return new MtuNested(item);
    }

    public MtuNested<A> editMtu() {
        return this.withNewMtuLike(Optional.ofNullable(this.buildMtu()).orElse(null));
    }

    public MtuNested<A> editOrNewMtu() {
        return this.withNewMtuLike(Optional.ofNullable(this.buildMtu()).orElse(new MTUMigrationBuilder().build()));
    }

    public MtuNested<A> editOrNewMtuLike(MTUMigration item) {
        return this.withNewMtuLike(Optional.ofNullable(this.buildMtu()).orElse(item));
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public A withNetworkType(String networkType) {
        this.networkType = networkType;
        return (A)this;
    }

    public boolean hasNetworkType() {
        return this.networkType != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkMigrationFluent that = (NetworkMigrationFluent)o;
        if (!Objects.equals(this.features, that.features)) {
            return false;
        }
        if (!Objects.equals(this.mtu, that.mtu)) {
            return false;
        }
        if (!Objects.equals(this.networkType, that.networkType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.features, this.mtu, this.networkType, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.features != null) {
            sb.append("features:");
            sb.append(this.features + ",");
        }
        if (this.mtu != null) {
            sb.append("mtu:");
            sb.append(this.mtu + ",");
        }
        if (this.networkType != null) {
            sb.append("networkType:");
            sb.append(this.networkType + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MtuNested<N>
    extends MTUMigrationFluent<MtuNested<N>>
    implements Nested<N> {
        MTUMigrationBuilder builder;

        MtuNested(MTUMigration item) {
            this.builder = new MTUMigrationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkMigrationFluent.this.withMtu(this.builder.build());
        }

        public N endMtu() {
            return this.and();
        }
    }

    public class FeaturesNested<N>
    extends FeaturesMigrationFluent<FeaturesNested<N>>
    implements Nested<N> {
        FeaturesMigrationBuilder builder;

        FeaturesNested(FeaturesMigration item) {
            this.builder = new FeaturesMigrationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkMigrationFluent.this.withFeatures(this.builder.build());
        }

        public N endFeatures() {
            return this.and();
        }
    }
}

