/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.SecretKeySelector;
import io.fabric8.openshift.api.model.v6_12.monitoring.v1.SecretOrConfigMap;
import io.fabric8.openshift.api.model.v6_12.monitoring.v1.SecretOrConfigMapBuilder;
import io.fabric8.openshift.api.model.v6_12.monitoring.v1.SecretOrConfigMapFluent;
import io.fabric8.openshift.api.model.v6_12.monitoring.v1.WebTLSConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class WebTLSConfigFluent<A extends WebTLSConfigFluent<A>>
extends BaseFluent<A> {
    private SecretOrConfigMapBuilder cert;
    private List<String> cipherSuites = new ArrayList<String>();
    private String clientAuthType;
    private SecretOrConfigMapBuilder clientCa;
    private List<String> curvePreferences = new ArrayList<String>();
    private SecretKeySelector keySecret;
    private String maxVersion;
    private String minVersion;
    private Boolean preferServerCipherSuites;
    private Map<String, Object> additionalProperties;

    public WebTLSConfigFluent() {
    }

    public WebTLSConfigFluent(WebTLSConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WebTLSConfig instance) {
        WebTLSConfig webTLSConfig = instance = instance != null ? instance : new WebTLSConfig();
        if (instance != null) {
            this.withCert(instance.getCert());
            this.withCipherSuites(instance.getCipherSuites());
            this.withClientAuthType(instance.getClientAuthType());
            this.withClientCa(instance.getClientCa());
            this.withCurvePreferences(instance.getCurvePreferences());
            this.withKeySecret(instance.getKeySecret());
            this.withMaxVersion(instance.getMaxVersion());
            this.withMinVersion(instance.getMinVersion());
            this.withPreferServerCipherSuites(instance.getPreferServerCipherSuites());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretOrConfigMap buildCert() {
        return this.cert != null ? this.cert.build() : null;
    }

    public A withCert(SecretOrConfigMap cert) {
        this._visitables.remove("cert");
        if (cert != null) {
            this.cert = new SecretOrConfigMapBuilder(cert);
            this._visitables.get("cert").add(this.cert);
        } else {
            this.cert = null;
            this._visitables.get("cert").remove(this.cert);
        }
        return (A)this;
    }

    public boolean hasCert() {
        return this.cert != null;
    }

    public CertNested<A> withNewCert() {
        return new CertNested(null);
    }

    public CertNested<A> withNewCertLike(SecretOrConfigMap item) {
        return new CertNested(item);
    }

    public CertNested<A> editCert() {
        return this.withNewCertLike(Optional.ofNullable(this.buildCert()).orElse(null));
    }

    public CertNested<A> editOrNewCert() {
        return this.withNewCertLike(Optional.ofNullable(this.buildCert()).orElse(new SecretOrConfigMapBuilder().build()));
    }

    public CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
        return this.withNewCertLike(Optional.ofNullable(this.buildCert()).orElse(item));
    }

    public A addToCipherSuites(int index, String item) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        this.cipherSuites.add(index, item);
        return (A)this;
    }

    public A setToCipherSuites(int index, String item) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        this.cipherSuites.set(index, item);
        return (A)this;
    }

    public A addToCipherSuites(String ... items) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        for (String item : items) {
            this.cipherSuites.add(item);
        }
        return (A)this;
    }

    public A addAllToCipherSuites(Collection<String> items) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        for (String item : items) {
            this.cipherSuites.add(item);
        }
        return (A)this;
    }

    public A removeFromCipherSuites(String ... items) {
        if (this.cipherSuites == null) {
            return (A)this;
        }
        for (String item : items) {
            this.cipherSuites.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCipherSuites(Collection<String> items) {
        if (this.cipherSuites == null) {
            return (A)this;
        }
        for (String item : items) {
            this.cipherSuites.remove(item);
        }
        return (A)this;
    }

    public List<String> getCipherSuites() {
        return this.cipherSuites;
    }

    public String getCipherSuite(int index) {
        return this.cipherSuites.get(index);
    }

    public String getFirstCipherSuite() {
        return this.cipherSuites.get(0);
    }

    public String getLastCipherSuite() {
        return this.cipherSuites.get(this.cipherSuites.size() - 1);
    }

    public String getMatchingCipherSuite(Predicate<String> predicate) {
        for (String item : this.cipherSuites) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCipherSuite(Predicate<String> predicate) {
        for (String item : this.cipherSuites) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCipherSuites(List<String> cipherSuites) {
        if (cipherSuites != null) {
            this.cipherSuites = new ArrayList<String>();
            for (String item : cipherSuites) {
                this.addToCipherSuites(item);
            }
        } else {
            this.cipherSuites = null;
        }
        return (A)this;
    }

    public A withCipherSuites(String ... cipherSuites) {
        if (this.cipherSuites != null) {
            this.cipherSuites.clear();
            this._visitables.remove("cipherSuites");
        }
        if (cipherSuites != null) {
            for (String item : cipherSuites) {
                this.addToCipherSuites(item);
            }
        }
        return (A)this;
    }

    public boolean hasCipherSuites() {
        return this.cipherSuites != null && !this.cipherSuites.isEmpty();
    }

    public String getClientAuthType() {
        return this.clientAuthType;
    }

    public A withClientAuthType(String clientAuthType) {
        this.clientAuthType = clientAuthType;
        return (A)this;
    }

    public boolean hasClientAuthType() {
        return this.clientAuthType != null;
    }

    public SecretOrConfigMap buildClientCa() {
        return this.clientCa != null ? this.clientCa.build() : null;
    }

    public A withClientCa(SecretOrConfigMap clientCa) {
        this._visitables.remove("clientCa");
        if (clientCa != null) {
            this.clientCa = new SecretOrConfigMapBuilder(clientCa);
            this._visitables.get("clientCa").add(this.clientCa);
        } else {
            this.clientCa = null;
            this._visitables.get("clientCa").remove(this.clientCa);
        }
        return (A)this;
    }

    public boolean hasClientCa() {
        return this.clientCa != null;
    }

    public ClientCaNested<A> withNewClientCa() {
        return new ClientCaNested(null);
    }

    public ClientCaNested<A> withNewClientCaLike(SecretOrConfigMap item) {
        return new ClientCaNested(item);
    }

    public ClientCaNested<A> editClientCa() {
        return this.withNewClientCaLike(Optional.ofNullable(this.buildClientCa()).orElse(null));
    }

    public ClientCaNested<A> editOrNewClientCa() {
        return this.withNewClientCaLike(Optional.ofNullable(this.buildClientCa()).orElse(new SecretOrConfigMapBuilder().build()));
    }

    public ClientCaNested<A> editOrNewClientCaLike(SecretOrConfigMap item) {
        return this.withNewClientCaLike(Optional.ofNullable(this.buildClientCa()).orElse(item));
    }

    public A addToCurvePreferences(int index, String item) {
        if (this.curvePreferences == null) {
            this.curvePreferences = new ArrayList<String>();
        }
        this.curvePreferences.add(index, item);
        return (A)this;
    }

    public A setToCurvePreferences(int index, String item) {
        if (this.curvePreferences == null) {
            this.curvePreferences = new ArrayList<String>();
        }
        this.curvePreferences.set(index, item);
        return (A)this;
    }

    public A addToCurvePreferences(String ... items) {
        if (this.curvePreferences == null) {
            this.curvePreferences = new ArrayList<String>();
        }
        for (String item : items) {
            this.curvePreferences.add(item);
        }
        return (A)this;
    }

    public A addAllToCurvePreferences(Collection<String> items) {
        if (this.curvePreferences == null) {
            this.curvePreferences = new ArrayList<String>();
        }
        for (String item : items) {
            this.curvePreferences.add(item);
        }
        return (A)this;
    }

    public A removeFromCurvePreferences(String ... items) {
        if (this.curvePreferences == null) {
            return (A)this;
        }
        for (String item : items) {
            this.curvePreferences.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCurvePreferences(Collection<String> items) {
        if (this.curvePreferences == null) {
            return (A)this;
        }
        for (String item : items) {
            this.curvePreferences.remove(item);
        }
        return (A)this;
    }

    public List<String> getCurvePreferences() {
        return this.curvePreferences;
    }

    public String getCurvePreference(int index) {
        return this.curvePreferences.get(index);
    }

    public String getFirstCurvePreference() {
        return this.curvePreferences.get(0);
    }

    public String getLastCurvePreference() {
        return this.curvePreferences.get(this.curvePreferences.size() - 1);
    }

    public String getMatchingCurvePreference(Predicate<String> predicate) {
        for (String item : this.curvePreferences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCurvePreference(Predicate<String> predicate) {
        for (String item : this.curvePreferences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCurvePreferences(List<String> curvePreferences) {
        if (curvePreferences != null) {
            this.curvePreferences = new ArrayList<String>();
            for (String item : curvePreferences) {
                this.addToCurvePreferences(item);
            }
        } else {
            this.curvePreferences = null;
        }
        return (A)this;
    }

    public A withCurvePreferences(String ... curvePreferences) {
        if (this.curvePreferences != null) {
            this.curvePreferences.clear();
            this._visitables.remove("curvePreferences");
        }
        if (curvePreferences != null) {
            for (String item : curvePreferences) {
                this.addToCurvePreferences(item);
            }
        }
        return (A)this;
    }

    public boolean hasCurvePreferences() {
        return this.curvePreferences != null && !this.curvePreferences.isEmpty();
    }

    public SecretKeySelector getKeySecret() {
        return this.keySecret;
    }

    public A withKeySecret(SecretKeySelector keySecret) {
        this.keySecret = keySecret;
        return (A)this;
    }

    public boolean hasKeySecret() {
        return this.keySecret != null;
    }

    public A withNewKeySecret(String key, String name, Boolean optional) {
        return this.withKeySecret(new SecretKeySelector(key, name, optional));
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public A withMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
        return (A)this;
    }

    public boolean hasMaxVersion() {
        return this.maxVersion != null;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public A withMinVersion(String minVersion) {
        this.minVersion = minVersion;
        return (A)this;
    }

    public boolean hasMinVersion() {
        return this.minVersion != null;
    }

    public Boolean getPreferServerCipherSuites() {
        return this.preferServerCipherSuites;
    }

    public A withPreferServerCipherSuites(Boolean preferServerCipherSuites) {
        this.preferServerCipherSuites = preferServerCipherSuites;
        return (A)this;
    }

    public boolean hasPreferServerCipherSuites() {
        return this.preferServerCipherSuites != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebTLSConfigFluent that = (WebTLSConfigFluent)o;
        if (!Objects.equals(this.cert, that.cert)) {
            return false;
        }
        if (!Objects.equals(this.cipherSuites, that.cipherSuites)) {
            return false;
        }
        if (!Objects.equals(this.clientAuthType, that.clientAuthType)) {
            return false;
        }
        if (!Objects.equals(this.clientCa, that.clientCa)) {
            return false;
        }
        if (!Objects.equals(this.curvePreferences, that.curvePreferences)) {
            return false;
        }
        if (!Objects.equals(this.keySecret, that.keySecret)) {
            return false;
        }
        if (!Objects.equals(this.maxVersion, that.maxVersion)) {
            return false;
        }
        if (!Objects.equals(this.minVersion, that.minVersion)) {
            return false;
        }
        if (!Objects.equals(this.preferServerCipherSuites, that.preferServerCipherSuites)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cert, this.cipherSuites, this.clientAuthType, this.clientCa, this.curvePreferences, this.keySecret, this.maxVersion, this.minVersion, this.preferServerCipherSuites, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cert != null) {
            sb.append("cert:");
            sb.append(this.cert + ",");
        }
        if (this.cipherSuites != null && !this.cipherSuites.isEmpty()) {
            sb.append("cipherSuites:");
            sb.append(this.cipherSuites + ",");
        }
        if (this.clientAuthType != null) {
            sb.append("clientAuthType:");
            sb.append(this.clientAuthType + ",");
        }
        if (this.clientCa != null) {
            sb.append("clientCa:");
            sb.append(this.clientCa + ",");
        }
        if (this.curvePreferences != null && !this.curvePreferences.isEmpty()) {
            sb.append("curvePreferences:");
            sb.append(this.curvePreferences + ",");
        }
        if (this.keySecret != null) {
            sb.append("keySecret:");
            sb.append(this.keySecret + ",");
        }
        if (this.maxVersion != null) {
            sb.append("maxVersion:");
            sb.append(this.maxVersion + ",");
        }
        if (this.minVersion != null) {
            sb.append("minVersion:");
            sb.append(this.minVersion + ",");
        }
        if (this.preferServerCipherSuites != null) {
            sb.append("preferServerCipherSuites:");
            sb.append(this.preferServerCipherSuites + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withPreferServerCipherSuites() {
        return this.withPreferServerCipherSuites(true);
    }

    public class ClientCaNested<N>
    extends SecretOrConfigMapFluent<ClientCaNested<N>>
    implements Nested<N> {
        SecretOrConfigMapBuilder builder;

        ClientCaNested(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)WebTLSConfigFluent.this.withClientCa(this.builder.build());
        }

        public N endClientCa() {
            return this.and();
        }
    }

    public class CertNested<N>
    extends SecretOrConfigMapFluent<CertNested<N>>
    implements Nested<N> {
        SecretOrConfigMapBuilder builder;

        CertNested(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)WebTLSConfigFluent.this.withCert(this.builder.build());
        }

        public N endCert() {
            return this.and();
        }
    }
}

