/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.SecretKeySelector;
import io.fabric8.openshift.api.model.v6_12.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.v6_12.monitoring.v1.SecretOrConfigMap;
import io.fabric8.openshift.api.model.v6_12.monitoring.v1.SecretOrConfigMapBuilder;
import io.fabric8.openshift.api.model.v6_12.monitoring.v1.SecretOrConfigMapFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OAuth2Fluent<A extends OAuth2Fluent<A>>
extends BaseFluent<A> {
    private SecretOrConfigMapBuilder clientId;
    private SecretKeySelector clientSecret;
    private Map<String, String> endpointParams;
    private List<String> scopes = new ArrayList<String>();
    private String tokenUrl;
    private Map<String, Object> additionalProperties;

    public OAuth2Fluent() {
    }

    public OAuth2Fluent(OAuth2 instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OAuth2 instance) {
        OAuth2 oAuth2 = instance = instance != null ? instance : new OAuth2();
        if (instance != null) {
            this.withClientId(instance.getClientId());
            this.withClientSecret(instance.getClientSecret());
            this.withEndpointParams(instance.getEndpointParams());
            this.withScopes(instance.getScopes());
            this.withTokenUrl(instance.getTokenUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretOrConfigMap buildClientId() {
        return this.clientId != null ? this.clientId.build() : null;
    }

    public A withClientId(SecretOrConfigMap clientId) {
        this._visitables.remove("clientId");
        if (clientId != null) {
            this.clientId = new SecretOrConfigMapBuilder(clientId);
            this._visitables.get("clientId").add(this.clientId);
        } else {
            this.clientId = null;
            this._visitables.get("clientId").remove(this.clientId);
        }
        return (A)this;
    }

    public boolean hasClientId() {
        return this.clientId != null;
    }

    public ClientIdNested<A> withNewClientId() {
        return new ClientIdNested(null);
    }

    public ClientIdNested<A> withNewClientIdLike(SecretOrConfigMap item) {
        return new ClientIdNested(item);
    }

    public ClientIdNested<A> editClientId() {
        return this.withNewClientIdLike(Optional.ofNullable(this.buildClientId()).orElse(null));
    }

    public ClientIdNested<A> editOrNewClientId() {
        return this.withNewClientIdLike(Optional.ofNullable(this.buildClientId()).orElse(new SecretOrConfigMapBuilder().build()));
    }

    public ClientIdNested<A> editOrNewClientIdLike(SecretOrConfigMap item) {
        return this.withNewClientIdLike(Optional.ofNullable(this.buildClientId()).orElse(item));
    }

    public SecretKeySelector getClientSecret() {
        return this.clientSecret;
    }

    public A withClientSecret(SecretKeySelector clientSecret) {
        this.clientSecret = clientSecret;
        return (A)this;
    }

    public boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public A withNewClientSecret(String key, String name, Boolean optional) {
        return this.withClientSecret(new SecretKeySelector(key, name, optional));
    }

    public A addToEndpointParams(String key, String value) {
        if (this.endpointParams == null && key != null && value != null) {
            this.endpointParams = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.endpointParams.put(key, value);
        }
        return (A)this;
    }

    public A addToEndpointParams(Map<String, String> map) {
        if (this.endpointParams == null && map != null) {
            this.endpointParams = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.endpointParams.putAll(map);
        }
        return (A)this;
    }

    public A removeFromEndpointParams(String key) {
        if (this.endpointParams == null) {
            return (A)this;
        }
        if (key != null && this.endpointParams != null) {
            this.endpointParams.remove(key);
        }
        return (A)this;
    }

    public A removeFromEndpointParams(Map<String, String> map) {
        if (this.endpointParams == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.endpointParams == null) continue;
                this.endpointParams.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getEndpointParams() {
        return this.endpointParams;
    }

    public <K, V> A withEndpointParams(Map<String, String> endpointParams) {
        this.endpointParams = endpointParams == null ? null : new LinkedHashMap<String, String>(endpointParams);
        return (A)this;
    }

    public boolean hasEndpointParams() {
        return this.endpointParams != null;
    }

    public A addToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)this;
    }

    public A setToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)this;
    }

    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    public A removeFromScopes(String ... items) {
        if (this.scopes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromScopes(Collection<String> items) {
        if (this.scopes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getScope(int index) {
        return this.scopes.get(index);
    }

    public String getFirstScope() {
        return this.scopes.get(0);
    }

    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withScopes(List<String> scopes) {
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = null;
        }
        return (A)this;
    }

    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
            this._visitables.remove("scopes");
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    public boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public A withTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return (A)this;
    }

    public boolean hasTokenUrl() {
        return this.tokenUrl != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuth2Fluent that = (OAuth2Fluent)o;
        if (!Objects.equals(this.clientId, that.clientId)) {
            return false;
        }
        if (!Objects.equals(this.clientSecret, that.clientSecret)) {
            return false;
        }
        if (!Objects.equals(this.endpointParams, that.endpointParams)) {
            return false;
        }
        if (!Objects.equals(this.scopes, that.scopes)) {
            return false;
        }
        if (!Objects.equals(this.tokenUrl, that.tokenUrl)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.endpointParams, this.scopes, this.tokenUrl, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientId != null) {
            sb.append("clientId:");
            sb.append(this.clientId + ",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append(this.clientSecret + ",");
        }
        if (this.endpointParams != null && !this.endpointParams.isEmpty()) {
            sb.append("endpointParams:");
            sb.append(this.endpointParams + ",");
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            sb.append("scopes:");
            sb.append(this.scopes + ",");
        }
        if (this.tokenUrl != null) {
            sb.append("tokenUrl:");
            sb.append(this.tokenUrl + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClientIdNested<N>
    extends SecretOrConfigMapFluent<ClientIdNested<N>>
    implements Nested<N> {
        SecretOrConfigMapBuilder builder;

        ClientIdNested(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OAuth2Fluent.this.withClientId(this.builder.build());
        }

        public N endClientId() {
            return this.and();
        }
    }
}

