/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.openshift.api.model.v6_12.miscellaneous.metal3.v1alpha1.HardwareRAIDVolume;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HardwareRAIDVolumeFluent<A extends HardwareRAIDVolumeFluent<A>>
extends BaseFluent<A> {
    private String controller;
    private String level;
    private String name;
    private Integer numberOfPhysicalDisks;
    private List<String> physicalDisks = new ArrayList<String>();
    private Boolean rotational;
    private Integer sizeGibibytes;
    private Map<String, Object> additionalProperties;

    public HardwareRAIDVolumeFluent() {
    }

    public HardwareRAIDVolumeFluent(HardwareRAIDVolume instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HardwareRAIDVolume instance) {
        HardwareRAIDVolume hardwareRAIDVolume = instance = instance != null ? instance : new HardwareRAIDVolume();
        if (instance != null) {
            this.withController(instance.getController());
            this.withLevel(instance.getLevel());
            this.withName(instance.getName());
            this.withNumberOfPhysicalDisks(instance.getNumberOfPhysicalDisks());
            this.withPhysicalDisks(instance.getPhysicalDisks());
            this.withRotational(instance.getRotational());
            this.withSizeGibibytes(instance.getSizeGibibytes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getController() {
        return this.controller;
    }

    public A withController(String controller) {
        this.controller = controller;
        return (A)this;
    }

    public boolean hasController() {
        return this.controller != null;
    }

    public String getLevel() {
        return this.level;
    }

    public A withLevel(String level) {
        this.level = level;
        return (A)this;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Integer getNumberOfPhysicalDisks() {
        return this.numberOfPhysicalDisks;
    }

    public A withNumberOfPhysicalDisks(Integer numberOfPhysicalDisks) {
        this.numberOfPhysicalDisks = numberOfPhysicalDisks;
        return (A)this;
    }

    public boolean hasNumberOfPhysicalDisks() {
        return this.numberOfPhysicalDisks != null;
    }

    public A addToPhysicalDisks(int index, String item) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList<String>();
        }
        this.physicalDisks.add(index, item);
        return (A)this;
    }

    public A setToPhysicalDisks(int index, String item) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList<String>();
        }
        this.physicalDisks.set(index, item);
        return (A)this;
    }

    public A addToPhysicalDisks(String ... items) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList<String>();
        }
        for (String item : items) {
            this.physicalDisks.add(item);
        }
        return (A)this;
    }

    public A addAllToPhysicalDisks(Collection<String> items) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList<String>();
        }
        for (String item : items) {
            this.physicalDisks.add(item);
        }
        return (A)this;
    }

    public A removeFromPhysicalDisks(String ... items) {
        if (this.physicalDisks == null) {
            return (A)this;
        }
        for (String item : items) {
            this.physicalDisks.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPhysicalDisks(Collection<String> items) {
        if (this.physicalDisks == null) {
            return (A)this;
        }
        for (String item : items) {
            this.physicalDisks.remove(item);
        }
        return (A)this;
    }

    public List<String> getPhysicalDisks() {
        return this.physicalDisks;
    }

    public String getPhysicalDisk(int index) {
        return this.physicalDisks.get(index);
    }

    public String getFirstPhysicalDisk() {
        return this.physicalDisks.get(0);
    }

    public String getLastPhysicalDisk() {
        return this.physicalDisks.get(this.physicalDisks.size() - 1);
    }

    public String getMatchingPhysicalDisk(Predicate<String> predicate) {
        for (String item : this.physicalDisks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPhysicalDisk(Predicate<String> predicate) {
        for (String item : this.physicalDisks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPhysicalDisks(List<String> physicalDisks) {
        if (physicalDisks != null) {
            this.physicalDisks = new ArrayList<String>();
            for (String item : physicalDisks) {
                this.addToPhysicalDisks(item);
            }
        } else {
            this.physicalDisks = null;
        }
        return (A)this;
    }

    public A withPhysicalDisks(String ... physicalDisks) {
        if (this.physicalDisks != null) {
            this.physicalDisks.clear();
            this._visitables.remove("physicalDisks");
        }
        if (physicalDisks != null) {
            for (String item : physicalDisks) {
                this.addToPhysicalDisks(item);
            }
        }
        return (A)this;
    }

    public boolean hasPhysicalDisks() {
        return this.physicalDisks != null && !this.physicalDisks.isEmpty();
    }

    public Boolean getRotational() {
        return this.rotational;
    }

    public A withRotational(Boolean rotational) {
        this.rotational = rotational;
        return (A)this;
    }

    public boolean hasRotational() {
        return this.rotational != null;
    }

    public Integer getSizeGibibytes() {
        return this.sizeGibibytes;
    }

    public A withSizeGibibytes(Integer sizeGibibytes) {
        this.sizeGibibytes = sizeGibibytes;
        return (A)this;
    }

    public boolean hasSizeGibibytes() {
        return this.sizeGibibytes != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HardwareRAIDVolumeFluent that = (HardwareRAIDVolumeFluent)o;
        if (!Objects.equals(this.controller, that.controller)) {
            return false;
        }
        if (!Objects.equals(this.level, that.level)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.numberOfPhysicalDisks, that.numberOfPhysicalDisks)) {
            return false;
        }
        if (!Objects.equals(this.physicalDisks, that.physicalDisks)) {
            return false;
        }
        if (!Objects.equals(this.rotational, that.rotational)) {
            return false;
        }
        if (!Objects.equals(this.sizeGibibytes, that.sizeGibibytes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.controller, this.level, this.name, this.numberOfPhysicalDisks, this.physicalDisks, this.rotational, this.sizeGibibytes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.controller != null) {
            sb.append("controller:");
            sb.append(this.controller + ",");
        }
        if (this.level != null) {
            sb.append("level:");
            sb.append(this.level + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.numberOfPhysicalDisks != null) {
            sb.append("numberOfPhysicalDisks:");
            sb.append(this.numberOfPhysicalDisks + ",");
        }
        if (this.physicalDisks != null && !this.physicalDisks.isEmpty()) {
            sb.append("physicalDisks:");
            sb.append(this.physicalDisks + ",");
        }
        if (this.rotational != null) {
            sb.append("rotational:");
            sb.append(this.rotational + ",");
        }
        if (this.sizeGibibytes != null) {
            sb.append("sizeGibibytes:");
            sb.append(this.sizeGibibytes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withRotational() {
        return this.withRotational(true);
    }
}

