/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12.hive.openstack.v1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.openshift.api.model.v6_12.hive.openstack.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_12.hive.openstack.v1.RootVolume;
import io.fabric8.openshift.api.model.v6_12.hive.openstack.v1.RootVolumeBuilder;
import io.fabric8.openshift.api.model.v6_12.hive.openstack.v1.RootVolumeFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private String flavor;
    private RootVolumeBuilder rootVolume;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withFlavor(instance.getFlavor());
            this.withRootVolume(instance.getRootVolume());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getFlavor() {
        return this.flavor;
    }

    public A withFlavor(String flavor) {
        this.flavor = flavor;
        return (A)this;
    }

    public boolean hasFlavor() {
        return this.flavor != null;
    }

    public RootVolume buildRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    public A withRootVolume(RootVolume rootVolume) {
        this._visitables.remove("rootVolume");
        if (rootVolume != null) {
            this.rootVolume = new RootVolumeBuilder(rootVolume);
            this._visitables.get("rootVolume").add(this.rootVolume);
        } else {
            this.rootVolume = null;
            this._visitables.get("rootVolume").remove(this.rootVolume);
        }
        return (A)this;
    }

    public boolean hasRootVolume() {
        return this.rootVolume != null;
    }

    public A withNewRootVolume(Integer size, String type) {
        return this.withRootVolume(new RootVolume(size, type));
    }

    public RootVolumeNested<A> withNewRootVolume() {
        return new RootVolumeNested(null);
    }

    public RootVolumeNested<A> withNewRootVolumeLike(RootVolume item) {
        return new RootVolumeNested(item);
    }

    public RootVolumeNested<A> editRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(null));
    }

    public RootVolumeNested<A> editOrNewRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(new RootVolumeBuilder().build()));
    }

    public RootVolumeNested<A> editOrNewRootVolumeLike(RootVolume item) {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.flavor, that.flavor)) {
            return false;
        }
        if (!Objects.equals(this.rootVolume, that.rootVolume)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.flavor, this.rootVolume, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.flavor != null) {
            sb.append("flavor:");
            sb.append(this.flavor + ",");
        }
        if (this.rootVolume != null) {
            sb.append("rootVolume:");
            sb.append(this.rootVolume + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RootVolumeNested<N>
    extends RootVolumeFluent<RootVolumeNested<N>>
    implements Nested<N> {
        RootVolumeBuilder builder;

        RootVolumeNested(RootVolume item) {
            this.builder = new RootVolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withRootVolume(this.builder.build());
        }

        public N endRootVolume() {
            return this.and();
        }
    }
}

