/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12.config.v1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.openshift.api.model.v6_12.config.v1.AuthenticationSpec;
import io.fabric8.openshift.api.model.v6_12.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v6_12.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_12.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.v6_12.config.v1.DeprecatedWebhookTokenAuthenticator;
import io.fabric8.openshift.api.model.v6_12.config.v1.DeprecatedWebhookTokenAuthenticatorBuilder;
import io.fabric8.openshift.api.model.v6_12.config.v1.DeprecatedWebhookTokenAuthenticatorFluent;
import io.fabric8.openshift.api.model.v6_12.config.v1.WebhookTokenAuthenticator;
import io.fabric8.openshift.api.model.v6_12.config.v1.WebhookTokenAuthenticatorBuilder;
import io.fabric8.openshift.api.model.v6_12.config.v1.WebhookTokenAuthenticatorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AuthenticationSpecFluent<A extends AuthenticationSpecFluent<A>>
extends BaseFluent<A> {
    private ConfigMapNameReferenceBuilder oauthMetadata;
    private String serviceAccountIssuer;
    private String type;
    private WebhookTokenAuthenticatorBuilder webhookTokenAuthenticator;
    private ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder> webhookTokenAuthenticators = new ArrayList();
    private Map<String, Object> additionalProperties;

    public AuthenticationSpecFluent() {
    }

    public AuthenticationSpecFluent(AuthenticationSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AuthenticationSpec instance) {
        AuthenticationSpec authenticationSpec = instance = instance != null ? instance : new AuthenticationSpec();
        if (instance != null) {
            this.withOauthMetadata(instance.getOauthMetadata());
            this.withServiceAccountIssuer(instance.getServiceAccountIssuer());
            this.withType(instance.getType());
            this.withWebhookTokenAuthenticator(instance.getWebhookTokenAuthenticator());
            this.withWebhookTokenAuthenticators(instance.getWebhookTokenAuthenticators());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapNameReference buildOauthMetadata() {
        return this.oauthMetadata != null ? this.oauthMetadata.build() : null;
    }

    public A withOauthMetadata(ConfigMapNameReference oauthMetadata) {
        this._visitables.remove("oauthMetadata");
        if (oauthMetadata != null) {
            this.oauthMetadata = new ConfigMapNameReferenceBuilder(oauthMetadata);
            this._visitables.get("oauthMetadata").add(this.oauthMetadata);
        } else {
            this.oauthMetadata = null;
            this._visitables.get("oauthMetadata").remove(this.oauthMetadata);
        }
        return (A)this;
    }

    public boolean hasOauthMetadata() {
        return this.oauthMetadata != null;
    }

    public A withNewOauthMetadata(String name) {
        return this.withOauthMetadata(new ConfigMapNameReference(name));
    }

    public OauthMetadataNested<A> withNewOauthMetadata() {
        return new OauthMetadataNested(null);
    }

    public OauthMetadataNested<A> withNewOauthMetadataLike(ConfigMapNameReference item) {
        return new OauthMetadataNested(item);
    }

    public OauthMetadataNested<A> editOauthMetadata() {
        return this.withNewOauthMetadataLike(Optional.ofNullable(this.buildOauthMetadata()).orElse(null));
    }

    public OauthMetadataNested<A> editOrNewOauthMetadata() {
        return this.withNewOauthMetadataLike(Optional.ofNullable(this.buildOauthMetadata()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public OauthMetadataNested<A> editOrNewOauthMetadataLike(ConfigMapNameReference item) {
        return this.withNewOauthMetadataLike(Optional.ofNullable(this.buildOauthMetadata()).orElse(item));
    }

    public String getServiceAccountIssuer() {
        return this.serviceAccountIssuer;
    }

    public A withServiceAccountIssuer(String serviceAccountIssuer) {
        this.serviceAccountIssuer = serviceAccountIssuer;
        return (A)this;
    }

    public boolean hasServiceAccountIssuer() {
        return this.serviceAccountIssuer != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public WebhookTokenAuthenticator buildWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticator != null ? this.webhookTokenAuthenticator.build() : null;
    }

    public A withWebhookTokenAuthenticator(WebhookTokenAuthenticator webhookTokenAuthenticator) {
        this._visitables.remove("webhookTokenAuthenticator");
        if (webhookTokenAuthenticator != null) {
            this.webhookTokenAuthenticator = new WebhookTokenAuthenticatorBuilder(webhookTokenAuthenticator);
            this._visitables.get("webhookTokenAuthenticator").add(this.webhookTokenAuthenticator);
        } else {
            this.webhookTokenAuthenticator = null;
            this._visitables.get("webhookTokenAuthenticator").remove(this.webhookTokenAuthenticator);
        }
        return (A)this;
    }

    public boolean hasWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticator != null;
    }

    public WebhookTokenAuthenticatorNested<A> withNewWebhookTokenAuthenticator() {
        return new WebhookTokenAuthenticatorNested(null);
    }

    public WebhookTokenAuthenticatorNested<A> withNewWebhookTokenAuthenticatorLike(WebhookTokenAuthenticator item) {
        return new WebhookTokenAuthenticatorNested(item);
    }

    public WebhookTokenAuthenticatorNested<A> editWebhookTokenAuthenticator() {
        return this.withNewWebhookTokenAuthenticatorLike(Optional.ofNullable(this.buildWebhookTokenAuthenticator()).orElse(null));
    }

    public WebhookTokenAuthenticatorNested<A> editOrNewWebhookTokenAuthenticator() {
        return this.withNewWebhookTokenAuthenticatorLike(Optional.ofNullable(this.buildWebhookTokenAuthenticator()).orElse(new WebhookTokenAuthenticatorBuilder().build()));
    }

    public WebhookTokenAuthenticatorNested<A> editOrNewWebhookTokenAuthenticatorLike(WebhookTokenAuthenticator item) {
        return this.withNewWebhookTokenAuthenticatorLike(Optional.ofNullable(this.buildWebhookTokenAuthenticator()).orElse(item));
    }

    public A addToWebhookTokenAuthenticators(int index, DeprecatedWebhookTokenAuthenticator item) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList();
        }
        DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
        if (index < 0 || index >= this.webhookTokenAuthenticators.size()) {
            this._visitables.get("webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(builder);
        } else {
            this._visitables.get("webhookTokenAuthenticators").add(index, builder);
            this.webhookTokenAuthenticators.add(index, builder);
        }
        return (A)this;
    }

    public A setToWebhookTokenAuthenticators(int index, DeprecatedWebhookTokenAuthenticator item) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList();
        }
        DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
        if (index < 0 || index >= this.webhookTokenAuthenticators.size()) {
            this._visitables.get("webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(builder);
        } else {
            this._visitables.get("webhookTokenAuthenticators").set(index, builder);
            this.webhookTokenAuthenticators.set(index, builder);
        }
        return (A)this;
    }

    public A addToWebhookTokenAuthenticators(DeprecatedWebhookTokenAuthenticator ... items) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList();
        }
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get("webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(builder);
        }
        return (A)this;
    }

    public A addAllToWebhookTokenAuthenticators(Collection<DeprecatedWebhookTokenAuthenticator> items) {
        if (this.webhookTokenAuthenticators == null) {
            this.webhookTokenAuthenticators = new ArrayList();
        }
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get("webhookTokenAuthenticators").add(builder);
            this.webhookTokenAuthenticators.add(builder);
        }
        return (A)this;
    }

    public A removeFromWebhookTokenAuthenticators(DeprecatedWebhookTokenAuthenticator ... items) {
        if (this.webhookTokenAuthenticators == null) {
            return (A)this;
        }
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get("webhookTokenAuthenticators").remove(builder);
            this.webhookTokenAuthenticators.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromWebhookTokenAuthenticators(Collection<DeprecatedWebhookTokenAuthenticator> items) {
        if (this.webhookTokenAuthenticators == null) {
            return (A)this;
        }
        for (DeprecatedWebhookTokenAuthenticator item : items) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
            this._visitables.get("webhookTokenAuthenticators").remove(builder);
            this.webhookTokenAuthenticators.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromWebhookTokenAuthenticators(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        if (this.webhookTokenAuthenticators == null) {
            return (A)this;
        }
        Iterator<DeprecatedWebhookTokenAuthenticatorBuilder> each = this.webhookTokenAuthenticators.iterator();
        Object visitables = this._visitables.get("webhookTokenAuthenticators");
        while (each.hasNext()) {
            DeprecatedWebhookTokenAuthenticatorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DeprecatedWebhookTokenAuthenticator> buildWebhookTokenAuthenticators() {
        return this.webhookTokenAuthenticators != null ? AuthenticationSpecFluent.build(this.webhookTokenAuthenticators) : null;
    }

    public DeprecatedWebhookTokenAuthenticator buildWebhookTokenAuthenticator(int index) {
        return this.webhookTokenAuthenticators.get(index).build();
    }

    public DeprecatedWebhookTokenAuthenticator buildFirstWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticators.get(0).build();
    }

    public DeprecatedWebhookTokenAuthenticator buildLastWebhookTokenAuthenticator() {
        return this.webhookTokenAuthenticators.get(this.webhookTokenAuthenticators.size() - 1).build();
    }

    public DeprecatedWebhookTokenAuthenticator buildMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        for (DeprecatedWebhookTokenAuthenticatorBuilder item : this.webhookTokenAuthenticators) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        for (DeprecatedWebhookTokenAuthenticatorBuilder item : this.webhookTokenAuthenticators) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWebhookTokenAuthenticators(List<DeprecatedWebhookTokenAuthenticator> webhookTokenAuthenticators) {
        if (this.webhookTokenAuthenticators != null) {
            this._visitables.get("webhookTokenAuthenticators").clear();
        }
        if (webhookTokenAuthenticators != null) {
            this.webhookTokenAuthenticators = new ArrayList();
            for (DeprecatedWebhookTokenAuthenticator item : webhookTokenAuthenticators) {
                this.addToWebhookTokenAuthenticators(item);
            }
        } else {
            this.webhookTokenAuthenticators = null;
        }
        return (A)this;
    }

    public A withWebhookTokenAuthenticators(DeprecatedWebhookTokenAuthenticator ... webhookTokenAuthenticators) {
        if (this.webhookTokenAuthenticators != null) {
            this.webhookTokenAuthenticators.clear();
            this._visitables.remove("webhookTokenAuthenticators");
        }
        if (webhookTokenAuthenticators != null) {
            for (DeprecatedWebhookTokenAuthenticator item : webhookTokenAuthenticators) {
                this.addToWebhookTokenAuthenticators(item);
            }
        }
        return (A)this;
    }

    public boolean hasWebhookTokenAuthenticators() {
        return this.webhookTokenAuthenticators != null && !this.webhookTokenAuthenticators.isEmpty();
    }

    public WebhookTokenAuthenticatorsNested<A> addNewWebhookTokenAuthenticator() {
        return new WebhookTokenAuthenticatorsNested(-1, null);
    }

    public WebhookTokenAuthenticatorsNested<A> addNewWebhookTokenAuthenticatorLike(DeprecatedWebhookTokenAuthenticator item) {
        return new WebhookTokenAuthenticatorsNested(-1, item);
    }

    public WebhookTokenAuthenticatorsNested<A> setNewWebhookTokenAuthenticatorLike(int index, DeprecatedWebhookTokenAuthenticator item) {
        return new WebhookTokenAuthenticatorsNested(index, item);
    }

    public WebhookTokenAuthenticatorsNested<A> editWebhookTokenAuthenticator(int index) {
        if (this.webhookTokenAuthenticators.size() <= index) {
            throw new RuntimeException("Can't edit webhookTokenAuthenticators. Index exceeds size.");
        }
        return this.setNewWebhookTokenAuthenticatorLike(index, this.buildWebhookTokenAuthenticator(index));
    }

    public WebhookTokenAuthenticatorsNested<A> editFirstWebhookTokenAuthenticator() {
        if (this.webhookTokenAuthenticators.size() == 0) {
            throw new RuntimeException("Can't edit first webhookTokenAuthenticators. The list is empty.");
        }
        return this.setNewWebhookTokenAuthenticatorLike(0, this.buildWebhookTokenAuthenticator(0));
    }

    public WebhookTokenAuthenticatorsNested<A> editLastWebhookTokenAuthenticator() {
        int index = this.webhookTokenAuthenticators.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last webhookTokenAuthenticators. The list is empty.");
        }
        return this.setNewWebhookTokenAuthenticatorLike(index, this.buildWebhookTokenAuthenticator(index));
    }

    public WebhookTokenAuthenticatorsNested<A> editMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.webhookTokenAuthenticators.size(); ++i) {
            if (!predicate.test(this.webhookTokenAuthenticators.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching webhookTokenAuthenticators. No match found.");
        }
        return this.setNewWebhookTokenAuthenticatorLike(index, this.buildWebhookTokenAuthenticator(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticationSpecFluent that = (AuthenticationSpecFluent)o;
        if (!Objects.equals(this.oauthMetadata, that.oauthMetadata)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountIssuer, that.serviceAccountIssuer)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.webhookTokenAuthenticator, that.webhookTokenAuthenticator)) {
            return false;
        }
        if (!Objects.equals(this.webhookTokenAuthenticators, that.webhookTokenAuthenticators)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.oauthMetadata, this.serviceAccountIssuer, this.type, this.webhookTokenAuthenticator, this.webhookTokenAuthenticators, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.oauthMetadata != null) {
            sb.append("oauthMetadata:");
            sb.append(this.oauthMetadata + ",");
        }
        if (this.serviceAccountIssuer != null) {
            sb.append("serviceAccountIssuer:");
            sb.append(this.serviceAccountIssuer + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.webhookTokenAuthenticator != null) {
            sb.append("webhookTokenAuthenticator:");
            sb.append(this.webhookTokenAuthenticator + ",");
        }
        if (this.webhookTokenAuthenticators != null && !this.webhookTokenAuthenticators.isEmpty()) {
            sb.append("webhookTokenAuthenticators:");
            sb.append(this.webhookTokenAuthenticators + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WebhookTokenAuthenticatorsNested<N>
    extends DeprecatedWebhookTokenAuthenticatorFluent<WebhookTokenAuthenticatorsNested<N>>
    implements Nested<N> {
        DeprecatedWebhookTokenAuthenticatorBuilder builder;
        int index;

        WebhookTokenAuthenticatorsNested(int index, DeprecatedWebhookTokenAuthenticator item) {
            this.index = index;
            this.builder = new DeprecatedWebhookTokenAuthenticatorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AuthenticationSpecFluent.this.setToWebhookTokenAuthenticators(this.index, this.builder.build());
        }

        public N endWebhookTokenAuthenticator() {
            return this.and();
        }
    }

    public class WebhookTokenAuthenticatorNested<N>
    extends WebhookTokenAuthenticatorFluent<WebhookTokenAuthenticatorNested<N>>
    implements Nested<N> {
        WebhookTokenAuthenticatorBuilder builder;

        WebhookTokenAuthenticatorNested(WebhookTokenAuthenticator item) {
            this.builder = new WebhookTokenAuthenticatorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AuthenticationSpecFluent.this.withWebhookTokenAuthenticator(this.builder.build());
        }

        public N endWebhookTokenAuthenticator() {
            return this.and();
        }
    }

    public class OauthMetadataNested<N>
    extends ConfigMapNameReferenceFluent<OauthMetadataNested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        OauthMetadataNested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AuthenticationSpecFluent.this.withOauthMetadata(this.builder.build());
        }

        public N endOauthMetadata() {
            return this.and();
        }
    }
}

