/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_12.server.mock;

import io.fabric8.kubernetes.api.model.v6_12.APIResourceBuilder;
import io.fabric8.kubernetes.api.model.v6_12.APIResourceListBuilder;
import io.fabric8.kubernetes.api.model.v6_12.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.clnt.v6_12.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.Resetable;
import io.fabric8.kubernetes.clnt.v6_12.utils.ApiVersionUtil;
import io.fabric8.kubernetes.clnt.v6_12.utils.Serialization;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomResourceDefinitionProcessor
implements Resetable {
    private static final String V1BETA1_PATH = "/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions";
    private static final String V1_PATH = "/apis/apiextensions.k8s.io/v1/customresourcedefinitions";
    private static final String API_PATH = "/apis(/(?<group>[a-zA-Z0-9-_.]+))?(/(?<version>[a-zA-Z0-9-_]+))";
    private static final Pattern API_PATH_PATTERN = Pattern.compile("/apis(/(?<group>[a-zA-Z0-9-_.]+))?(/(?<version>[a-zA-Z0-9-_]+))");
    private final Map<List<String>, Map<String, CustomResourceDefinitionContext>> crdContexts = new LinkedHashMap<List<String>, Map<String, CustomResourceDefinitionContext>>();

    public void process(String path, String crdString, boolean delete) {
        CustomResourceDefinitionContext context = null;
        if (path.startsWith(V1BETA1_PATH)) {
            CustomResourceDefinition crd = (CustomResourceDefinition)Serialization.unmarshal((String)crdString, CustomResourceDefinition.class);
            context = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)crd);
        } else if (path.startsWith(V1_PATH)) {
            io.fabric8.kubernetes.api.model.v6_12.apiextensions.v1.CustomResourceDefinition crd = (io.fabric8.kubernetes.api.model.v6_12.apiextensions.v1.CustomResourceDefinition)Serialization.unmarshal((String)crdString, io.fabric8.kubernetes.api.model.v6_12.apiextensions.v1.CustomResourceDefinition.class);
            context = CustomResourceDefinitionContext.fromCrd((io.fabric8.kubernetes.api.model.v6_12.apiextensions.v1.CustomResourceDefinition)crd);
        } else {
            return;
        }
        if (delete) {
            this.removeCrdContext(context);
        } else {
            this.addCrdContext(context);
        }
    }

    public boolean isStatusSubresourceEnabledForResource(Map<String, String> pathValues) {
        Optional<CustomResourceDefinitionContext> context = this.getCrdContext(pathValues.get("api"), pathValues.get("version"), pathValues.get("plural"));
        return context.map(CustomResourceDefinitionContext::isStatusSubresource).orElse(false);
    }

    private static List<String> key(CustomResourceDefinitionContext c) {
        return CustomResourceDefinitionProcessor.key(c.getGroup(), c.getVersion());
    }

    private static List<String> key(String group, String version) {
        return Arrays.asList(group, version);
    }

    public Optional<CustomResourceDefinitionContext> getCrdContext(String api, String version, String plural) {
        return Optional.ofNullable(this.crdContexts.get(Arrays.asList(api, version))).map(v -> (CustomResourceDefinitionContext)v.get(plural));
    }

    public Optional<CustomResourceDefinitionContext> findCrd(String api, String version, String kind) {
        return Optional.ofNullable(this.crdContexts.get(Arrays.asList(api, version))).flatMap(m -> m.values().stream().filter(c -> c.getKind().equals(kind)).findFirst());
    }

    public void removeCrdContext(CustomResourceDefinitionContext context) {
        this.crdContexts.computeIfPresent(CustomResourceDefinitionProcessor.key(context), (k, v) -> {
            v.remove(context.getPlural());
            return v;
        });
    }

    public void addCrdContext(CustomResourceDefinitionContext context) {
        this.crdContexts.compute(CustomResourceDefinitionProcessor.key(context), (k, v) -> {
            if (v == null) {
                v = new LinkedHashMap<String, CustomResourceDefinitionContext>();
            }
            v.put(context.getPlural(), context);
            return v;
        });
    }

    @Override
    public void reset() {
        this.crdContexts.clear();
    }

    public String getApiResources(String path) {
        Matcher matcher = API_PATH_PATTERN.matcher(path);
        if (!matcher.matches()) {
            return null;
        }
        String group = matcher.group("group");
        String version = matcher.group("version");
        Map<String, CustomResourceDefinitionContext> resources = this.crdContexts.get(CustomResourceDefinitionProcessor.key(group, version));
        APIResourceListBuilder builder = (APIResourceListBuilder)new APIResourceListBuilder().withGroupVersion(ApiVersionUtil.joinApiGroupAndVersion((String)group, (String)version));
        if (resources != null) {
            resources.values().forEach(rdc -> {
                APIResourceListBuilder cfr_ignored_0 = (APIResourceListBuilder)builder.addToResources(((APIResourceBuilder)((APIResourceBuilder)((APIResourceBuilder)new APIResourceBuilder().withKind(rdc.getKind())).withNamespaced(rdc.isNamespaceScoped())).withName(rdc.getPlural())).build());
            });
        }
        return Serialization.asJson((Object)builder.build());
    }
}

