/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_12.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.v6_12.Pod;
import io.fabric8.kubernetes.api.model.v6_12.PodList;
import io.fabric8.kubernetes.api.model.v6_12.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v6_12.ReplicationController;
import io.fabric8.kubernetes.api.model.v6_12.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.v6_12.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.v6_12.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v6_12.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.clnt.v6_12.Client;
import io.fabric8.kubernetes.clnt.v6_12.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v6_12.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v6_12.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_12.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.core.v1.ReplicationControllerOperationsImpl;

class ReplicationControllerRollingUpdater
extends RollingUpdater<ReplicationController, ReplicationControllerList> {
    ReplicationControllerRollingUpdater(Client client, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected ReplicationController createClone(ReplicationController obj, String newName, String newDeploymentHash) {
        return ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).addToSelector("deployment", newDeploymentHash)).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected FilterWatchListDeletable<Pod, PodList, PodResource> selectedPodLister(ReplicationController obj) {
        return (FilterWatchListDeletable)((NonNamespaceOperation)this.pods().inNamespace(this.namespace)).withLabels(obj.getSpec().getSelector());
    }

    @Override
    protected ReplicationController updateDeploymentKey(String name, String hash) {
        ReplicationController old = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        ReplicationController updated = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)new ReplicationControllerBuilder(old).editSpec().addToSelector("deployment", hash)).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec()).build();
        return (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace((Object)updated);
    }

    @Override
    protected ReplicationController removeDeploymentKey(String name) {
        ReplicationController old = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        ReplicationController updated = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)new ReplicationControllerBuilder(old).editSpec().removeFromSelector("deployment")).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec()).build();
        return (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace((Object)updated);
    }

    @Override
    protected int getReplicas(ReplicationController obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected ReplicationController setReplicas(ReplicationController obj, int replicas) {
        return ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)new ReplicationControllerBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> resources() {
        return new ReplicationControllerOperationsImpl(this.client);
    }
}

