/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_12.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.v6_12.Container;
import io.fabric8.kubernetes.api.model.v6_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_12.OwnerReference;
import io.fabric8.kubernetes.api.model.v6_12.Status;
import io.fabric8.kubernetes.api.model.v6_12.apps.Deployment;
import io.fabric8.kubernetes.api.model.v6_12.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.v6_12.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v6_12.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.v6_12.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v6_12.Client;
import io.fabric8.kubernetes.clnt.v6_12.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v6_12.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.PrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v6_12.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.apps.v1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v6_12.utils.KubernetesResourceUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationsImpl
extends RollableScalableResourceOperation<Deployment, DeploymentList, RollableScalableResource<Deployment>>
implements TimeoutImageEditReplacePatchable<Deployment> {
    static final transient Logger LOG = LoggerFactory.getLogger(DeploymentOperationsImpl.class);
    public static final String DEPLOYMENT_KUBERNETES_IO_REVISION = "deployment.kubernetes.io/revision";

    public DeploymentOperationsImpl(Client client) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public DeploymentOperationsImpl(PodOperationContext context, OperationContext superContext) {
        super(context, superContext.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("deployments"), Deployment.class, DeploymentList.class);
    }

    @Override
    public DeploymentOperationsImpl newInstance(OperationContext context) {
        return new DeploymentOperationsImpl(this.rollingOperationContext, context);
    }

    public DeploymentOperationsImpl newInstance(PodOperationContext context, OperationContext superContext) {
        return new DeploymentOperationsImpl(context, superContext);
    }

    public Status rollback(DeploymentRollback rollback) {
        return this.handleDeploymentRollback(rollback);
    }

    @Override
    public RollingUpdater<Deployment, DeploymentList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return null;
    }

    @Override
    public Deployment resume() {
        return RollingUpdater.resume(this);
    }

    @Override
    public Deployment pause() {
        return RollingUpdater.pause(this);
    }

    @Override
    public Deployment restart() {
        return RollingUpdater.restart(this);
    }

    @Override
    public Deployment undo() {
        List<ReplicaSet> replicaSets = this.getReplicaSetListForDeployment((Deployment)this.get()).getItems();
        replicaSets.sort((o1, o2) -> {
            String revisionO1 = o1.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION);
            String revisionO2 = o2.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION);
            return Integer.parseInt(revisionO2) - Integer.parseInt(revisionO1);
        });
        ReplicaSet latestReplicaSet = replicaSets.get(0);
        ReplicaSet previousRevisionReplicaSet = replicaSets.get(1);
        Deployment deployment = (Deployment)this.get();
        deployment.getMetadata().getAnnotations().put(DEPLOYMENT_KUBERNETES_IO_REVISION, latestReplicaSet.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION));
        deployment.getSpec().setTemplate(previousRevisionReplicaSet.getSpec().getTemplate());
        return this.sendPatchedObject(this.get(), deployment);
    }

    public String getLog(boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<RollableScalableResource<ReplicaSet>> rcList = this.doGetLog();
        for (RollableScalableResource<ReplicaSet> rcOperation : rcList) {
            stringBuilder.append(rcOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<RollableScalableResource<ReplicaSet>> doGetLog() {
        ArrayList<RollableScalableResource<ReplicaSet>> rcs = new ArrayList<RollableScalableResource<ReplicaSet>>();
        Deployment deployment = (Deployment)this.requireFromServer();
        String rcUid = deployment.getMetadata().getUid();
        ReplicaSetOperationsImpl rsOperations = new ReplicaSetOperationsImpl(this.rollingOperationContext, this.context.withName(null));
        ReplicaSetList rcList = (ReplicaSetList)rsOperations.withLabels(DeploymentOperationsImpl.getDeploymentSelectorLabels(deployment)).list();
        for (ReplicaSet rs : rcList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid((HasMetadata)rs);
            if (ownerReference == null || !ownerReference.getUid().equals(rcUid)) continue;
            rcs.add((RollableScalableResource<ReplicaSet>)rsOperations.withName(rs.getMetadata().getName()));
        }
        return rcs;
    }

    public Reader getLogReader() {
        return this.findFirstPodResource().map(Loggable::getLogReader).orElse(null);
    }

    public InputStream getLogInputStream() {
        return this.findFirstPodResource().map(Loggable::getLogInputStream).orElse(null);
    }

    public LogWatch watchLog(OutputStream out) {
        return this.findFirstPodResource().map(it -> it.watchLog(out)).orElse(null);
    }

    private Optional<RollableScalableResource<ReplicaSet>> findFirstPodResource() {
        List<RollableScalableResource<ReplicaSet>> podResources = this.doGetLog();
        if (!podResources.isEmpty()) {
            if (podResources.size() > 1) {
                LOG.debug("Found {} pods, Using first one to get log", (Object)podResources.size());
            }
            return Optional.of(podResources.get(0));
        }
        return Optional.empty();
    }

    private ReplicaSetList getReplicaSetListForDeployment(Deployment deployment) {
        return (ReplicaSetList)((BaseOperation)new ReplicaSetOperationsImpl(this.context.getClient()).inNamespace(this.getNamespace())).withLabels(deployment.getSpec().getSelector().getMatchLabels()).list();
    }

    static Map<String, String> getDeploymentSelectorLabels(Deployment deployment) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (deployment != null && deployment.getSpec() != null && deployment.getSpec().getTemplate() != null && deployment.getSpec().getTemplate().getMetadata() != null) {
            labels.putAll(deployment.getSpec().getTemplate().getMetadata().getLabels());
        }
        return labels;
    }

    @Override
    protected List<Container> getContainers(Deployment value) {
        return value.getSpec().getTemplate().getSpec().getContainers();
    }

    public TimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withLimitBytes(limitBytes), this.context);
    }

    public TimeTailPrettyLoggable terminated() {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withTerminatedStatus(true), this.context);
    }

    public Loggable withPrettyOutput() {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withPrettyOutput(true), this.context);
    }

    public PrettyLoggable tailingLines(int lines) {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withTailingLines(lines), this.context);
    }

    public TailPrettyLoggable sinceTime(String timestamp) {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withSinceTimestamp(timestamp), this.context);
    }

    public TailPrettyLoggable sinceSeconds(int seconds) {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withSinceSeconds(seconds), this.context);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withTimestamps(true), this.context);
    }
}

