/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_12.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_12.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_12.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.v6_12.resource.v1alpha2.ResourceClaimTemplate;
import io.fabric8.kubernetes.api.model.v6_12.resource.v1alpha2.ResourceClaimTemplateSpec;
import io.fabric8.kubernetes.api.model.v6_12.resource.v1alpha2.ResourceClaimTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v6_12.resource.v1alpha2.ResourceClaimTemplateSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceClaimTemplateFluent<A extends ResourceClaimTemplateFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ResourceClaimTemplateSpecBuilder spec;
    private Map<String, Object> additionalProperties;

    public ResourceClaimTemplateFluent() {
    }

    public ResourceClaimTemplateFluent(ResourceClaimTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceClaimTemplate instance) {
        ResourceClaimTemplate resourceClaimTemplate = instance = instance != null ? instance : new ResourceClaimTemplate();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public ResourceClaimTemplateSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(ResourceClaimTemplateSpec spec) {
        this._visitables.remove("spec");
        if (spec != null) {
            this.spec = new ResourceClaimTemplateSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get("spec").remove(this.spec);
        }
        return (A)this;
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(ResourceClaimTemplateSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new ResourceClaimTemplateSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(ResourceClaimTemplateSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceClaimTemplateFluent that = (ResourceClaimTemplateFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SpecNested<N>
    extends ResourceClaimTemplateSpecFluent<SpecNested<N>>
    implements Nested<N> {
        ResourceClaimTemplateSpecBuilder builder;

        SpecNested(ResourceClaimTemplateSpec item) {
            this.builder = new ResourceClaimTemplateSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceClaimTemplateFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceClaimTemplateFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

