/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_12.networking.v1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.networking.v1.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.v6_12.networking.v1.HTTPIngressRuleValueBuilder;
import io.fabric8.kubernetes.api.model.v6_12.networking.v1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.v6_12.networking.v1.IngressRule;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IngressRuleFluent<A extends IngressRuleFluent<A>>
extends BaseFluent<A> {
    private String host;
    private HTTPIngressRuleValueBuilder http;
    private Map<String, Object> additionalProperties;

    public IngressRuleFluent() {
    }

    public IngressRuleFluent(IngressRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressRule instance) {
        IngressRule ingressRule = instance = instance != null ? instance : new IngressRule();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withHttp(instance.getHttp());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public HTTPIngressRuleValue buildHttp() {
        return this.http != null ? this.http.build() : null;
    }

    public A withHttp(HTTPIngressRuleValue http) {
        this._visitables.remove("http");
        if (http != null) {
            this.http = new HTTPIngressRuleValueBuilder(http);
            this._visitables.get("http").add(this.http);
        } else {
            this.http = null;
            this._visitables.get("http").remove(this.http);
        }
        return (A)this;
    }

    public boolean hasHttp() {
        return this.http != null;
    }

    public HttpNested<A> withNewHttp() {
        return new HttpNested(null);
    }

    public HttpNested<A> withNewHttpLike(HTTPIngressRuleValue item) {
        return new HttpNested(item);
    }

    public HttpNested<A> editHttp() {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(null));
    }

    public HttpNested<A> editOrNewHttp() {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(new HTTPIngressRuleValueBuilder().build()));
    }

    public HttpNested<A> editOrNewHttpLike(HTTPIngressRuleValue item) {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressRuleFluent that = (IngressRuleFluent)o;
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.http, that.http)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.http, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.http != null) {
            sb.append("http:");
            sb.append(this.http + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HttpNested<N>
    extends HTTPIngressRuleValueFluent<HttpNested<N>>
    implements Nested<N> {
        HTTPIngressRuleValueBuilder builder;

        HttpNested(HTTPIngressRuleValue item) {
            this.builder = new HTTPIngressRuleValueBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressRuleFluent.this.withHttp(this.builder.build());
        }

        public N endHttp() {
            return this.and();
        }
    }
}

