/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_12.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.Condition;
import io.fabric8.kubernetes.api.model.v6_12.gatewayapi.v1.ParentReference;
import io.fabric8.kubernetes.api.model.v6_12.gatewayapi.v1.ParentReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_12.gatewayapi.v1.ParentReferenceFluent;
import io.fabric8.kubernetes.api.model.v6_12.gatewayapi.v1alpha2.PolicyAncestorStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PolicyAncestorStatusFluent<A extends PolicyAncestorStatusFluent<A>>
extends BaseFluent<A> {
    private ParentReferenceBuilder ancestorRef;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String controllerName;
    private Map<String, Object> additionalProperties;

    public PolicyAncestorStatusFluent() {
    }

    public PolicyAncestorStatusFluent(PolicyAncestorStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PolicyAncestorStatus instance) {
        PolicyAncestorStatus policyAncestorStatus = instance = instance != null ? instance : new PolicyAncestorStatus();
        if (instance != null) {
            this.withAncestorRef(instance.getAncestorRef());
            this.withConditions(instance.getConditions());
            this.withControllerName(instance.getControllerName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ParentReference buildAncestorRef() {
        return this.ancestorRef != null ? this.ancestorRef.build() : null;
    }

    public A withAncestorRef(ParentReference ancestorRef) {
        this._visitables.remove("ancestorRef");
        if (ancestorRef != null) {
            this.ancestorRef = new ParentReferenceBuilder(ancestorRef);
            this._visitables.get("ancestorRef").add(this.ancestorRef);
        } else {
            this.ancestorRef = null;
            this._visitables.get("ancestorRef").remove(this.ancestorRef);
        }
        return (A)this;
    }

    public boolean hasAncestorRef() {
        return this.ancestorRef != null;
    }

    public AncestorRefNested<A> withNewAncestorRef() {
        return new AncestorRefNested(null);
    }

    public AncestorRefNested<A> withNewAncestorRefLike(ParentReference item) {
        return new AncestorRefNested(item);
    }

    public AncestorRefNested<A> editAncestorRef() {
        return this.withNewAncestorRefLike(Optional.ofNullable(this.buildAncestorRef()).orElse(null));
    }

    public AncestorRefNested<A> editOrNewAncestorRef() {
        return this.withNewAncestorRefLike(Optional.ofNullable(this.buildAncestorRef()).orElse(new ParentReferenceBuilder().build()));
    }

    public AncestorRefNested<A> editOrNewAncestorRefLike(ParentReference item) {
        return this.withNewAncestorRefLike(Optional.ofNullable(this.buildAncestorRef()).orElse(item));
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public A withControllerName(String controllerName) {
        this.controllerName = controllerName;
        return (A)this;
    }

    public boolean hasControllerName() {
        return this.controllerName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyAncestorStatusFluent that = (PolicyAncestorStatusFluent)o;
        if (!Objects.equals(this.ancestorRef, that.ancestorRef)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.controllerName, that.controllerName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ancestorRef, this.conditions, this.controllerName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ancestorRef != null) {
            sb.append("ancestorRef:");
            sb.append(this.ancestorRef + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.controllerName != null) {
            sb.append("controllerName:");
            sb.append(this.controllerName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AncestorRefNested<N>
    extends ParentReferenceFluent<AncestorRefNested<N>>
    implements Nested<N> {
        ParentReferenceBuilder builder;

        AncestorRefNested(ParentReference item) {
            this.builder = new ParentReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PolicyAncestorStatusFluent.this.withAncestorRef(this.builder.build());
        }

        public N endAncestorRef() {
            return this.and();
        }
    }
}

