/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_12.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.autoscaling.v2.ContainerResourceMetricSource;
import io.fabric8.kubernetes.api.model.v6_12.autoscaling.v2.MetricTarget;
import io.fabric8.kubernetes.api.model.v6_12.autoscaling.v2.MetricTargetBuilder;
import io.fabric8.kubernetes.api.model.v6_12.autoscaling.v2.MetricTargetFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContainerResourceMetricSourceFluent<A extends ContainerResourceMetricSourceFluent<A>>
extends BaseFluent<A> {
    private String container;
    private String name;
    private MetricTargetBuilder target;
    private Map<String, Object> additionalProperties;

    public ContainerResourceMetricSourceFluent() {
    }

    public ContainerResourceMetricSourceFluent(ContainerResourceMetricSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ContainerResourceMetricSource instance) {
        ContainerResourceMetricSource containerResourceMetricSource = instance = instance != null ? instance : new ContainerResourceMetricSource();
        if (instance != null) {
            this.withContainer(instance.getContainer());
            this.withName(instance.getName());
            this.withTarget(instance.getTarget());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getContainer() {
        return this.container;
    }

    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    public boolean hasContainer() {
        return this.container != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public MetricTarget buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    public A withTarget(MetricTarget target) {
        this._visitables.remove("target");
        if (target != null) {
            this.target = new MetricTargetBuilder(target);
            this._visitables.get("target").add(this.target);
        } else {
            this.target = null;
            this._visitables.get("target").remove(this.target);
        }
        return (A)this;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public TargetNested<A> withNewTarget() {
        return new TargetNested(null);
    }

    public TargetNested<A> withNewTargetLike(MetricTarget item) {
        return new TargetNested(item);
    }

    public TargetNested<A> editTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(null));
    }

    public TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(new MetricTargetBuilder().build()));
    }

    public TargetNested<A> editOrNewTargetLike(MetricTarget item) {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerResourceMetricSourceFluent that = (ContainerResourceMetricSourceFluent)o;
        if (!Objects.equals(this.container, that.container)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.container, this.name, this.target, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.container != null) {
            sb.append("container:");
            sb.append(this.container + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetNested<N>
    extends MetricTargetFluent<TargetNested<N>>
    implements Nested<N> {
        MetricTargetBuilder builder;

        TargetNested(MetricTarget item) {
            this.builder = new MetricTargetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerResourceMetricSourceFluent.this.withTarget(this.builder.build());
        }

        public N endTarget() {
            return this.and();
        }
    }
}

