/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_12;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.LimitRangeItem;
import io.fabric8.kubernetes.api.model.v6_12.LimitRangeItemBuilder;
import io.fabric8.kubernetes.api.model.v6_12.LimitRangeItemFluent;
import io.fabric8.kubernetes.api.model.v6_12.LimitRangeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LimitRangeSpecFluent<A extends LimitRangeSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<LimitRangeItemBuilder> limits = new ArrayList();
    private Map<String, Object> additionalProperties;

    public LimitRangeSpecFluent() {
    }

    public LimitRangeSpecFluent(LimitRangeSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LimitRangeSpec instance) {
        LimitRangeSpec limitRangeSpec = instance = instance != null ? instance : new LimitRangeSpec();
        if (instance != null) {
            this.withLimits(instance.getLimits());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToLimits(int index, LimitRangeItem item) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
        if (index < 0 || index >= this.limits.size()) {
            this._visitables.get("limits").add(builder);
            this.limits.add(builder);
        } else {
            this._visitables.get("limits").add(index, builder);
            this.limits.add(index, builder);
        }
        return (A)this;
    }

    public A setToLimits(int index, LimitRangeItem item) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
        if (index < 0 || index >= this.limits.size()) {
            this._visitables.get("limits").add(builder);
            this.limits.add(builder);
        } else {
            this._visitables.get("limits").set(index, builder);
            this.limits.set(index, builder);
        }
        return (A)this;
    }

    public A addToLimits(LimitRangeItem ... items) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.get("limits").add(builder);
            this.limits.add(builder);
        }
        return (A)this;
    }

    public A addAllToLimits(Collection<LimitRangeItem> items) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.get("limits").add(builder);
            this.limits.add(builder);
        }
        return (A)this;
    }

    public A removeFromLimits(LimitRangeItem ... items) {
        if (this.limits == null) {
            return (A)this;
        }
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.get("limits").remove(builder);
            this.limits.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromLimits(Collection<LimitRangeItem> items) {
        if (this.limits == null) {
            return (A)this;
        }
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.get("limits").remove(builder);
            this.limits.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromLimits(Predicate<LimitRangeItemBuilder> predicate) {
        if (this.limits == null) {
            return (A)this;
        }
        Iterator<LimitRangeItemBuilder> each = this.limits.iterator();
        Object visitables = this._visitables.get("limits");
        while (each.hasNext()) {
            LimitRangeItemBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<LimitRangeItem> buildLimits() {
        return this.limits != null ? LimitRangeSpecFluent.build(this.limits) : null;
    }

    public LimitRangeItem buildLimit(int index) {
        return this.limits.get(index).build();
    }

    public LimitRangeItem buildFirstLimit() {
        return this.limits.get(0).build();
    }

    public LimitRangeItem buildLastLimit() {
        return this.limits.get(this.limits.size() - 1).build();
    }

    public LimitRangeItem buildMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
        for (LimitRangeItemBuilder item : this.limits) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
        for (LimitRangeItemBuilder item : this.limits) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLimits(List<LimitRangeItem> limits) {
        if (this.limits != null) {
            this._visitables.get("limits").clear();
        }
        if (limits != null) {
            this.limits = new ArrayList();
            for (LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        } else {
            this.limits = null;
        }
        return (A)this;
    }

    public A withLimits(LimitRangeItem ... limits) {
        if (this.limits != null) {
            this.limits.clear();
            this._visitables.remove("limits");
        }
        if (limits != null) {
            for (LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        }
        return (A)this;
    }

    public boolean hasLimits() {
        return this.limits != null && !this.limits.isEmpty();
    }

    public LimitsNested<A> addNewLimit() {
        return new LimitsNested(-1, null);
    }

    public LimitsNested<A> addNewLimitLike(LimitRangeItem item) {
        return new LimitsNested(-1, item);
    }

    public LimitsNested<A> setNewLimitLike(int index, LimitRangeItem item) {
        return new LimitsNested(index, item);
    }

    public LimitsNested<A> editLimit(int index) {
        if (this.limits.size() <= index) {
            throw new RuntimeException("Can't edit limits. Index exceeds size.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    public LimitsNested<A> editFirstLimit() {
        if (this.limits.size() == 0) {
            throw new RuntimeException("Can't edit first limits. The list is empty.");
        }
        return this.setNewLimitLike(0, this.buildLimit(0));
    }

    public LimitsNested<A> editLastLimit() {
        int index = this.limits.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last limits. The list is empty.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    public LimitsNested<A> editMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.limits.size(); ++i) {
            if (!predicate.test(this.limits.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching limits. No match found.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitRangeSpecFluent that = (LimitRangeSpecFluent)o;
        if (!Objects.equals(this.limits, that.limits)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.limits, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.limits != null && !this.limits.isEmpty()) {
            sb.append("limits:");
            sb.append(this.limits + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LimitsNested<N>
    extends LimitRangeItemFluent<LimitsNested<N>>
    implements Nested<N> {
        LimitRangeItemBuilder builder;
        int index;

        LimitsNested(int index, LimitRangeItem item) {
            this.index = index;
            this.builder = new LimitRangeItemBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)LimitRangeSpecFluent.this.setToLimits(this.index, this.builder.build());
        }

        public N endLimit() {
            return this.and();
        }
    }
}

