/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.ObjectReference;
import io.fabric8.kubernetes.api.model.v6_12.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_12.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.v6_12.machineconfig.v1.MachineConfigPoolStatusConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachineConfigPoolStatusConfigurationFluent<A extends MachineConfigPoolStatusConfigurationFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String fieldPath;
    private String kind;
    private String name;
    private String namespace;
    private String resourceVersion;
    private ArrayList<ObjectReferenceBuilder> source = new ArrayList();
    private String uid;
    private Map<String, Object> additionalProperties;

    public MachineConfigPoolStatusConfigurationFluent() {
    }

    public MachineConfigPoolStatusConfigurationFluent(MachineConfigPoolStatusConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineConfigPoolStatusConfiguration instance) {
        MachineConfigPoolStatusConfiguration machineConfigPoolStatusConfiguration = instance = instance != null ? instance : new MachineConfigPoolStatusConfiguration();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withFieldPath(instance.getFieldPath());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withResourceVersion(instance.getResourceVersion());
            this.withSource(instance.getSource());
            this.withUid(instance.getUid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getFieldPath() {
        return this.fieldPath;
    }

    public A withFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return (A)this;
    }

    public boolean hasFieldPath() {
        return this.fieldPath != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return (A)this;
    }

    public boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    public A addToSource(int index, ObjectReference item) {
        if (this.source == null) {
            this.source = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.source.size()) {
            this._visitables.get("source").add(builder);
            this.source.add(builder);
        } else {
            this._visitables.get("source").add(index, builder);
            this.source.add(index, builder);
        }
        return (A)this;
    }

    public A setToSource(int index, ObjectReference item) {
        if (this.source == null) {
            this.source = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.source.size()) {
            this._visitables.get("source").add(builder);
            this.source.add(builder);
        } else {
            this._visitables.get("source").set(index, builder);
            this.source.set(index, builder);
        }
        return (A)this;
    }

    public A addToSource(ObjectReference ... items) {
        if (this.source == null) {
            this.source = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("source").add(builder);
            this.source.add(builder);
        }
        return (A)this;
    }

    public A addAllToSource(Collection<ObjectReference> items) {
        if (this.source == null) {
            this.source = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("source").add(builder);
            this.source.add(builder);
        }
        return (A)this;
    }

    public A removeFromSource(ObjectReference ... items) {
        if (this.source == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("source").remove(builder);
            this.source.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSource(Collection<ObjectReference> items) {
        if (this.source == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("source").remove(builder);
            this.source.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSource(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.source == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.source.iterator();
        Object visitables = this._visitables.get("source");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ObjectReference> buildSource() {
        return this.source != null ? MachineConfigPoolStatusConfigurationFluent.build(this.source) : null;
    }

    public ObjectReference buildSource(int index) {
        return this.source.get(index).build();
    }

    public ObjectReference buildFirstSource() {
        return this.source.get(0).build();
    }

    public ObjectReference buildLastSource() {
        return this.source.get(this.source.size() - 1).build();
    }

    public ObjectReference buildMatchingSource(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.source) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSource(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.source) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSource(List<ObjectReference> source) {
        if (this.source != null) {
            this._visitables.get("source").clear();
        }
        if (source != null) {
            this.source = new ArrayList();
            for (ObjectReference item : source) {
                this.addToSource(item);
            }
        } else {
            this.source = null;
        }
        return (A)this;
    }

    public A withSource(ObjectReference ... source) {
        if (this.source != null) {
            this.source.clear();
            this._visitables.remove("source");
        }
        if (source != null) {
            for (ObjectReference item : source) {
                this.addToSource(item);
            }
        }
        return (A)this;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public SourceNested<A> addNewSource() {
        return new SourceNested(-1, null);
    }

    public SourceNested<A> addNewSourceLike(ObjectReference item) {
        return new SourceNested(-1, item);
    }

    public SourceNested<A> setNewSourceLike(int index, ObjectReference item) {
        return new SourceNested(index, item);
    }

    public SourceNested<A> editSource(int index) {
        if (this.source.size() <= index) {
            throw new RuntimeException("Can't edit source. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourceNested<A> editFirstSource() {
        if (this.source.size() == 0) {
            throw new RuntimeException("Can't edit first source. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    public SourceNested<A> editLastSource() {
        int index = this.source.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last source. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourceNested<A> editMatchingSource(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.source.size(); ++i) {
            if (!predicate.test(this.source.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching source. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigPoolStatusConfigurationFluent that = (MachineConfigPoolStatusConfigurationFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.fieldPath, that.fieldPath)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.resourceVersion, that.resourceVersion)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldPath, this.kind, this.name, this.namespace, this.resourceVersion, this.source, this.uid, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.fieldPath != null) {
            sb.append("fieldPath:");
            sb.append(this.fieldPath + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.resourceVersion != null) {
            sb.append("resourceVersion:");
            sb.append(this.resourceVersion + ",");
        }
        if (this.source != null && !this.source.isEmpty()) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SourceNested<N>
    extends ObjectReferenceFluent<SourceNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;
        int index;

        SourceNested(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineConfigPoolStatusConfigurationFluent.this.setToSource(this.index, this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

