/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12.config.v1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.openshift.api.model.v6_12.config.v1.ConfigMapFileReference;
import io.fabric8.openshift.api.model.v6_12.config.v1.ConfigMapFileReferenceBuilder;
import io.fabric8.openshift.api.model.v6_12.config.v1.ConfigMapFileReferenceFluent;
import io.fabric8.openshift.api.model.v6_12.config.v1.InfrastructureSpec;
import io.fabric8.openshift.api.model.v6_12.config.v1.PlatformSpec;
import io.fabric8.openshift.api.model.v6_12.config.v1.PlatformSpecBuilder;
import io.fabric8.openshift.api.model.v6_12.config.v1.PlatformSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class InfrastructureSpecFluent<A extends InfrastructureSpecFluent<A>>
extends BaseFluent<A> {
    private ConfigMapFileReferenceBuilder cloudConfig;
    private PlatformSpecBuilder platformSpec;
    private Map<String, Object> additionalProperties;

    public InfrastructureSpecFluent() {
    }

    public InfrastructureSpecFluent(InfrastructureSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(InfrastructureSpec instance) {
        InfrastructureSpec infrastructureSpec = instance = instance != null ? instance : new InfrastructureSpec();
        if (instance != null) {
            this.withCloudConfig(instance.getCloudConfig());
            this.withPlatformSpec(instance.getPlatformSpec());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapFileReference buildCloudConfig() {
        return this.cloudConfig != null ? this.cloudConfig.build() : null;
    }

    public A withCloudConfig(ConfigMapFileReference cloudConfig) {
        this._visitables.remove("cloudConfig");
        if (cloudConfig != null) {
            this.cloudConfig = new ConfigMapFileReferenceBuilder(cloudConfig);
            this._visitables.get("cloudConfig").add(this.cloudConfig);
        } else {
            this.cloudConfig = null;
            this._visitables.get("cloudConfig").remove(this.cloudConfig);
        }
        return (A)this;
    }

    public boolean hasCloudConfig() {
        return this.cloudConfig != null;
    }

    public A withNewCloudConfig(String key, String name) {
        return this.withCloudConfig(new ConfigMapFileReference(key, name));
    }

    public CloudConfigNested<A> withNewCloudConfig() {
        return new CloudConfigNested(null);
    }

    public CloudConfigNested<A> withNewCloudConfigLike(ConfigMapFileReference item) {
        return new CloudConfigNested(item);
    }

    public CloudConfigNested<A> editCloudConfig() {
        return this.withNewCloudConfigLike(Optional.ofNullable(this.buildCloudConfig()).orElse(null));
    }

    public CloudConfigNested<A> editOrNewCloudConfig() {
        return this.withNewCloudConfigLike(Optional.ofNullable(this.buildCloudConfig()).orElse(new ConfigMapFileReferenceBuilder().build()));
    }

    public CloudConfigNested<A> editOrNewCloudConfigLike(ConfigMapFileReference item) {
        return this.withNewCloudConfigLike(Optional.ofNullable(this.buildCloudConfig()).orElse(item));
    }

    public PlatformSpec buildPlatformSpec() {
        return this.platformSpec != null ? this.platformSpec.build() : null;
    }

    public A withPlatformSpec(PlatformSpec platformSpec) {
        this._visitables.remove("platformSpec");
        if (platformSpec != null) {
            this.platformSpec = new PlatformSpecBuilder(platformSpec);
            this._visitables.get("platformSpec").add(this.platformSpec);
        } else {
            this.platformSpec = null;
            this._visitables.get("platformSpec").remove(this.platformSpec);
        }
        return (A)this;
    }

    public boolean hasPlatformSpec() {
        return this.platformSpec != null;
    }

    public PlatformSpecNested<A> withNewPlatformSpec() {
        return new PlatformSpecNested(null);
    }

    public PlatformSpecNested<A> withNewPlatformSpecLike(PlatformSpec item) {
        return new PlatformSpecNested(item);
    }

    public PlatformSpecNested<A> editPlatformSpec() {
        return this.withNewPlatformSpecLike(Optional.ofNullable(this.buildPlatformSpec()).orElse(null));
    }

    public PlatformSpecNested<A> editOrNewPlatformSpec() {
        return this.withNewPlatformSpecLike(Optional.ofNullable(this.buildPlatformSpec()).orElse(new PlatformSpecBuilder().build()));
    }

    public PlatformSpecNested<A> editOrNewPlatformSpecLike(PlatformSpec item) {
        return this.withNewPlatformSpecLike(Optional.ofNullable(this.buildPlatformSpec()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfrastructureSpecFluent that = (InfrastructureSpecFluent)o;
        if (!Objects.equals(this.cloudConfig, that.cloudConfig)) {
            return false;
        }
        if (!Objects.equals(this.platformSpec, that.platformSpec)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cloudConfig, this.platformSpec, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cloudConfig != null) {
            sb.append("cloudConfig:");
            sb.append(this.cloudConfig + ",");
        }
        if (this.platformSpec != null) {
            sb.append("platformSpec:");
            sb.append(this.platformSpec + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PlatformSpecNested<N>
    extends PlatformSpecFluent<PlatformSpecNested<N>>
    implements Nested<N> {
        PlatformSpecBuilder builder;

        PlatformSpecNested(PlatformSpec item) {
            this.builder = new PlatformSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InfrastructureSpecFluent.this.withPlatformSpec(this.builder.build());
        }

        public N endPlatformSpec() {
            return this.and();
        }
    }

    public class CloudConfigNested<N>
    extends ConfigMapFileReferenceFluent<CloudConfigNested<N>>
    implements Nested<N> {
        ConfigMapFileReferenceBuilder builder;

        CloudConfigNested(ConfigMapFileReference item) {
            this.builder = new ConfigMapFileReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)InfrastructureSpecFluent.this.withCloudConfig(this.builder.build());
        }

        public N endCloudConfig() {
            return this.and();
        }
    }
}

