/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12.config.v1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.openshift.api.model.v6_12.config.v1.AWSPlatformSpec;
import io.fabric8.openshift.api.model.v6_12.config.v1.AWSServiceEndpoint;
import io.fabric8.openshift.api.model.v6_12.config.v1.AWSServiceEndpointBuilder;
import io.fabric8.openshift.api.model.v6_12.config.v1.AWSServiceEndpointFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AWSPlatformSpecFluent<A extends AWSPlatformSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<AWSServiceEndpointBuilder> serviceEndpoints = new ArrayList();
    private Map<String, Object> additionalProperties;

    public AWSPlatformSpecFluent() {
    }

    public AWSPlatformSpecFluent(AWSPlatformSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AWSPlatformSpec instance) {
        AWSPlatformSpec aWSPlatformSpec = instance = instance != null ? instance : new AWSPlatformSpec();
        if (instance != null) {
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToServiceEndpoints(int index, AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get("serviceEndpoints").add(index, builder);
            this.serviceEndpoints.add(index, builder);
        }
        return (A)this;
    }

    public A setToServiceEndpoints(int index, AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get("serviceEndpoints").set(index, builder);
            this.serviceEndpoints.set(index, builder);
        }
        return (A)this;
    }

    public A addToServiceEndpoints(AWSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    public A removeFromServiceEndpoints(AWSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromServiceEndpoints(Predicate<AWSServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        Iterator<AWSServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        Object visitables = this._visitables.get("serviceEndpoints");
        while (each.hasNext()) {
            AWSServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AWSServiceEndpoint> buildServiceEndpoints() {
        return this.serviceEndpoints != null ? AWSPlatformSpecFluent.build(this.serviceEndpoints) : null;
    }

    public AWSServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    public AWSServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    public AWSServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    public AWSServiceEndpoint buildMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get("serviceEndpoints").clear();
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList();
            for (AWSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)this;
    }

    public A withServiceEndpoints(AWSServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
            this._visitables.remove("serviceEndpoints");
        }
        if (serviceEndpoints != null) {
            for (AWSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new AWSServiceEndpoint(name, url));
    }

    public ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNested(-1, null);
    }

    public ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item) {
        return new ServiceEndpointsNested(-1, item);
    }

    public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index, AWSServiceEndpoint item) {
        return new ServiceEndpointsNested(index, item);
    }

    public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    public ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSPlatformSpecFluent that = (AWSPlatformSpecFluent)o;
        if (!Objects.equals(this.serviceEndpoints, that.serviceEndpoints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.serviceEndpoints, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(this.serviceEndpoints + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceEndpointsNested<N>
    extends AWSServiceEndpointFluent<ServiceEndpointsNested<N>>
    implements Nested<N> {
        AWSServiceEndpointBuilder builder;
        int index;

        ServiceEndpointsNested(int index, AWSServiceEndpoint item) {
            this.index = index;
            this.builder = new AWSServiceEndpointBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSPlatformSpecFluent.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        public N endServiceEndpoint() {
            return this.and();
        }
    }
}

