/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.v6_12.Editable;
import io.fabric8.kubernetes.api.model.v6_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_12.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.fabric8.openshift.api.model.v6_12.ImageSignatureBuilder;
import io.fabric8.openshift.api.model.v6_12.SignatureCondition;
import io.fabric8.openshift.api.model.v6_12.SignatureIssuer;
import io.fabric8.openshift.api.model.v6_12.SignatureSubject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "conditions", "content", "created", "imageIdentity", "issuedBy", "issuedTo", "signedClaims", "type"})
@Version(value="v1")
@Group(value="image.openshift.io")
public class ImageSignature
implements Editable<ImageSignatureBuilder>,
HasMetadata {
    @JsonProperty(value="apiVersion")
    private String apiVersion = "image.openshift.io/v1";
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<SignatureCondition> conditions = new ArrayList<SignatureCondition>();
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="created")
    private String created;
    @JsonProperty(value="imageIdentity")
    private String imageIdentity;
    @JsonProperty(value="issuedBy")
    private SignatureIssuer issuedBy;
    @JsonProperty(value="issuedTo")
    private SignatureSubject issuedTo;
    @JsonProperty(value="kind")
    private String kind = "ImageSignature";
    @JsonProperty(value="metadata")
    private ObjectMeta metadata;
    @JsonProperty(value="signedClaims")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> signedClaims = new LinkedHashMap<String, String>();
    @JsonProperty(value="type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public ImageSignature() {
    }

    public ImageSignature(String apiVersion, List<SignatureCondition> conditions, String content, String created, String imageIdentity, SignatureIssuer issuedBy, SignatureSubject issuedTo, String kind, ObjectMeta metadata, Map<String, String> signedClaims, String type) {
        this.apiVersion = apiVersion;
        this.conditions = conditions;
        this.content = content;
        this.created = created;
        this.imageIdentity = imageIdentity;
        this.issuedBy = issuedBy;
        this.issuedTo = issuedTo;
        this.kind = kind;
        this.metadata = metadata;
        this.signedClaims = signedClaims;
        this.type = type;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="conditions")
    public List<SignatureCondition> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions")
    public void setConditions(List<SignatureCondition> conditions) {
        this.conditions = conditions;
    }

    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    public void setContent(String content) {
        this.content = content;
    }

    @JsonProperty(value="created")
    public String getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    public void setCreated(String created) {
        this.created = created;
    }

    @JsonProperty(value="imageIdentity")
    public String getImageIdentity() {
        return this.imageIdentity;
    }

    @JsonProperty(value="imageIdentity")
    public void setImageIdentity(String imageIdentity) {
        this.imageIdentity = imageIdentity;
    }

    @JsonProperty(value="issuedBy")
    public SignatureIssuer getIssuedBy() {
        return this.issuedBy;
    }

    @JsonProperty(value="issuedBy")
    public void setIssuedBy(SignatureIssuer issuedBy) {
        this.issuedBy = issuedBy;
    }

    @JsonProperty(value="issuedTo")
    public SignatureSubject getIssuedTo() {
        return this.issuedTo;
    }

    @JsonProperty(value="issuedTo")
    public void setIssuedTo(SignatureSubject issuedTo) {
        this.issuedTo = issuedTo;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="signedClaims")
    public Map<String, String> getSignedClaims() {
        return this.signedClaims;
    }

    @JsonProperty(value="signedClaims")
    public void setSignedClaims(Map<String, String> signedClaims) {
        this.signedClaims = signedClaims;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @Override
    @JsonIgnore
    public ImageSignatureBuilder edit() {
        return new ImageSignatureBuilder(this);
    }

    @JsonIgnore
    public ImageSignatureBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "ImageSignature(apiVersion=" + this.getApiVersion() + ", conditions=" + this.getConditions() + ", content=" + this.getContent() + ", created=" + this.getCreated() + ", imageIdentity=" + this.getImageIdentity() + ", issuedBy=" + this.getIssuedBy() + ", issuedTo=" + this.getIssuedTo() + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", signedClaims=" + this.getSignedClaims() + ", type=" + this.getType() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageSignature)) {
            return false;
        }
        ImageSignature other = (ImageSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        List<SignatureCondition> this$conditions = this.getConditions();
        List<SignatureCondition> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        String this$imageIdentity = this.getImageIdentity();
        String other$imageIdentity = other.getImageIdentity();
        if (this$imageIdentity == null ? other$imageIdentity != null : !this$imageIdentity.equals(other$imageIdentity)) {
            return false;
        }
        SignatureIssuer this$issuedBy = this.getIssuedBy();
        SignatureIssuer other$issuedBy = other.getIssuedBy();
        if (this$issuedBy == null ? other$issuedBy != null : !((Object)this$issuedBy).equals(other$issuedBy)) {
            return false;
        }
        SignatureSubject this$issuedTo = this.getIssuedTo();
        SignatureSubject other$issuedTo = other.getIssuedTo();
        if (this$issuedTo == null ? other$issuedTo != null : !((Object)this$issuedTo).equals(other$issuedTo)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, String> this$signedClaims = this.getSignedClaims();
        Map<String, String> other$signedClaims = other.getSignedClaims();
        if (this$signedClaims == null ? other$signedClaims != null : !((Object)this$signedClaims).equals(other$signedClaims)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageSignature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        List<SignatureCondition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        String $imageIdentity = this.getImageIdentity();
        result = result * 59 + ($imageIdentity == null ? 43 : $imageIdentity.hashCode());
        SignatureIssuer $issuedBy = this.getIssuedBy();
        result = result * 59 + ($issuedBy == null ? 43 : ((Object)$issuedBy).hashCode());
        SignatureSubject $issuedTo = this.getIssuedTo();
        result = result * 59 + ($issuedTo == null ? 43 : ((Object)$issuedTo).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, String> $signedClaims = this.getSignedClaims();
        result = result * 59 + ($signedClaims == null ? 43 : ((Object)$signedClaims).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    @JsonIgnore
    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }
}

