/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_12;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.ObjectReference;
import io.fabric8.kubernetes.api.model.v6_12.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_12.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.v6_12.BuildCondition;
import io.fabric8.openshift.api.model.v6_12.BuildConditionBuilder;
import io.fabric8.openshift.api.model.v6_12.BuildConditionFluent;
import io.fabric8.openshift.api.model.v6_12.BuildStatus;
import io.fabric8.openshift.api.model.v6_12.BuildStatusOutput;
import io.fabric8.openshift.api.model.v6_12.BuildStatusOutputBuilder;
import io.fabric8.openshift.api.model.v6_12.BuildStatusOutputFluent;
import io.fabric8.openshift.api.model.v6_12.StageInfo;
import io.fabric8.openshift.api.model.v6_12.StageInfoBuilder;
import io.fabric8.openshift.api.model.v6_12.StageInfoFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BuildStatusFluent<A extends BuildStatusFluent<A>>
extends BaseFluent<A> {
    private Boolean cancelled;
    private String completionTimestamp;
    private ArrayList<BuildConditionBuilder> conditions = new ArrayList();
    private ObjectReferenceBuilder config;
    private Long duration;
    private String logSnippet;
    private String message;
    private BuildStatusOutputBuilder output;
    private String outputDockerImageReference;
    private String phase;
    private String reason;
    private ArrayList<StageInfoBuilder> stages = new ArrayList();
    private String startTimestamp;
    private Map<String, Object> additionalProperties;

    public BuildStatusFluent() {
    }

    public BuildStatusFluent(BuildStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BuildStatus instance) {
        BuildStatus buildStatus = instance = instance != null ? instance : new BuildStatus();
        if (instance != null) {
            this.withCancelled(instance.getCancelled());
            this.withCompletionTimestamp(instance.getCompletionTimestamp());
            this.withConditions(instance.getConditions());
            this.withConfig(instance.getConfig());
            this.withDuration(instance.getDuration());
            this.withLogSnippet(instance.getLogSnippet());
            this.withMessage(instance.getMessage());
            this.withOutput(instance.getOutput());
            this.withOutputDockerImageReference(instance.getOutputDockerImageReference());
            this.withPhase(instance.getPhase());
            this.withReason(instance.getReason());
            this.withStages(instance.getStages());
            this.withStartTimestamp(instance.getStartTimestamp());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getCancelled() {
        return this.cancelled;
    }

    public A withCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return (A)this;
    }

    public boolean hasCancelled() {
        return this.cancelled != null;
    }

    public String getCompletionTimestamp() {
        return this.completionTimestamp;
    }

    public A withCompletionTimestamp(String completionTimestamp) {
        this.completionTimestamp = completionTimestamp;
        return (A)this;
    }

    public boolean hasCompletionTimestamp() {
        return this.completionTimestamp != null;
    }

    public A addToConditions(int index, BuildCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        BuildConditionBuilder builder = new BuildConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, BuildCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        BuildConditionBuilder builder = new BuildConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(BuildCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (BuildCondition item : items) {
            BuildConditionBuilder builder = new BuildConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<BuildCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (BuildCondition item : items) {
            BuildConditionBuilder builder = new BuildConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(BuildCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (BuildCondition item : items) {
            BuildConditionBuilder builder = new BuildConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<BuildCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (BuildCondition item : items) {
            BuildConditionBuilder builder = new BuildConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<BuildConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<BuildConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            BuildConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<BuildCondition> buildConditions() {
        return this.conditions != null ? BuildStatusFluent.build(this.conditions) : null;
    }

    public BuildCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public BuildCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public BuildCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public BuildCondition buildMatchingCondition(Predicate<BuildConditionBuilder> predicate) {
        for (BuildConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<BuildConditionBuilder> predicate) {
        for (BuildConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<BuildCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (BuildCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(BuildCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (BuildCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(BuildCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, BuildCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<BuildConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ObjectReference buildConfig() {
        return this.config != null ? this.config.build() : null;
    }

    public A withConfig(ObjectReference config) {
        this._visitables.remove("config");
        if (config != null) {
            this.config = new ObjectReferenceBuilder(config);
            this._visitables.get("config").add(this.config);
        } else {
            this.config = null;
            this._visitables.get("config").remove(this.config);
        }
        return (A)this;
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public ConfigNested<A> withNewConfig() {
        return new ConfigNested(null);
    }

    public ConfigNested<A> withNewConfigLike(ObjectReference item) {
        return new ConfigNested(item);
    }

    public ConfigNested<A> editConfig() {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(null));
    }

    public ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(new ObjectReferenceBuilder().build()));
    }

    public ConfigNested<A> editOrNewConfigLike(ObjectReference item) {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(item));
    }

    public Long getDuration() {
        return this.duration;
    }

    public A withDuration(Long duration) {
        this.duration = duration;
        return (A)this;
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public String getLogSnippet() {
        return this.logSnippet;
    }

    public A withLogSnippet(String logSnippet) {
        this.logSnippet = logSnippet;
        return (A)this;
    }

    public boolean hasLogSnippet() {
        return this.logSnippet != null;
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public BuildStatusOutput buildOutput() {
        return this.output != null ? this.output.build() : null;
    }

    public A withOutput(BuildStatusOutput output) {
        this._visitables.remove("output");
        if (output != null) {
            this.output = new BuildStatusOutputBuilder(output);
            this._visitables.get("output").add(this.output);
        } else {
            this.output = null;
            this._visitables.get("output").remove(this.output);
        }
        return (A)this;
    }

    public boolean hasOutput() {
        return this.output != null;
    }

    public OutputNested<A> withNewOutput() {
        return new OutputNested(null);
    }

    public OutputNested<A> withNewOutputLike(BuildStatusOutput item) {
        return new OutputNested(item);
    }

    public OutputNested<A> editOutput() {
        return this.withNewOutputLike(Optional.ofNullable(this.buildOutput()).orElse(null));
    }

    public OutputNested<A> editOrNewOutput() {
        return this.withNewOutputLike(Optional.ofNullable(this.buildOutput()).orElse(new BuildStatusOutputBuilder().build()));
    }

    public OutputNested<A> editOrNewOutputLike(BuildStatusOutput item) {
        return this.withNewOutputLike(Optional.ofNullable(this.buildOutput()).orElse(item));
    }

    public String getOutputDockerImageReference() {
        return this.outputDockerImageReference;
    }

    public A withOutputDockerImageReference(String outputDockerImageReference) {
        this.outputDockerImageReference = outputDockerImageReference;
        return (A)this;
    }

    public boolean hasOutputDockerImageReference() {
        return this.outputDockerImageReference != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public A addToStages(int index, StageInfo item) {
        if (this.stages == null) {
            this.stages = new ArrayList();
        }
        StageInfoBuilder builder = new StageInfoBuilder(item);
        if (index < 0 || index >= this.stages.size()) {
            this._visitables.get("stages").add(builder);
            this.stages.add(builder);
        } else {
            this._visitables.get("stages").add(index, builder);
            this.stages.add(index, builder);
        }
        return (A)this;
    }

    public A setToStages(int index, StageInfo item) {
        if (this.stages == null) {
            this.stages = new ArrayList();
        }
        StageInfoBuilder builder = new StageInfoBuilder(item);
        if (index < 0 || index >= this.stages.size()) {
            this._visitables.get("stages").add(builder);
            this.stages.add(builder);
        } else {
            this._visitables.get("stages").set(index, builder);
            this.stages.set(index, builder);
        }
        return (A)this;
    }

    public A addToStages(StageInfo ... items) {
        if (this.stages == null) {
            this.stages = new ArrayList();
        }
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").add(builder);
            this.stages.add(builder);
        }
        return (A)this;
    }

    public A addAllToStages(Collection<StageInfo> items) {
        if (this.stages == null) {
            this.stages = new ArrayList();
        }
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").add(builder);
            this.stages.add(builder);
        }
        return (A)this;
    }

    public A removeFromStages(StageInfo ... items) {
        if (this.stages == null) {
            return (A)this;
        }
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").remove(builder);
            this.stages.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromStages(Collection<StageInfo> items) {
        if (this.stages == null) {
            return (A)this;
        }
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").remove(builder);
            this.stages.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromStages(Predicate<StageInfoBuilder> predicate) {
        if (this.stages == null) {
            return (A)this;
        }
        Iterator<StageInfoBuilder> each = this.stages.iterator();
        Object visitables = this._visitables.get("stages");
        while (each.hasNext()) {
            StageInfoBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<StageInfo> buildStages() {
        return this.stages != null ? BuildStatusFluent.build(this.stages) : null;
    }

    public StageInfo buildStage(int index) {
        return this.stages.get(index).build();
    }

    public StageInfo buildFirstStage() {
        return this.stages.get(0).build();
    }

    public StageInfo buildLastStage() {
        return this.stages.get(this.stages.size() - 1).build();
    }

    public StageInfo buildMatchingStage(Predicate<StageInfoBuilder> predicate) {
        for (StageInfoBuilder item : this.stages) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingStage(Predicate<StageInfoBuilder> predicate) {
        for (StageInfoBuilder item : this.stages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withStages(List<StageInfo> stages) {
        if (this.stages != null) {
            this._visitables.get("stages").clear();
        }
        if (stages != null) {
            this.stages = new ArrayList();
            for (StageInfo item : stages) {
                this.addToStages(item);
            }
        } else {
            this.stages = null;
        }
        return (A)this;
    }

    public A withStages(StageInfo ... stages) {
        if (this.stages != null) {
            this.stages.clear();
            this._visitables.remove("stages");
        }
        if (stages != null) {
            for (StageInfo item : stages) {
                this.addToStages(item);
            }
        }
        return (A)this;
    }

    public boolean hasStages() {
        return this.stages != null && !this.stages.isEmpty();
    }

    public StagesNested<A> addNewStage() {
        return new StagesNested(-1, null);
    }

    public StagesNested<A> addNewStageLike(StageInfo item) {
        return new StagesNested(-1, item);
    }

    public StagesNested<A> setNewStageLike(int index, StageInfo item) {
        return new StagesNested(index, item);
    }

    public StagesNested<A> editStage(int index) {
        if (this.stages.size() <= index) {
            throw new RuntimeException("Can't edit stages. Index exceeds size.");
        }
        return this.setNewStageLike(index, this.buildStage(index));
    }

    public StagesNested<A> editFirstStage() {
        if (this.stages.size() == 0) {
            throw new RuntimeException("Can't edit first stages. The list is empty.");
        }
        return this.setNewStageLike(0, this.buildStage(0));
    }

    public StagesNested<A> editLastStage() {
        int index = this.stages.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last stages. The list is empty.");
        }
        return this.setNewStageLike(index, this.buildStage(index));
    }

    public StagesNested<A> editMatchingStage(Predicate<StageInfoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.stages.size(); ++i) {
            if (!predicate.test(this.stages.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching stages. No match found.");
        }
        return this.setNewStageLike(index, this.buildStage(index));
    }

    public String getStartTimestamp() {
        return this.startTimestamp;
    }

    public A withStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
        return (A)this;
    }

    public boolean hasStartTimestamp() {
        return this.startTimestamp != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildStatusFluent that = (BuildStatusFluent)o;
        if (!Objects.equals(this.cancelled, that.cancelled)) {
            return false;
        }
        if (!Objects.equals(this.completionTimestamp, that.completionTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.logSnippet, that.logSnippet)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.output, that.output)) {
            return false;
        }
        if (!Objects.equals(this.outputDockerImageReference, that.outputDockerImageReference)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.stages, that.stages)) {
            return false;
        }
        if (!Objects.equals(this.startTimestamp, that.startTimestamp)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cancelled, this.completionTimestamp, this.conditions, this.config, this.duration, this.logSnippet, this.message, this.output, this.outputDockerImageReference, this.phase, this.reason, this.stages, this.startTimestamp, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cancelled != null) {
            sb.append("cancelled:");
            sb.append(this.cancelled + ",");
        }
        if (this.completionTimestamp != null) {
            sb.append("completionTimestamp:");
            sb.append(this.completionTimestamp + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.config != null) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.logSnippet != null) {
            sb.append("logSnippet:");
            sb.append(this.logSnippet + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.output != null) {
            sb.append("output:");
            sb.append(this.output + ",");
        }
        if (this.outputDockerImageReference != null) {
            sb.append("outputDockerImageReference:");
            sb.append(this.outputDockerImageReference + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.stages != null && !this.stages.isEmpty()) {
            sb.append("stages:");
            sb.append(this.stages + ",");
        }
        if (this.startTimestamp != null) {
            sb.append("startTimestamp:");
            sb.append(this.startTimestamp + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withCancelled() {
        return this.withCancelled(true);
    }

    public class StagesNested<N>
    extends StageInfoFluent<StagesNested<N>>
    implements Nested<N> {
        StageInfoBuilder builder;
        int index;

        StagesNested(int index, StageInfo item) {
            this.index = index;
            this.builder = new StageInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluent.this.setToStages(this.index, this.builder.build());
        }

        public N endStage() {
            return this.and();
        }
    }

    public class OutputNested<N>
    extends BuildStatusOutputFluent<OutputNested<N>>
    implements Nested<N> {
        BuildStatusOutputBuilder builder;

        OutputNested(BuildStatusOutput item) {
            this.builder = new BuildStatusOutputBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluent.this.withOutput(this.builder.build());
        }

        public N endOutput() {
            return this.and();
        }
    }

    public class ConfigNested<N>
    extends ObjectReferenceFluent<ConfigNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        ConfigNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluent.this.withConfig(this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends BuildConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        BuildConditionBuilder builder;
        int index;

        ConditionsNested(int index, BuildCondition item) {
            this.index = index;
            this.builder = new BuildConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

