/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_12.server.mock;

import io.fabric8.kubernetes.api.model.v6_12.GenericKubernetesResource;
import io.fabric8.kubernetes.clnt.v6_12.Watcher;
import io.fabric8.kubernetes.clnt.v6_12.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.CustomResourceAware;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.CustomResourceDefinitionProcessor;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.KubernetesAttributesExtractor;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.KubernetesResponseComposer;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.WatchEventsListener;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.crud.KubernetesCrudDispatcherException;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.crud.KubernetesCrudDispatcherHandler;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.crud.KubernetesCrudPersistence;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.crud.PatchHandler;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.crud.PostHandler;
import io.fabric8.kubernetes.clnt.v6_12.server.mock.crud.PutHandler;
import io.fabric8.kubernetes.clnt.v6_12.utils.Serialization;
import io.fabric8.kubernetes.clnt.v6_12.utils.Utils;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.crud.CrudDispatcher;
import io.fabric8.mockwebserver.crud.ResponseComposer;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import okhttp3.WebSocketListener;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCrudDispatcher
extends CrudDispatcher
implements KubernetesCrudPersistence,
CustomResourceAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesCrudDispatcher.class);
    private final Set<WatchEventsListener> watchEventListeners;
    private final CustomResourceDefinitionProcessor crdProcessor;
    private final KubernetesAttributesExtractor kubernetesAttributesExtractor;
    private final AtomicLong resourceVersion;
    private final KubernetesResponseComposer kubernetesResponseComposer;
    private final KubernetesCrudDispatcherHandler postHandler;
    private final KubernetesCrudDispatcherHandler putHandler;
    private final KubernetesCrudDispatcherHandler patchHandler;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public KubernetesCrudDispatcher() {
        this(Collections.emptyList());
    }

    public KubernetesCrudDispatcher(List<CustomResourceDefinitionContext> crdContexts) {
        super(new Context(Serialization.jsonMapper()), (AttributeExtractor)new KubernetesAttributesExtractor(), (ResponseComposer)new KubernetesResponseComposer());
        this.kubernetesAttributesExtractor = (KubernetesAttributesExtractor)this.attributeExtractor;
        this.kubernetesResponseComposer = (KubernetesResponseComposer)this.responseComposer;
        this.watchEventListeners = new CopyOnWriteArraySet<WatchEventsListener>();
        this.crdProcessor = new CustomResourceDefinitionProcessor();
        this.kubernetesAttributesExtractor.setCustomResourceDefinitionProcessor(this.crdProcessor);
        this.resourceVersion = new AtomicLong();
        this.postHandler = new PostHandler(this.kubernetesAttributesExtractor, this);
        this.putHandler = new PutHandler(this);
        this.patchHandler = new PatchHandler(this);
        crdContexts.stream().forEach(this::expectCustomResource);
    }

    MockResponse process(RecordedRequest request, KubernetesCrudDispatcherHandler handler) {
        return this.withLock(this.lock.writeLock(), () -> {
            try {
                return handler.handle(request);
            }
            catch (KubernetesCrudDispatcherException e) {
                return new MockResponse().setResponseCode(e.getCode()).setBody(e.toStatusBody());
            }
        });
    }

    public MockResponse handleCreate(RecordedRequest request) {
        return this.process(request, this.postHandler);
    }

    public MockResponse handleUpdate(RecordedRequest request) {
        return this.process(request, this.putHandler);
    }

    public MockResponse handleGet(String path) {
        return this.withLock(this.lock.readLock(), () -> {
            if (this.detectWatchMode(path)) {
                return this.handleWatch(path);
            }
            return this.handle(path, null);
        });
    }

    private MockResponse handle(String path, EventProcessor eventProcessor) {
        MockResponse response = new MockResponse();
        ArrayList<String> items = new ArrayList<String>();
        AttributeSet query = this.attributeExtractor.fromPath(path);
        new ArrayList(this.map.entrySet()).stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(query)).forEach(entry -> {
            LOGGER.debug("Entry found for query {} : {}", (Object)query, entry);
            items.add((String)entry.getValue());
            if (eventProcessor != null) {
                eventProcessor.processEvent(path, query, (AttributeSet)entry.getKey());
            }
        });
        if (query.containsKey("name")) {
            if (!items.isEmpty()) {
                response.setBody((String)items.get(0));
                response.setResponseCode(200);
            } else {
                response.setResponseCode(404);
            }
        } else {
            String metadataResult = null;
            if (items.isEmpty() && eventProcessor == null) {
                metadataResult = this.crdProcessor.getApiResources(path);
            }
            if (metadataResult != null) {
                response.setBody(metadataResult);
            } else {
                response.setBody(this.kubernetesResponseComposer.compose(items, String.valueOf(this.resourceVersion.get())));
            }
            response.setResponseCode(200);
        }
        return response;
    }

    public MockResponse handlePatch(RecordedRequest request) {
        return this.process(request, this.patchHandler);
    }

    public MockResponse handleDelete(String path) {
        return this.withLock(this.lock.writeLock(), () -> this.handle(path, this::processDelete));
    }

    private void processDelete(String path, AttributeSet pathAttributes, AttributeSet oldAttributes) {
        String jsonStringOfResource = (String)this.map.get(oldAttributes);
        GenericKubernetesResource resource = (GenericKubernetesResource)Serialization.unmarshal((String)jsonStringOfResource, GenericKubernetesResource.class);
        if (resource.getFinalizers().isEmpty()) {
            this.processEvent(path, pathAttributes, oldAttributes, null, null);
            return;
        }
        if (!resource.isMarkedForDeletion()) {
            resource.getMetadata().setDeletionTimestamp(LocalDateTime.now().toString());
            resource.getMetadata().setResourceVersion(String.valueOf(this.requestResourceVersion()));
            String updatedResource = Serialization.asJson((Object)resource);
            this.processEvent(path, pathAttributes, oldAttributes, resource, updatedResource);
            return;
        }
    }

    @Override
    public long requestResourceVersion() {
        return this.resourceVersion.incrementAndGet();
    }

    @Override
    public AttributeSet getKey(String path) {
        return this.kubernetesAttributesExtractor.fromPath(path);
    }

    @Override
    public Map.Entry<AttributeSet, String> findResource(AttributeSet attributes) {
        return this.map.entrySet().stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(attributes)).findFirst().orElse(null);
    }

    @Override
    public boolean isStatusSubresourceEnabledForResource(String path) {
        return this.crdProcessor.isStatusSubresourceEnabledForResource(this.kubernetesAttributesExtractor.fromKubernetesPath(path));
    }

    @Override
    public void processEvent(String path, AttributeSet pathAttributes, AttributeSet oldAttributes, GenericKubernetesResource resource, String newState) {
        String existing = (String)this.map.remove(oldAttributes);
        AttributeSet newAttributes = null;
        if (newState != null) {
            newAttributes = resource != null ? this.kubernetesAttributesExtractor.extract(resource) : this.kubernetesAttributesExtractor.fromResource(newState);
            if (!newAttributes.containsKey("plural")) {
                newAttributes = AttributeSet.merge((AttributeSet[])new AttributeSet[]{pathAttributes, newAttributes});
            }
            this.map.put(newAttributes, newState);
        }
        if (!Objects.equals(existing, newState)) {
            AttributeSet finalAttributeSet = newAttributes;
            this.watchEventListeners.forEach(listener -> {
                boolean matchesNew;
                boolean matchesOld = oldAttributes != null && listener.attributeMatches(oldAttributes);
                boolean bl = matchesNew = finalAttributeSet != null && listener.attributeMatches(finalAttributeSet);
                if (matchesOld && matchesNew) {
                    listener.sendWebSocketResponse(newState, Watcher.Action.MODIFIED);
                } else if (matchesOld) {
                    listener.sendWebSocketResponse(existing, Watcher.Action.DELETED);
                } else if (matchesNew) {
                    listener.sendWebSocketResponse(newState, Watcher.Action.ADDED);
                }
            });
            this.crdProcessor.process(path, (String)Utils.getNonNullOrElse((Object)newState, (Object)existing), newState == null);
        }
    }

    public MockResponse handleWatch(String path) {
        MockResponse mockResponse = new MockResponse();
        String resourceName = this.fetchResourceNameFromWatchRequestPath(path);
        AttributeSet query = this.attributeExtractor.fromPath(path);
        if (resourceName != null) {
            query = query.add(new Attribute[]{new Attribute("name", resourceName)});
        }
        WatchEventsListener watchEventListener = new WatchEventsListener(this.context, query, this.watchEventListeners, LOGGER, watch -> this.withLock(this.lock.readLock(), () -> this.map.entrySet().stream().filter(entry -> watch.attributeMatches((AttributeSet)entry.getKey())).forEach(entry -> watch.sendWebSocketResponse((String)entry.getValue(), Watcher.Action.ADDED))));
        this.watchEventListeners.add(watchEventListener);
        mockResponse.setSocketPolicy(SocketPolicy.KEEP_OPEN);
        return mockResponse.withWebSocketUpgrade((WebSocketListener)watchEventListener);
    }

    private boolean detectWatchMode(String path) {
        String queryString = null;
        try {
            queryString = new URI(path).getQuery();
        }
        catch (URISyntaxException e) {
            LOGGER.debug("incorrect URI string: [{}]", (Object)path);
            return false;
        }
        if (queryString != null && !queryString.isEmpty()) {
            return queryString.contains("watch=true");
        }
        return false;
    }

    private String fetchResourceNameFromWatchRequestPath(String path) {
        String queryString = null;
        try {
            queryString = new URI(path).getQuery();
        }
        catch (URISyntaxException e) {
            LOGGER.debug("Incorrect URI string: [{}]", (Object)path);
            return null;
        }
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        String name = "";
        for (String q : queryString.split("&")) {
            if (!q.contains("fieldSelector") || !q.contains("metadata.name")) continue;
            String[] s = q.split("=");
            name = s[s.length - 1];
        }
        return name.isEmpty() ? null : name;
    }

    @Override
    public void reset() {
        this.withLock(this.lock.writeLock(), this.map::clear);
        this.crdProcessor.reset();
    }

    @Override
    public void expectCustomResource(CustomResourceDefinitionContext rdc) {
        this.crdProcessor.addCrdContext(rdc);
    }

    private void withLock(Lock lock, Runnable task) {
        this.withLock(lock, () -> {
            task.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLock(Lock lock, Supplier<T> source) {
        lock.lock();
        try {
            this.locked(lock);
            T t = source.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    protected void locked(Lock lock) {
    }

    private static interface EventProcessor {
        public void processEvent(String var1, AttributeSet var2, AttributeSet var3);
    }
}

