/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_12.informers.impl.cache;

import io.fabric8.kubernetes.api.model.v6_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_12.ObjectMeta;
import io.fabric8.kubernetes.clnt.v6_12.informers.cache.BasicItemStore;
import io.fabric8.kubernetes.clnt.v6_12.informers.cache.Cache;
import io.fabric8.kubernetes.clnt.v6_12.informers.cache.ItemStore;
import io.fabric8.kubernetes.clnt.v6_12.utils.ReflectUtils;
import io.fabric8.kubernetes.clnt.v6_12.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CacheImpl<T extends HasMetadata>
implements Cache<T> {
    public static final String NAMESPACE_INDEX = "namespace";
    private final Map<String, Function<T, List<String>>> indexers = new HashMap<String, Function<T, List<String>>>();
    private ItemStore<T> items;
    private final Map<String, Map<String, Set<String>>> indices = new HashMap<String, Map<String, Set<String>>>();

    public CacheImpl() {
        this(NAMESPACE_INDEX, Cache::metaNamespaceIndexFunc, Cache::metaNamespaceKeyFunc);
    }

    public CacheImpl(String indexName, Function<T, List<String>> indexFunc, Function<T, String> keyFunc) {
        this.items = new BasicItemStore(keyFunc);
        this.addIndexFunc(indexName, indexFunc);
    }

    public void setItemStore(ItemStore<T> items) {
        this.items = items;
    }

    public synchronized Map<String, Function<T, List<String>>> getIndexers() {
        return Collections.unmodifiableMap(this.indexers);
    }

    public synchronized void addIndexers(Map<String, Function<T, List<String>>> indexersNew) {
        HashSet<String> intersection = new HashSet<String>(this.indexers.keySet());
        intersection.retainAll(indexersNew.keySet());
        if (!intersection.isEmpty()) {
            throw new IllegalArgumentException("Indexer conflict: " + intersection);
        }
        for (Map.Entry<String, Function<T, List<String>>> indexEntry : indexersNew.entrySet()) {
            this.addIndexFunc(indexEntry.getKey(), indexEntry.getValue());
        }
    }

    public synchronized T put(T obj) {
        if (obj == null) {
            return null;
        }
        String key = this.getKey(obj);
        HasMetadata oldObj = (HasMetadata)this.items.put(key, obj);
        this.updateIndices(oldObj, obj, key);
        return (T)oldObj;
    }

    public synchronized T remove(T obj) {
        String key = this.getKey(obj);
        HasMetadata old = (HasMetadata)this.items.remove(key);
        if (old != null) {
            this.deleteFromIndices(old, key);
        }
        return (T)old;
    }

    public List<String> listKeys() {
        return this.items.keySet().collect(Collectors.toList());
    }

    public T get(T obj) {
        String key = this.getKey(obj);
        return (T)this.getByKey(key);
    }

    public String getKey(T obj) {
        String result = this.items.getKey(obj);
        return result == null ? "" : result;
    }

    public List<T> list() {
        return this.items.values().collect(Collectors.toList());
    }

    public T getByKey(String key) {
        return (T)((HasMetadata)this.items.get(key));
    }

    public synchronized List<T> index(String indexName, T obj) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Function<T, List<String>> indexFunc = this.indexers.get(indexName);
        List<String> indexKeys = indexFunc.apply(obj);
        Map<String, Set<String>> index = this.indices.get(indexName);
        if (index.isEmpty()) {
            return new ArrayList();
        }
        HashSet<String> returnKeySet = new HashSet<String>();
        for (String indexKey : indexKeys) {
            Set<String> set = index.get(indexKey);
            if (set.isEmpty()) continue;
            returnKeySet.addAll(set);
        }
        ArrayList<Object> items = new ArrayList<Object>(returnKeySet.size());
        for (String absoluteKey : returnKeySet) {
            items.add(this.items.get(absoluteKey));
        }
        return items;
    }

    public synchronized List<String> indexKeys(String indexName, String indexKey) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Map<String, Set<String>> index = this.indices.get(indexName);
        Set<String> set = index.get(indexKey);
        ArrayList<String> keys = new ArrayList<String>(set.size());
        for (String key : set) {
            keys.add(key);
        }
        return keys;
    }

    public synchronized List<T> byIndex(String indexName, String indexKey) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Map<String, Set<String>> index = this.indices.get(indexName);
        Set<String> set = index.get(indexKey);
        if (set == null) {
            return Arrays.asList(new HasMetadata[0]);
        }
        ArrayList<Object> items = new ArrayList<Object>(set.size());
        for (String key : set) {
            items.add(this.items.get(key));
        }
        return items;
    }

    void updateIndices(T oldObj, T newObj, String key) {
        if (oldObj != null) {
            this.deleteFromIndices(oldObj, key);
        }
        for (Map.Entry<String, Function<T, List<String>>> indexEntry : this.indexers.entrySet()) {
            String indexName = indexEntry.getKey();
            Function<T, List<String>> indexFunc = indexEntry.getValue();
            Map<String, Set<String>> index = this.indices.get(indexName);
            this.updateIndex(key, newObj, indexFunc, index);
        }
    }

    private void updateIndex(String key, T newObj, Function<T, List<String>> indexFunc, Map<String, Set<String>> index) {
        List<String> indexValues = indexFunc.apply(newObj);
        if (indexValues != null && !indexValues.isEmpty()) {
            for (String indexValue : indexValues) {
                Set indexSet = index.computeIfAbsent(indexValue, k -> new HashSet());
                indexSet.add(key);
            }
        }
    }

    private void deleteFromIndices(T oldObj, String key) {
        for (Map.Entry<String, Function<T, List<String>>> indexEntry : this.indexers.entrySet()) {
            Map<String, Set<String>> index;
            Function<T, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(oldObj);
            if (indexValues == null || indexValues.isEmpty() || (index = this.indices.get(indexEntry.getKey())) == null) continue;
            for (String indexValue : indexValues) {
                Set<String> indexSet = index.get(indexValue);
                if (indexSet == null) continue;
                indexSet.remove(key);
            }
        }
    }

    public synchronized CacheImpl<T> addIndexFunc(String indexName, Function<T, List<String>> indexFunc) {
        HashMap index = new HashMap();
        this.indices.put(indexName, index);
        this.indexers.put(indexName, indexFunc);
        this.items.values().forEach(v -> this.updateIndex(this.getKey((T)v), v, indexFunc, index));
        return this;
    }

    public static String metaNamespaceKeyFunc(Object obj) {
        try {
            ObjectMeta metadata;
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof ObjectMeta) {
                metadata = (ObjectMeta)obj;
            } else {
                metadata = ReflectUtils.objectMetadata((Object)obj);
                if (metadata == null) {
                    throw new RuntimeException("Object is bad :" + obj);
                }
            }
            return CacheImpl.namespaceKeyFunc(metadata.getNamespace(), metadata.getName());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String namespaceKeyFunc(String objectNamespace, String objectName) {
        if (Utils.isNullOrEmpty((String)objectNamespace)) {
            return objectName;
        }
        return objectNamespace + "/" + objectName;
    }

    public static List<String> metaNamespaceIndexFunc(Object obj) {
        try {
            ObjectMeta metadata = ReflectUtils.objectMetadata((Object)obj);
            return metadata == null ? Collections.emptyList() : Collections.singletonList(metadata.getNamespace());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void removeIndexer(String name) {
        this.indices.remove(name);
        this.indexers.remove(name);
    }

    public boolean isFullState() {
        return this.items.isFullState();
    }

    public Object getLockObject() {
        return this;
    }
}

