/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_12.informers.impl;

import io.fabric8.kubernetes.api.model.v6_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v6_12.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v6_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_12.informers.ExceptionHandler;
import io.fabric8.kubernetes.clnt.v6_12.informers.ResourceEventHandler;
import io.fabric8.kubernetes.clnt.v6_12.informers.SharedIndexInformer;
import io.fabric8.kubernetes.clnt.v6_12.informers.cache.Indexer;
import io.fabric8.kubernetes.clnt.v6_12.informers.cache.ItemStore;
import io.fabric8.kubernetes.clnt.v6_12.informers.cache.Store;
import io.fabric8.kubernetes.clnt.v6_12.informers.impl.ListerWatcher;
import io.fabric8.kubernetes.clnt.v6_12.informers.impl.cache.CacheImpl;
import io.fabric8.kubernetes.clnt.v6_12.informers.impl.cache.ProcessorStore;
import io.fabric8.kubernetes.clnt.v6_12.informers.impl.cache.Reflector;
import io.fabric8.kubernetes.clnt.v6_12.informers.impl.cache.SharedProcessor;
import io.fabric8.kubernetes.clnt.v6_12.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSharedIndexInformer<T extends HasMetadata, L extends KubernetesResourceList<T>>
implements SharedIndexInformer<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSharedIndexInformer.class);
    private static final long MINIMUM_RESYNC_PERIOD_MILLIS = 1000L;
    private long resyncCheckPeriodMillis;
    private final long defaultEventHandlerResyncPeriod;
    private final Reflector<T, L> reflector;
    private final Class<T> apiTypeClass;
    private final ProcessorStore<T> processorStore;
    private final CacheImpl<T> indexer = new CacheImpl();
    private final SharedProcessor<T> processor;
    private final Executor informerExecutor;
    private final String description;
    private final AtomicBoolean started = new AtomicBoolean();
    private volatile boolean stopped = false;
    private Future<?> resyncFuture;
    private Stream<T> initialState;

    public DefaultSharedIndexInformer(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, long resyncPeriod, Executor informerExecutor) {
        if (resyncPeriod < 0L) {
            throw new IllegalArgumentException("Invalid resync period provided, It should be a non-negative value");
        }
        this.resyncCheckPeriodMillis = resyncPeriod;
        this.defaultEventHandlerResyncPeriod = resyncPeriod;
        this.apiTypeClass = apiTypeClass;
        this.description = listerWatcher.getApiEndpointPath();
        this.informerExecutor = informerExecutor;
        this.processor = new SharedProcessor(informerExecutor, this.description);
        this.processorStore = new ProcessorStore<T>(this.indexer, this.processor);
        this.reflector = new Reflector<T, L>(listerWatcher, this.processorStore, informerExecutor);
    }

    public DefaultSharedIndexInformer<T, L> addEventHandler(ResourceEventHandler<? super T> handler) {
        this.addEventHandlerWithResyncPeriod(handler, this.defaultEventHandlerResyncPeriod);
        return this;
    }

    public SharedIndexInformer<T> addEventHandlerWithResyncPeriod(ResourceEventHandler<? super T> handler, long resyncPeriodMillis) {
        if (this.stopped) {
            log.info("DefaultSharedIndexInformer#Handler was not added to {} because it has stopped already", (Object)this);
            return this;
        }
        if (resyncPeriodMillis > 0L) {
            if (resyncPeriodMillis < 1000L) {
                log.warn("DefaultSharedIndexInformer#resyncPeriod {} is too small for {}. Changing it to minimal allowed value of {}", new Object[]{resyncPeriodMillis, this, 1000L});
                resyncPeriodMillis = 1000L;
            }
            if (resyncPeriodMillis < this.resyncCheckPeriodMillis) {
                if (this.started.get()) {
                    log.warn("DefaultSharedIndexInformer#resyncPeriod {} is smaller than resyncCheckPeriod {} and the {} informer has already started. Changing it to {}", new Object[]{resyncPeriodMillis, this.resyncCheckPeriodMillis, this, this.resyncCheckPeriodMillis});
                    resyncPeriodMillis = this.resyncCheckPeriodMillis;
                } else {
                    this.resyncCheckPeriodMillis = resyncPeriodMillis;
                }
            }
        }
        this.processor.addProcessorListener(handler, this.determineResyncPeriod(resyncPeriodMillis, this.resyncCheckPeriodMillis), this.indexer::list);
        return this;
    }

    public String lastSyncResourceVersion() {
        return this.reflector.getLastSyncResourceVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> start() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot restart a stopped informer");
        }
        DefaultSharedIndexInformer defaultSharedIndexInformer = this;
        synchronized (defaultSharedIndexInformer) {
            if (!this.started.compareAndSet(false, true)) {
                return this.reflector.getStartFuture();
            }
            if (this.initialState != null) {
                this.initialState.forEach(this.indexer::put);
                this.reflector.usingInitialState();
            }
        }
        log.debug("Ready to run resync and reflector for {} with resync {}", (Object)this, (Object)this.resyncCheckPeriodMillis);
        this.scheduleResync(this.processor::shouldResync);
        return this.reflector.start();
    }

    public CompletableFuture<Void> started() {
        return this.reflector.getStartFuture();
    }

    public SharedIndexInformer<T> run() {
        Utils.waitUntilReadyOrFail((Future)((Object)this.start()), (long)-1L, (TimeUnit)TimeUnit.MILLISECONDS);
        return this;
    }

    public synchronized void stop() {
        this.stopped = true;
        this.reflector.stop();
        this.stopResync();
        this.processor.stop();
    }

    private synchronized void stopResync() {
        if (this.resyncFuture != null) {
            this.resyncFuture.cancel(true);
            this.resyncFuture = null;
        }
    }

    public SharedIndexInformer<T> addIndexers(Map<String, Function<T, List<String>>> indexers) {
        this.indexer.addIndexers(indexers);
        return this;
    }

    public Indexer<T> getIndexer() {
        return this.indexer;
    }

    public Store<T> getStore() {
        return this.indexer;
    }

    private long determineResyncPeriod(long desired, long check) {
        if (desired == 0L) {
            return desired;
        }
        if (check == 0L) {
            return 0L;
        }
        return Math.max(desired, check);
    }

    public boolean isRunning() {
        return !this.stopped && this.started.get() && !this.reflector.isStopped();
    }

    public boolean isWatching() {
        return this.reflector.isWatching();
    }

    synchronized void scheduleResync(BooleanSupplier resyncFunc) {
        if (this.resyncCheckPeriodMillis > 0L) {
            this.resyncFuture = Utils.scheduleAtFixedRate((Executor)this.informerExecutor, () -> {
                if (log.isDebugEnabled()) {
                    log.debug("Checking for resync at interval for {}", (Object)this);
                }
                if (resyncFunc.getAsBoolean()) {
                    log.debug("Resync running for {}", (Object)this);
                    this.processorStore.resync();
                }
            }, (long)this.resyncCheckPeriodMillis, (long)this.resyncCheckPeriodMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            log.debug("Resync skipped due to 0 full resync period for {}", (Object)this);
        }
    }

    public long getFullResyncPeriod() {
        return this.resyncCheckPeriodMillis;
    }

    Future<?> getResyncFuture() {
        return this.resyncFuture;
    }

    public Class<T> getApiTypeClass() {
        return this.apiTypeClass;
    }

    public SharedIndexInformer<T> removeIndexer(String name) {
        this.indexer.removeIndexer(name);
        return this;
    }

    public synchronized SharedIndexInformer<T> initialState(Stream<T> items) {
        if (this.started.get()) {
            throw new KubernetesClientException("Informer cannot be running when initial state is added");
        }
        this.initialState = items;
        return this;
    }

    public synchronized SharedIndexInformer<T> itemStore(ItemStore<T> itemStore) {
        if (this.started.get()) {
            throw new KubernetesClientException("Informer cannot be running when setting item store");
        }
        this.indexer.setItemStore(itemStore);
        return this;
    }

    public String toString() {
        return this.description;
    }

    public CompletableFuture<Void> stopped() {
        return this.reflector.getStopFuture();
    }

    public synchronized DefaultSharedIndexInformer<T, L> exceptionHandler(ExceptionHandler handler) {
        if (this.started.get()) {
            throw new KubernetesClientException("Informer cannot be running when handler is set");
        }
        this.reflector.setExceptionHandler(handler);
        return this;
    }
}

