/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_12.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.v6_12.Container;
import io.fabric8.kubernetes.api.model.v6_12.ReplicationController;
import io.fabric8.kubernetes.api.model.v6_12.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v6_12.Status;
import io.fabric8.kubernetes.api.model.v6_12.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v6_12.Client;
import io.fabric8.kubernetes.clnt.v6_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_12.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v6_12.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_12.dsl.PrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v6_12.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v6_12.dsl.internal.core.v1.ReplicationControllerRollingUpdater;
import io.fabric8.kubernetes.clnt.v6_12.utils.internal.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ReplicationControllerOperationsImpl
extends RollableScalableResourceOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>>
implements TimeoutImageEditReplacePatchable<ReplicationController> {
    public ReplicationControllerOperationsImpl(Client client) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public ReplicationControllerOperationsImpl(PodOperationContext context, OperationContext superContext) {
        super(context, superContext.withPlural("replicationcontrollers"), ReplicationController.class, ReplicationControllerList.class);
    }

    @Override
    public ReplicationControllerOperationsImpl newInstance(OperationContext context) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext, context);
    }

    public ReplicationControllerOperationsImpl newInstance(PodOperationContext context, OperationContext superContext) {
        return new ReplicationControllerOperationsImpl(context, superContext);
    }

    @Override
    public RollingUpdater<ReplicationController, ReplicationControllerList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicationControllerRollingUpdater(this.context.getClient(), this.namespace, rollingTimeUnit.toMillis(rollingTimeout), this.getRequestConfig().getLoggingInterval());
    }

    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of ReplicationControllers");
    }

    public String getLog(boolean isPretty) {
        return PodOperationUtil.getLog(new ReplicationControllerOperationsImpl(this.rollingOperationContext.withPrettyOutput(isPretty), this.context).doGetLog(), isPretty);
    }

    private List<PodResource> doGetLog() {
        ReplicationController rc = (ReplicationController)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, this.rollingOperationContext, rc.getMetadata().getUid(), ReplicationControllerOperationsImpl.getReplicationControllerPodLabels(rc));
    }

    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog());
    }

    public InputStream getLogInputStream() {
        return PodOperationUtil.getLogInputStream(this.doGetLog());
    }

    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(), out);
    }

    static Map<String, String> getReplicationControllerPodLabels(ReplicationController replicationController) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (replicationController != null && replicationController.getSpec() != null && replicationController.getSpec().getSelector() != null) {
            labels.putAll(replicationController.getSpec().getSelector());
        }
        return labels;
    }

    @Override
    protected List<Container> getContainers(ReplicationController value) {
        return value.getSpec().getTemplate().getSpec().getContainers();
    }

    public TimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withLimitBytes(limitBytes), this.context);
    }

    public TimeTailPrettyLoggable terminated() {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withTerminatedStatus(true), this.context);
    }

    public Loggable withPrettyOutput() {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withPrettyOutput(true), this.context);
    }

    public PrettyLoggable tailingLines(int lines) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withTailingLines(lines), this.context);
    }

    public TailPrettyLoggable sinceTime(String timestamp) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withSinceTimestamp(timestamp), this.context);
    }

    public TailPrettyLoggable sinceSeconds(int seconds) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withSinceSeconds(seconds), this.context);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withTimestamps(true), this.context);
    }
}

