/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_12.authorization.v1;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.authorization.v1.NonResourceAttributes;
import io.fabric8.kubernetes.api.model.v6_12.authorization.v1.NonResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.v6_12.authorization.v1.NonResourceAttributesFluent;
import io.fabric8.kubernetes.api.model.v6_12.authorization.v1.ResourceAttributes;
import io.fabric8.kubernetes.api.model.v6_12.authorization.v1.ResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.v6_12.authorization.v1.ResourceAttributesFluent;
import io.fabric8.kubernetes.api.model.v6_12.authorization.v1.SelfSubjectAccessReviewSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SelfSubjectAccessReviewSpecFluent<A extends SelfSubjectAccessReviewSpecFluent<A>>
extends BaseFluent<A> {
    private NonResourceAttributesBuilder nonResourceAttributes;
    private ResourceAttributesBuilder resourceAttributes;
    private Map<String, Object> additionalProperties;

    public SelfSubjectAccessReviewSpecFluent() {
    }

    public SelfSubjectAccessReviewSpecFluent(SelfSubjectAccessReviewSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SelfSubjectAccessReviewSpec instance) {
        SelfSubjectAccessReviewSpec selfSubjectAccessReviewSpec = instance = instance != null ? instance : new SelfSubjectAccessReviewSpec();
        if (instance != null) {
            this.withNonResourceAttributes(instance.getNonResourceAttributes());
            this.withResourceAttributes(instance.getResourceAttributes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NonResourceAttributes buildNonResourceAttributes() {
        return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
    }

    public A withNonResourceAttributes(NonResourceAttributes nonResourceAttributes) {
        this._visitables.remove("nonResourceAttributes");
        if (nonResourceAttributes != null) {
            this.nonResourceAttributes = new NonResourceAttributesBuilder(nonResourceAttributes);
            this._visitables.get("nonResourceAttributes").add(this.nonResourceAttributes);
        } else {
            this.nonResourceAttributes = null;
            this._visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
        }
        return (A)this;
    }

    public boolean hasNonResourceAttributes() {
        return this.nonResourceAttributes != null;
    }

    public A withNewNonResourceAttributes(String path, String verb) {
        return this.withNonResourceAttributes(new NonResourceAttributes(path, verb));
    }

    public NonResourceAttributesNested<A> withNewNonResourceAttributes() {
        return new NonResourceAttributesNested(null);
    }

    public NonResourceAttributesNested<A> withNewNonResourceAttributesLike(NonResourceAttributes item) {
        return new NonResourceAttributesNested(item);
    }

    public NonResourceAttributesNested<A> editNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(Optional.ofNullable(this.buildNonResourceAttributes()).orElse(null));
    }

    public NonResourceAttributesNested<A> editOrNewNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(Optional.ofNullable(this.buildNonResourceAttributes()).orElse(new NonResourceAttributesBuilder().build()));
    }

    public NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(NonResourceAttributes item) {
        return this.withNewNonResourceAttributesLike(Optional.ofNullable(this.buildNonResourceAttributes()).orElse(item));
    }

    public ResourceAttributes buildResourceAttributes() {
        return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
    }

    public A withResourceAttributes(ResourceAttributes resourceAttributes) {
        this._visitables.remove("resourceAttributes");
        if (resourceAttributes != null) {
            this.resourceAttributes = new ResourceAttributesBuilder(resourceAttributes);
            this._visitables.get("resourceAttributes").add(this.resourceAttributes);
        } else {
            this.resourceAttributes = null;
            this._visitables.get("resourceAttributes").remove(this.resourceAttributes);
        }
        return (A)this;
    }

    public boolean hasResourceAttributes() {
        return this.resourceAttributes != null;
    }

    public ResourceAttributesNested<A> withNewResourceAttributes() {
        return new ResourceAttributesNested(null);
    }

    public ResourceAttributesNested<A> withNewResourceAttributesLike(ResourceAttributes item) {
        return new ResourceAttributesNested(item);
    }

    public ResourceAttributesNested<A> editResourceAttributes() {
        return this.withNewResourceAttributesLike(Optional.ofNullable(this.buildResourceAttributes()).orElse(null));
    }

    public ResourceAttributesNested<A> editOrNewResourceAttributes() {
        return this.withNewResourceAttributesLike(Optional.ofNullable(this.buildResourceAttributes()).orElse(new ResourceAttributesBuilder().build()));
    }

    public ResourceAttributesNested<A> editOrNewResourceAttributesLike(ResourceAttributes item) {
        return this.withNewResourceAttributesLike(Optional.ofNullable(this.buildResourceAttributes()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelfSubjectAccessReviewSpecFluent that = (SelfSubjectAccessReviewSpecFluent)o;
        if (!Objects.equals(this.nonResourceAttributes, that.nonResourceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.resourceAttributes, that.resourceAttributes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonResourceAttributes, this.resourceAttributes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nonResourceAttributes != null) {
            sb.append("nonResourceAttributes:");
            sb.append(this.nonResourceAttributes + ",");
        }
        if (this.resourceAttributes != null) {
            sb.append("resourceAttributes:");
            sb.append(this.resourceAttributes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourceAttributesNested<N>
    extends ResourceAttributesFluent<ResourceAttributesNested<N>>
    implements Nested<N> {
        ResourceAttributesBuilder builder;

        ResourceAttributesNested(ResourceAttributes item) {
            this.builder = new ResourceAttributesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SelfSubjectAccessReviewSpecFluent.this.withResourceAttributes(this.builder.build());
        }

        public N endResourceAttributes() {
            return this.and();
        }
    }

    public class NonResourceAttributesNested<N>
    extends NonResourceAttributesFluent<NonResourceAttributesNested<N>>
    implements Nested<N> {
        NonResourceAttributesBuilder builder;

        NonResourceAttributesNested(NonResourceAttributes item) {
            this.builder = new NonResourceAttributesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SelfSubjectAccessReviewSpecFluent.this.withNonResourceAttributes(this.builder.build());
        }

        public N endNonResourceAttributes() {
            return this.and();
        }
    }
}

