/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_12;

import io.fabric8.kubernetes.api.builder.v6_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_12.Nested;
import io.fabric8.kubernetes.api.model.v6_12.ContainerState;
import io.fabric8.kubernetes.api.model.v6_12.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.v6_12.ContainerStateRunningBuilder;
import io.fabric8.kubernetes.api.model.v6_12.ContainerStateRunningFluent;
import io.fabric8.kubernetes.api.model.v6_12.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.v6_12.ContainerStateTerminatedBuilder;
import io.fabric8.kubernetes.api.model.v6_12.ContainerStateTerminatedFluent;
import io.fabric8.kubernetes.api.model.v6_12.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.v6_12.ContainerStateWaitingBuilder;
import io.fabric8.kubernetes.api.model.v6_12.ContainerStateWaitingFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContainerStateFluent<A extends ContainerStateFluent<A>>
extends BaseFluent<A> {
    private ContainerStateRunningBuilder running;
    private ContainerStateTerminatedBuilder terminated;
    private ContainerStateWaitingBuilder waiting;
    private Map<String, Object> additionalProperties;

    public ContainerStateFluent() {
    }

    public ContainerStateFluent(ContainerState instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ContainerState instance) {
        ContainerState containerState = instance = instance != null ? instance : new ContainerState();
        if (instance != null) {
            this.withRunning(instance.getRunning());
            this.withTerminated(instance.getTerminated());
            this.withWaiting(instance.getWaiting());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ContainerStateRunning buildRunning() {
        return this.running != null ? this.running.build() : null;
    }

    public A withRunning(ContainerStateRunning running) {
        this._visitables.remove("running");
        if (running != null) {
            this.running = new ContainerStateRunningBuilder(running);
            this._visitables.get("running").add(this.running);
        } else {
            this.running = null;
            this._visitables.get("running").remove(this.running);
        }
        return (A)this;
    }

    public boolean hasRunning() {
        return this.running != null;
    }

    public A withNewRunning(String startedAt) {
        return this.withRunning(new ContainerStateRunning(startedAt));
    }

    public RunningNested<A> withNewRunning() {
        return new RunningNested(null);
    }

    public RunningNested<A> withNewRunningLike(ContainerStateRunning item) {
        return new RunningNested(item);
    }

    public RunningNested<A> editRunning() {
        return this.withNewRunningLike(Optional.ofNullable(this.buildRunning()).orElse(null));
    }

    public RunningNested<A> editOrNewRunning() {
        return this.withNewRunningLike(Optional.ofNullable(this.buildRunning()).orElse(new ContainerStateRunningBuilder().build()));
    }

    public RunningNested<A> editOrNewRunningLike(ContainerStateRunning item) {
        return this.withNewRunningLike(Optional.ofNullable(this.buildRunning()).orElse(item));
    }

    public ContainerStateTerminated buildTerminated() {
        return this.terminated != null ? this.terminated.build() : null;
    }

    public A withTerminated(ContainerStateTerminated terminated) {
        this._visitables.remove("terminated");
        if (terminated != null) {
            this.terminated = new ContainerStateTerminatedBuilder(terminated);
            this._visitables.get("terminated").add(this.terminated);
        } else {
            this.terminated = null;
            this._visitables.get("terminated").remove(this.terminated);
        }
        return (A)this;
    }

    public boolean hasTerminated() {
        return this.terminated != null;
    }

    public TerminatedNested<A> withNewTerminated() {
        return new TerminatedNested(null);
    }

    public TerminatedNested<A> withNewTerminatedLike(ContainerStateTerminated item) {
        return new TerminatedNested(item);
    }

    public TerminatedNested<A> editTerminated() {
        return this.withNewTerminatedLike(Optional.ofNullable(this.buildTerminated()).orElse(null));
    }

    public TerminatedNested<A> editOrNewTerminated() {
        return this.withNewTerminatedLike(Optional.ofNullable(this.buildTerminated()).orElse(new ContainerStateTerminatedBuilder().build()));
    }

    public TerminatedNested<A> editOrNewTerminatedLike(ContainerStateTerminated item) {
        return this.withNewTerminatedLike(Optional.ofNullable(this.buildTerminated()).orElse(item));
    }

    public ContainerStateWaiting buildWaiting() {
        return this.waiting != null ? this.waiting.build() : null;
    }

    public A withWaiting(ContainerStateWaiting waiting) {
        this._visitables.remove("waiting");
        if (waiting != null) {
            this.waiting = new ContainerStateWaitingBuilder(waiting);
            this._visitables.get("waiting").add(this.waiting);
        } else {
            this.waiting = null;
            this._visitables.get("waiting").remove(this.waiting);
        }
        return (A)this;
    }

    public boolean hasWaiting() {
        return this.waiting != null;
    }

    public A withNewWaiting(String message, String reason) {
        return this.withWaiting(new ContainerStateWaiting(message, reason));
    }

    public WaitingNested<A> withNewWaiting() {
        return new WaitingNested(null);
    }

    public WaitingNested<A> withNewWaitingLike(ContainerStateWaiting item) {
        return new WaitingNested(item);
    }

    public WaitingNested<A> editWaiting() {
        return this.withNewWaitingLike(Optional.ofNullable(this.buildWaiting()).orElse(null));
    }

    public WaitingNested<A> editOrNewWaiting() {
        return this.withNewWaitingLike(Optional.ofNullable(this.buildWaiting()).orElse(new ContainerStateWaitingBuilder().build()));
    }

    public WaitingNested<A> editOrNewWaitingLike(ContainerStateWaiting item) {
        return this.withNewWaitingLike(Optional.ofNullable(this.buildWaiting()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateFluent that = (ContainerStateFluent)o;
        if (!Objects.equals(this.running, that.running)) {
            return false;
        }
        if (!Objects.equals(this.terminated, that.terminated)) {
            return false;
        }
        if (!Objects.equals(this.waiting, that.waiting)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.running, this.terminated, this.waiting, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.running != null) {
            sb.append("running:");
            sb.append(this.running + ",");
        }
        if (this.terminated != null) {
            sb.append("terminated:");
            sb.append(this.terminated + ",");
        }
        if (this.waiting != null) {
            sb.append("waiting:");
            sb.append(this.waiting + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WaitingNested<N>
    extends ContainerStateWaitingFluent<WaitingNested<N>>
    implements Nested<N> {
        ContainerStateWaitingBuilder builder;

        WaitingNested(ContainerStateWaiting item) {
            this.builder = new ContainerStateWaitingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluent.this.withWaiting(this.builder.build());
        }

        public N endWaiting() {
            return this.and();
        }
    }

    public class TerminatedNested<N>
    extends ContainerStateTerminatedFluent<TerminatedNested<N>>
    implements Nested<N> {
        ContainerStateTerminatedBuilder builder;

        TerminatedNested(ContainerStateTerminated item) {
            this.builder = new ContainerStateTerminatedBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluent.this.withTerminated(this.builder.build());
        }

        public N endTerminated() {
            return this.and();
        }
    }

    public class RunningNested<N>
    extends ContainerStateRunningFluent<RunningNested<N>>
    implements Nested<N> {
        ContainerStateRunningBuilder builder;

        RunningNested(ContainerStateRunning item) {
            this.builder = new ContainerStateRunningBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerStateFluent.this.withRunning(this.builder.build());
        }

        public N endRunning() {
            return this.and();
        }
    }
}

