/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v6_12;

import io.fabric8.kubernetes.api.builder.v6_12.Visitor;
import io.fabric8.kubernetes.api.builder.v6_12.VisitorWiretap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public interface VisitorListener {
    public static final AtomicBoolean loaded = new AtomicBoolean();
    public static final Set<VisitorListener> listeners = new HashSet<VisitorListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<VisitorListener> getListeners() {
        if (loaded.get()) {
            return listeners;
        }
        AtomicBoolean atomicBoolean = loaded;
        synchronized (atomicBoolean) {
            listeners.add(new VisitorListener(){});
            for (VisitorListener listener : ServiceLoader.load(VisitorListener.class, VisitorListener.class.getClassLoader())) {
                listeners.add(listener);
            }
            if (Thread.currentThread().getContextClassLoader() != null) {
                for (VisitorListener listener : ServiceLoader.load(VisitorListener.class, Thread.currentThread().getContextClassLoader())) {
                    listeners.add(listener);
                }
            }
            loaded.set(true);
        }
        return listeners;
    }

    public static <T> Visitor<T> wrap(Visitor<T> visitor) {
        return VisitorWiretap.create(visitor, VisitorListener.getListeners());
    }

    public static void register(VisitorListener listener) {
        listeners.add(listener);
    }

    public static void unregister(VisitorListener listener) {
        listeners.add(listener);
    }

    default public <T> void beforeVisit(Visitor<T> v, List<Map.Entry<String, Object>> path, T target) {
    }

    default public <T> void afterVisit(Visitor<T> v, List<Map.Entry<String, Object>> path, T target) {
    }

    default public <V, T> void onCheck(Visitor<V> v, boolean canVisit, T target) {
    }
}

