/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v6_10.server.mock;

import io.fabric8.kubernetes.clnt.v6_10.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.clnt.v6_10.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.openshift.clnt.v6_10.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v6_10.OpenShiftClient;
import io.fabric8.openshift.clnt.v6_10.server.mock.EnableOpenShiftMockClient;
import io.fabric8.openshift.clnt.v6_10.server.mock.OpenShiftMockServer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class OpenShiftMockServerExtension
extends KubernetesMockServerExtension {
    private OpenShiftMockServer openShiftMockServer;
    private NamespacedOpenShiftClient openShiftClient;

    @Override
    protected void destroy() {
        this.openShiftMockServer.destroy();
        this.openShiftClient.close();
    }

    @Override
    protected Class<?> getClientType() {
        return OpenShiftClient.class;
    }

    @Override
    protected Class<?> getKubernetesMockServerType() {
        return OpenShiftMockServer.class;
    }

    @Override
    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableOpenShiftMockClient a = testClass.getAnnotation(EnableOpenShiftMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.openShiftMockServer = a.crud() ? new OpenShiftMockServer(new Context(), new MockWebServer(), responses, new KubernetesMixedDispatcher(responses), a.https()) : new OpenShiftMockServer(a.https());
        this.openShiftMockServer.init();
        this.openShiftClient = this.openShiftMockServer.createOpenShiftClient();
    }

    @Override
    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.openShiftClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, this.openShiftMockServer));
    }
}

