/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1.CatalogSourceSpec;
import io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1.GrpcPodConfig;
import io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1.GrpcPodConfigBuilder;
import io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1.GrpcPodConfigFluent;
import io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1.Icon;
import io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1.IconBuilder;
import io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1.IconFluent;
import io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1.UpdateStrategy;
import io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1.UpdateStrategyBuilder;
import io.fabric8.openshift.api.model.v6_10.operatorhub.v1alpha1.UpdateStrategyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CatalogSourceSpecFluent<A extends CatalogSourceSpecFluent<A>>
extends BaseFluent<A> {
    private String address;
    private String configMap;
    private String description;
    private String displayName;
    private GrpcPodConfigBuilder grpcPodConfig;
    private IconBuilder icon;
    private String image;
    private Integer priority;
    private String publisher;
    private List<String> secrets = new ArrayList<String>();
    private String sourceType;
    private UpdateStrategyBuilder updateStrategy;
    private Map<String, Object> additionalProperties;

    public CatalogSourceSpecFluent() {
    }

    public CatalogSourceSpecFluent(CatalogSourceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CatalogSourceSpec instance) {
        CatalogSourceSpec catalogSourceSpec = instance = instance != null ? instance : new CatalogSourceSpec();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withConfigMap(instance.getConfigMap());
            this.withDescription(instance.getDescription());
            this.withDisplayName(instance.getDisplayName());
            this.withGrpcPodConfig(instance.getGrpcPodConfig());
            this.withIcon(instance.getIcon());
            this.withImage(instance.getImage());
            this.withPriority(instance.getPriority());
            this.withPublisher(instance.getPublisher());
            this.withSecrets(instance.getSecrets());
            this.withSourceType(instance.getSourceType());
            this.withUpdateStrategy(instance.getUpdateStrategy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAddress() {
        return this.address;
    }

    public A withAddress(String address) {
        this.address = address;
        return (A)this;
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public String getConfigMap() {
        return this.configMap;
    }

    public A withConfigMap(String configMap) {
        this.configMap = configMap;
        return (A)this;
    }

    public boolean hasConfigMap() {
        return this.configMap != null;
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)this;
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public GrpcPodConfig buildGrpcPodConfig() {
        return this.grpcPodConfig != null ? this.grpcPodConfig.build() : null;
    }

    public A withGrpcPodConfig(GrpcPodConfig grpcPodConfig) {
        this._visitables.remove("grpcPodConfig");
        if (grpcPodConfig != null) {
            this.grpcPodConfig = new GrpcPodConfigBuilder(grpcPodConfig);
            this._visitables.get("grpcPodConfig").add(this.grpcPodConfig);
        } else {
            this.grpcPodConfig = null;
            this._visitables.get("grpcPodConfig").remove(this.grpcPodConfig);
        }
        return (A)this;
    }

    public boolean hasGrpcPodConfig() {
        return this.grpcPodConfig != null;
    }

    public GrpcPodConfigNested<A> withNewGrpcPodConfig() {
        return new GrpcPodConfigNested(null);
    }

    public GrpcPodConfigNested<A> withNewGrpcPodConfigLike(GrpcPodConfig item) {
        return new GrpcPodConfigNested(item);
    }

    public GrpcPodConfigNested<A> editGrpcPodConfig() {
        return this.withNewGrpcPodConfigLike(Optional.ofNullable(this.buildGrpcPodConfig()).orElse(null));
    }

    public GrpcPodConfigNested<A> editOrNewGrpcPodConfig() {
        return this.withNewGrpcPodConfigLike(Optional.ofNullable(this.buildGrpcPodConfig()).orElse(new GrpcPodConfigBuilder().build()));
    }

    public GrpcPodConfigNested<A> editOrNewGrpcPodConfigLike(GrpcPodConfig item) {
        return this.withNewGrpcPodConfigLike(Optional.ofNullable(this.buildGrpcPodConfig()).orElse(item));
    }

    public Icon buildIcon() {
        return this.icon != null ? this.icon.build() : null;
    }

    public A withIcon(Icon icon) {
        this._visitables.remove("icon");
        if (icon != null) {
            this.icon = new IconBuilder(icon);
            this._visitables.get("icon").add(this.icon);
        } else {
            this.icon = null;
            this._visitables.get("icon").remove(this.icon);
        }
        return (A)this;
    }

    public boolean hasIcon() {
        return this.icon != null;
    }

    public A withNewIcon(String base64data, String mediatype) {
        return this.withIcon(new Icon(base64data, mediatype));
    }

    public IconNested<A> withNewIcon() {
        return new IconNested(null);
    }

    public IconNested<A> withNewIconLike(Icon item) {
        return new IconNested(item);
    }

    public IconNested<A> editIcon() {
        return this.withNewIconLike(Optional.ofNullable(this.buildIcon()).orElse(null));
    }

    public IconNested<A> editOrNewIcon() {
        return this.withNewIconLike(Optional.ofNullable(this.buildIcon()).orElse(new IconBuilder().build()));
    }

    public IconNested<A> editOrNewIconLike(Icon item) {
        return this.withNewIconLike(Optional.ofNullable(this.buildIcon()).orElse(item));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public A withPublisher(String publisher) {
        this.publisher = publisher;
        return (A)this;
    }

    public boolean hasPublisher() {
        return this.publisher != null;
    }

    public A addToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.add(index, item);
        return (A)this;
    }

    public A setToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.set(index, item);
        return (A)this;
    }

    public A addToSecrets(String ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)this;
    }

    public A addAllToSecrets(Collection<String> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)this;
    }

    public A removeFromSecrets(String ... items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.secrets.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSecrets(Collection<String> items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.secrets.remove(item);
        }
        return (A)this;
    }

    public List<String> getSecrets() {
        return this.secrets;
    }

    public String getSecret(int index) {
        return this.secrets.get(index);
    }

    public String getFirstSecret() {
        return this.secrets.get(0);
    }

    public String getLastSecret() {
        return this.secrets.get(this.secrets.size() - 1);
    }

    public String getMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecrets(List<String> secrets) {
        if (secrets != null) {
            this.secrets = new ArrayList<String>();
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    public A withSecrets(String ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove("secrets");
        }
        if (secrets != null) {
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    public boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public A withSourceType(String sourceType) {
        this.sourceType = sourceType;
        return (A)this;
    }

    public boolean hasSourceType() {
        return this.sourceType != null;
    }

    public UpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    public A withUpdateStrategy(UpdateStrategy updateStrategy) {
        this._visitables.remove("updateStrategy");
        if (updateStrategy != null) {
            this.updateStrategy = new UpdateStrategyBuilder(updateStrategy);
            this._visitables.get("updateStrategy").add(this.updateStrategy);
        } else {
            this.updateStrategy = null;
            this._visitables.get("updateStrategy").remove(this.updateStrategy);
        }
        return (A)this;
    }

    public boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    public UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNested(null);
    }

    public UpdateStrategyNested<A> withNewUpdateStrategyLike(UpdateStrategy item) {
        return new UpdateStrategyNested(item);
    }

    public UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(null));
    }

    public UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(new UpdateStrategyBuilder().build()));
    }

    public UpdateStrategyNested<A> editOrNewUpdateStrategyLike(UpdateStrategy item) {
        return this.withNewUpdateStrategyLike(Optional.ofNullable(this.buildUpdateStrategy()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CatalogSourceSpecFluent that = (CatalogSourceSpecFluent)o;
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        if (!Objects.equals(this.configMap, that.configMap)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.displayName, that.displayName)) {
            return false;
        }
        if (!Objects.equals(this.grpcPodConfig, that.grpcPodConfig)) {
            return false;
        }
        if (!Objects.equals(this.icon, that.icon)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.publisher, that.publisher)) {
            return false;
        }
        if (!Objects.equals(this.secrets, that.secrets)) {
            return false;
        }
        if (!Objects.equals(this.sourceType, that.sourceType)) {
            return false;
        }
        if (!Objects.equals(this.updateStrategy, that.updateStrategy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.address, this.configMap, this.description, this.displayName, this.grpcPodConfig, this.icon, this.image, this.priority, this.publisher, this.secrets, this.sourceType, this.updateStrategy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append(this.configMap + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.displayName != null) {
            sb.append("displayName:");
            sb.append(this.displayName + ",");
        }
        if (this.grpcPodConfig != null) {
            sb.append("grpcPodConfig:");
            sb.append(this.grpcPodConfig + ",");
        }
        if (this.icon != null) {
            sb.append("icon:");
            sb.append(this.icon + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.publisher != null) {
            sb.append("publisher:");
            sb.append(this.publisher + ",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(this.secrets + ",");
        }
        if (this.sourceType != null) {
            sb.append("sourceType:");
            sb.append(this.sourceType + ",");
        }
        if (this.updateStrategy != null) {
            sb.append("updateStrategy:");
            sb.append(this.updateStrategy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UpdateStrategyNested<N>
    extends UpdateStrategyFluent<UpdateStrategyNested<N>>
    implements Nested<N> {
        UpdateStrategyBuilder builder;

        UpdateStrategyNested(UpdateStrategy item) {
            this.builder = new UpdateStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CatalogSourceSpecFluent.this.withUpdateStrategy(this.builder.build());
        }

        public N endUpdateStrategy() {
            return this.and();
        }
    }

    public class IconNested<N>
    extends IconFluent<IconNested<N>>
    implements Nested<N> {
        IconBuilder builder;

        IconNested(Icon item) {
            this.builder = new IconBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CatalogSourceSpecFluent.this.withIcon(this.builder.build());
        }

        public N endIcon() {
            return this.and();
        }
    }

    public class GrpcPodConfigNested<N>
    extends GrpcPodConfigFluent<GrpcPodConfigNested<N>>
    implements Nested<N> {
        GrpcPodConfigBuilder builder;

        GrpcPodConfigNested(GrpcPodConfig item) {
            this.builder = new GrpcPodConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CatalogSourceSpecFluent.this.withGrpcPodConfig(this.builder.build());
        }

        public N endGrpcPodConfig() {
            return this.and();
        }
    }
}

