/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.openshift.api.model.v6_10.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.v6_10.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PodNetworkConnectivityCheckSpecFluent<A extends PodNetworkConnectivityCheckSpecFluent<A>>
extends BaseFluent<A> {
    private String sourcePod;
    private String targetEndpoint;
    private SecretNameReference tlsClientCert;
    private Map<String, Object> additionalProperties;

    public PodNetworkConnectivityCheckSpecFluent() {
    }

    public PodNetworkConnectivityCheckSpecFluent(PodNetworkConnectivityCheckSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodNetworkConnectivityCheckSpec instance) {
        PodNetworkConnectivityCheckSpec podNetworkConnectivityCheckSpec = instance = instance != null ? instance : new PodNetworkConnectivityCheckSpec();
        if (instance != null) {
            this.withSourcePod(instance.getSourcePod());
            this.withTargetEndpoint(instance.getTargetEndpoint());
            this.withTlsClientCert(instance.getTlsClientCert());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getSourcePod() {
        return this.sourcePod;
    }

    public A withSourcePod(String sourcePod) {
        this.sourcePod = sourcePod;
        return (A)this;
    }

    public boolean hasSourcePod() {
        return this.sourcePod != null;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public A withTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
        return (A)this;
    }

    public boolean hasTargetEndpoint() {
        return this.targetEndpoint != null;
    }

    public SecretNameReference getTlsClientCert() {
        return this.tlsClientCert;
    }

    public A withTlsClientCert(SecretNameReference tlsClientCert) {
        this.tlsClientCert = tlsClientCert;
        return (A)this;
    }

    public boolean hasTlsClientCert() {
        return this.tlsClientCert != null;
    }

    public A withNewTlsClientCert(String name) {
        return this.withTlsClientCert(new SecretNameReference(name));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodNetworkConnectivityCheckSpecFluent that = (PodNetworkConnectivityCheckSpecFluent)o;
        if (!Objects.equals(this.sourcePod, that.sourcePod)) {
            return false;
        }
        if (!Objects.equals(this.targetEndpoint, that.targetEndpoint)) {
            return false;
        }
        if (!Objects.equals(this.tlsClientCert, that.tlsClientCert)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sourcePod, this.targetEndpoint, this.tlsClientCert, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourcePod != null) {
            sb.append("sourcePod:");
            sb.append(this.sourcePod + ",");
        }
        if (this.targetEndpoint != null) {
            sb.append("targetEndpoint:");
            sb.append(this.targetEndpoint + ",");
        }
        if (this.tlsClientCert != null) {
            sb.append("tlsClientCert:");
            sb.append(this.tlsClientCert + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

