/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.IntOrString;
import io.fabric8.kubernetes.api.model.v6_10.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.v6_10.IntOrStringFluent;
import io.fabric8.openshift.api.model.v6_10.monitoring.v1.Rule;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RuleFluent<A extends RuleFluent<A>>
extends BaseFluent<A> {
    private String alert;
    private Map<String, String> annotations;
    private IntOrStringBuilder expr;
    private String _for;
    private String keepFiringFor;
    private Map<String, String> labels;
    private String record;
    private Map<String, Object> additionalProperties;

    public RuleFluent() {
    }

    public RuleFluent(Rule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Rule instance) {
        Rule rule = instance = instance != null ? instance : new Rule();
        if (instance != null) {
            this.withAlert(instance.getAlert());
            this.withAnnotations(instance.getAnnotations());
            this.withExpr(instance.getExpr());
            this.withFor(instance.getFor());
            this.withKeepFiringFor(instance.getKeepFiringFor());
            this.withLabels(instance.getLabels());
            this.withRecord(instance.getRecord());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAlert() {
        return this.alert;
    }

    public A withAlert(String alert) {
        this.alert = alert;
        return (A)this;
    }

    public boolean hasAlert() {
        return this.alert != null;
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public IntOrString buildExpr() {
        return this.expr != null ? this.expr.build() : null;
    }

    public A withExpr(IntOrString expr) {
        this._visitables.remove("expr");
        if (expr != null) {
            this.expr = new IntOrStringBuilder(expr);
            this._visitables.get("expr").add(this.expr);
        } else {
            this.expr = null;
            this._visitables.get("expr").remove(this.expr);
        }
        return (A)this;
    }

    public boolean hasExpr() {
        return this.expr != null;
    }

    public A withNewExpr(Object value) {
        return this.withExpr(new IntOrString(value));
    }

    public ExprNested<A> withNewExpr() {
        return new ExprNested(null);
    }

    public ExprNested<A> withNewExprLike(IntOrString item) {
        return new ExprNested(item);
    }

    public ExprNested<A> editExpr() {
        return this.withNewExprLike(Optional.ofNullable(this.buildExpr()).orElse(null));
    }

    public ExprNested<A> editOrNewExpr() {
        return this.withNewExprLike(Optional.ofNullable(this.buildExpr()).orElse(new IntOrStringBuilder().build()));
    }

    public ExprNested<A> editOrNewExprLike(IntOrString item) {
        return this.withNewExprLike(Optional.ofNullable(this.buildExpr()).orElse(item));
    }

    public String getFor() {
        return this._for;
    }

    public A withFor(String _for) {
        this._for = _for;
        return (A)this;
    }

    public boolean hasFor() {
        return this._for != null;
    }

    public String getKeepFiringFor() {
        return this.keepFiringFor;
    }

    public A withKeepFiringFor(String keepFiringFor) {
        this.keepFiringFor = keepFiringFor;
        return (A)this;
    }

    public boolean hasKeepFiringFor() {
        return this.keepFiringFor != null;
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public String getRecord() {
        return this.record;
    }

    public A withRecord(String record) {
        this.record = record;
        return (A)this;
    }

    public boolean hasRecord() {
        return this.record != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleFluent that = (RuleFluent)o;
        if (!Objects.equals(this.alert, that.alert)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.expr, that.expr)) {
            return false;
        }
        if (!Objects.equals(this._for, that._for)) {
            return false;
        }
        if (!Objects.equals(this.keepFiringFor, that.keepFiringFor)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.record, that.record)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alert, this.annotations, this.expr, this._for, this.keepFiringFor, this.labels, this.record, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alert != null) {
            sb.append("alert:");
            sb.append(this.alert + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.expr != null) {
            sb.append("expr:");
            sb.append(this.expr + ",");
        }
        if (this._for != null) {
            sb.append("_for:");
            sb.append(this._for + ",");
        }
        if (this.keepFiringFor != null) {
            sb.append("keepFiringFor:");
            sb.append(this.keepFiringFor + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.record != null) {
            sb.append("record:");
            sb.append(this.record + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ExprNested<N>
    extends IntOrStringFluent<ExprNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        ExprNested(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RuleFluent.this.withExpr(this.builder.build());
        }

        public N endExpr() {
            return this.and();
        }
    }
}

