/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.openshift.api.model.v6_10.config.v1.VSpherePlatformLoadBalancer;
import io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1.FailureDomain;
import io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1.FailureDomainBuilder;
import io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1.FailureDomainFluent;
import io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1.Platform;
import io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1.VCenter;
import io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1.VCenterBuilder;
import io.fabric8.openshift.api.model.v6_10.installer.vsphere.v1.VCenterFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private String apiVIP;
    private List<String> apiVIPs = new ArrayList<String>();
    private String cluster;
    private String clusterOSImage;
    private String datacenter;
    private String defaultDatastore;
    private MachinePoolBuilder defaultMachinePlatform;
    private String diskType;
    private ArrayList<FailureDomainBuilder> failureDomains = new ArrayList();
    private String folder;
    private String ingressVIP;
    private List<String> ingressVIPs = new ArrayList<String>();
    private VSpherePlatformLoadBalancer loadBalancer;
    private String network;
    private String password;
    private String resourcePool;
    private String username;
    private String vCenter;
    private ArrayList<VCenterBuilder> vcenters = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withApiVIP(instance.getApiVIP());
            this.withApiVIPs(instance.getApiVIPs());
            this.withCluster(instance.getCluster());
            this.withClusterOSImage(instance.getClusterOSImage());
            this.withDatacenter(instance.getDatacenter());
            this.withDefaultDatastore(instance.getDefaultDatastore());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withDiskType(instance.getDiskType());
            this.withFailureDomains(instance.getFailureDomains());
            this.withFolder(instance.getFolder());
            this.withIngressVIP(instance.getIngressVIP());
            this.withIngressVIPs(instance.getIngressVIPs());
            this.withLoadBalancer(instance.getLoadBalancer());
            this.withNetwork(instance.getNetwork());
            this.withPassword(instance.getPassword());
            this.withResourcePool(instance.getResourcePool());
            this.withUsername(instance.getUsername());
            this.withVCenter(instance.getVCenter());
            this.withVcenters(instance.getVcenters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVIP() {
        return this.apiVIP;
    }

    public A withApiVIP(String apiVIP) {
        this.apiVIP = apiVIP;
        return (A)this;
    }

    public boolean hasApiVIP() {
        return this.apiVIP != null;
    }

    public A addToApiVIPs(int index, String item) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        this.apiVIPs.add(index, item);
        return (A)this;
    }

    public A setToApiVIPs(int index, String item) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        this.apiVIPs.set(index, item);
        return (A)this;
    }

    public A addToApiVIPs(String ... items) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVIPs.add(item);
        }
        return (A)this;
    }

    public A addAllToApiVIPs(Collection<String> items) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVIPs.add(item);
        }
        return (A)this;
    }

    public A removeFromApiVIPs(String ... items) {
        if (this.apiVIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.apiVIPs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromApiVIPs(Collection<String> items) {
        if (this.apiVIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.apiVIPs.remove(item);
        }
        return (A)this;
    }

    public List<String> getApiVIPs() {
        return this.apiVIPs;
    }

    public String getApiVIP(int index) {
        return this.apiVIPs.get(index);
    }

    public String getFirstApiVIP() {
        return this.apiVIPs.get(0);
    }

    public String getLastApiVIP() {
        return this.apiVIPs.get(this.apiVIPs.size() - 1);
    }

    public String getMatchingApiVIP(Predicate<String> predicate) {
        for (String item : this.apiVIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingApiVIP(Predicate<String> predicate) {
        for (String item : this.apiVIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withApiVIPs(List<String> apiVIPs) {
        if (apiVIPs != null) {
            this.apiVIPs = new ArrayList<String>();
            for (String item : apiVIPs) {
                this.addToApiVIPs(item);
            }
        } else {
            this.apiVIPs = null;
        }
        return (A)this;
    }

    public A withApiVIPs(String ... apiVIPs) {
        if (this.apiVIPs != null) {
            this.apiVIPs.clear();
            this._visitables.remove("apiVIPs");
        }
        if (apiVIPs != null) {
            for (String item : apiVIPs) {
                this.addToApiVIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasApiVIPs() {
        return this.apiVIPs != null && !this.apiVIPs.isEmpty();
    }

    public String getCluster() {
        return this.cluster;
    }

    public A withCluster(String cluster) {
        this.cluster = cluster;
        return (A)this;
    }

    public boolean hasCluster() {
        return this.cluster != null;
    }

    public String getClusterOSImage() {
        return this.clusterOSImage;
    }

    public A withClusterOSImage(String clusterOSImage) {
        this.clusterOSImage = clusterOSImage;
        return (A)this;
    }

    public boolean hasClusterOSImage() {
        return this.clusterOSImage != null;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public A withDatacenter(String datacenter) {
        this.datacenter = datacenter;
        return (A)this;
    }

    public boolean hasDatacenter() {
        return this.datacenter != null;
    }

    public String getDefaultDatastore() {
        return this.defaultDatastore;
    }

    public A withDefaultDatastore(String defaultDatastore) {
        this.defaultDatastore = defaultDatastore;
        return (A)this;
    }

    public boolean hasDefaultDatastore() {
        return this.defaultDatastore != null;
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove("defaultMachinePlatform");
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public String getDiskType() {
        return this.diskType;
    }

    public A withDiskType(String diskType) {
        this.diskType = diskType;
        return (A)this;
    }

    public boolean hasDiskType() {
        return this.diskType != null;
    }

    public A addToFailureDomains(int index, FailureDomain item) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        FailureDomainBuilder builder = new FailureDomainBuilder(item);
        if (index < 0 || index >= this.failureDomains.size()) {
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        } else {
            this._visitables.get("failureDomains").add(index, builder);
            this.failureDomains.add(index, builder);
        }
        return (A)this;
    }

    public A setToFailureDomains(int index, FailureDomain item) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        FailureDomainBuilder builder = new FailureDomainBuilder(item);
        if (index < 0 || index >= this.failureDomains.size()) {
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        } else {
            this._visitables.get("failureDomains").set(index, builder);
            this.failureDomains.set(index, builder);
        }
        return (A)this;
    }

    public A addToFailureDomains(FailureDomain ... items) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        for (FailureDomain item : items) {
            FailureDomainBuilder builder = new FailureDomainBuilder(item);
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        }
        return (A)this;
    }

    public A addAllToFailureDomains(Collection<FailureDomain> items) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        for (FailureDomain item : items) {
            FailureDomainBuilder builder = new FailureDomainBuilder(item);
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        }
        return (A)this;
    }

    public A removeFromFailureDomains(FailureDomain ... items) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        for (FailureDomain item : items) {
            FailureDomainBuilder builder = new FailureDomainBuilder(item);
            this._visitables.get("failureDomains").remove(builder);
            this.failureDomains.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFailureDomains(Collection<FailureDomain> items) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        for (FailureDomain item : items) {
            FailureDomainBuilder builder = new FailureDomainBuilder(item);
            this._visitables.get("failureDomains").remove(builder);
            this.failureDomains.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFailureDomains(Predicate<FailureDomainBuilder> predicate) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        Iterator<FailureDomainBuilder> each = this.failureDomains.iterator();
        Object visitables = this._visitables.get("failureDomains");
        while (each.hasNext()) {
            FailureDomainBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<FailureDomain> buildFailureDomains() {
        return this.failureDomains != null ? PlatformFluent.build(this.failureDomains) : null;
    }

    public FailureDomain buildFailureDomain(int index) {
        return this.failureDomains.get(index).build();
    }

    public FailureDomain buildFirstFailureDomain() {
        return this.failureDomains.get(0).build();
    }

    public FailureDomain buildLastFailureDomain() {
        return this.failureDomains.get(this.failureDomains.size() - 1).build();
    }

    public FailureDomain buildMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
        for (FailureDomainBuilder item : this.failureDomains) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
        for (FailureDomainBuilder item : this.failureDomains) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFailureDomains(List<FailureDomain> failureDomains) {
        if (this.failureDomains != null) {
            this._visitables.get("failureDomains").clear();
        }
        if (failureDomains != null) {
            this.failureDomains = new ArrayList();
            for (FailureDomain item : failureDomains) {
                this.addToFailureDomains(item);
            }
        } else {
            this.failureDomains = null;
        }
        return (A)this;
    }

    public A withFailureDomains(FailureDomain ... failureDomains) {
        if (this.failureDomains != null) {
            this.failureDomains.clear();
            this._visitables.remove("failureDomains");
        }
        if (failureDomains != null) {
            for (FailureDomain item : failureDomains) {
                this.addToFailureDomains(item);
            }
        }
        return (A)this;
    }

    public boolean hasFailureDomains() {
        return this.failureDomains != null && !this.failureDomains.isEmpty();
    }

    public FailureDomainsNested<A> addNewFailureDomain() {
        return new FailureDomainsNested(-1, null);
    }

    public FailureDomainsNested<A> addNewFailureDomainLike(FailureDomain item) {
        return new FailureDomainsNested(-1, item);
    }

    public FailureDomainsNested<A> setNewFailureDomainLike(int index, FailureDomain item) {
        return new FailureDomainsNested(index, item);
    }

    public FailureDomainsNested<A> editFailureDomain(int index) {
        if (this.failureDomains.size() <= index) {
            throw new RuntimeException("Can't edit failureDomains. Index exceeds size.");
        }
        return this.setNewFailureDomainLike(index, this.buildFailureDomain(index));
    }

    public FailureDomainsNested<A> editFirstFailureDomain() {
        if (this.failureDomains.size() == 0) {
            throw new RuntimeException("Can't edit first failureDomains. The list is empty.");
        }
        return this.setNewFailureDomainLike(0, this.buildFailureDomain(0));
    }

    public FailureDomainsNested<A> editLastFailureDomain() {
        int index = this.failureDomains.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last failureDomains. The list is empty.");
        }
        return this.setNewFailureDomainLike(index, this.buildFailureDomain(index));
    }

    public FailureDomainsNested<A> editMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.failureDomains.size(); ++i) {
            if (!predicate.test(this.failureDomains.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching failureDomains. No match found.");
        }
        return this.setNewFailureDomainLike(index, this.buildFailureDomain(index));
    }

    public String getFolder() {
        return this.folder;
    }

    public A withFolder(String folder) {
        this.folder = folder;
        return (A)this;
    }

    public boolean hasFolder() {
        return this.folder != null;
    }

    public String getIngressVIP() {
        return this.ingressVIP;
    }

    public A withIngressVIP(String ingressVIP) {
        this.ingressVIP = ingressVIP;
        return (A)this;
    }

    public boolean hasIngressVIP() {
        return this.ingressVIP != null;
    }

    public A addToIngressVIPs(int index, String item) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        this.ingressVIPs.add(index, item);
        return (A)this;
    }

    public A setToIngressVIPs(int index, String item) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        this.ingressVIPs.set(index, item);
        return (A)this;
    }

    public A addToIngressVIPs(String ... items) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressVIPs.add(item);
        }
        return (A)this;
    }

    public A addAllToIngressVIPs(Collection<String> items) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressVIPs.add(item);
        }
        return (A)this;
    }

    public A removeFromIngressVIPs(String ... items) {
        if (this.ingressVIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ingressVIPs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromIngressVIPs(Collection<String> items) {
        if (this.ingressVIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ingressVIPs.remove(item);
        }
        return (A)this;
    }

    public List<String> getIngressVIPs() {
        return this.ingressVIPs;
    }

    public String getIngressVIP(int index) {
        return this.ingressVIPs.get(index);
    }

    public String getFirstIngressVIP() {
        return this.ingressVIPs.get(0);
    }

    public String getLastIngressVIP() {
        return this.ingressVIPs.get(this.ingressVIPs.size() - 1);
    }

    public String getMatchingIngressVIP(Predicate<String> predicate) {
        for (String item : this.ingressVIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIngressVIP(Predicate<String> predicate) {
        for (String item : this.ingressVIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngressVIPs(List<String> ingressVIPs) {
        if (ingressVIPs != null) {
            this.ingressVIPs = new ArrayList<String>();
            for (String item : ingressVIPs) {
                this.addToIngressVIPs(item);
            }
        } else {
            this.ingressVIPs = null;
        }
        return (A)this;
    }

    public A withIngressVIPs(String ... ingressVIPs) {
        if (this.ingressVIPs != null) {
            this.ingressVIPs.clear();
            this._visitables.remove("ingressVIPs");
        }
        if (ingressVIPs != null) {
            for (String item : ingressVIPs) {
                this.addToIngressVIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasIngressVIPs() {
        return this.ingressVIPs != null && !this.ingressVIPs.isEmpty();
    }

    public VSpherePlatformLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public A withLoadBalancer(VSpherePlatformLoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return (A)this;
    }

    public boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public A withNewLoadBalancer(String type) {
        return this.withLoadBalancer(new VSpherePlatformLoadBalancer(type));
    }

    public String getNetwork() {
        return this.network;
    }

    public A withNetwork(String network) {
        this.network = network;
        return (A)this;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public String getPassword() {
        return this.password;
    }

    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    public A withResourcePool(String resourcePool) {
        this.resourcePool = resourcePool;
        return (A)this;
    }

    public boolean hasResourcePool() {
        return this.resourcePool != null;
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public String getVCenter() {
        return this.vCenter;
    }

    public A withVCenter(String vCenter) {
        this.vCenter = vCenter;
        return (A)this;
    }

    public boolean hasVCenter() {
        return this.vCenter != null;
    }

    public A addToVcenters(int index, VCenter item) {
        if (this.vcenters == null) {
            this.vcenters = new ArrayList();
        }
        VCenterBuilder builder = new VCenterBuilder(item);
        if (index < 0 || index >= this.vcenters.size()) {
            this._visitables.get("vcenters").add(builder);
            this.vcenters.add(builder);
        } else {
            this._visitables.get("vcenters").add(index, builder);
            this.vcenters.add(index, builder);
        }
        return (A)this;
    }

    public A setToVcenters(int index, VCenter item) {
        if (this.vcenters == null) {
            this.vcenters = new ArrayList();
        }
        VCenterBuilder builder = new VCenterBuilder(item);
        if (index < 0 || index >= this.vcenters.size()) {
            this._visitables.get("vcenters").add(builder);
            this.vcenters.add(builder);
        } else {
            this._visitables.get("vcenters").set(index, builder);
            this.vcenters.set(index, builder);
        }
        return (A)this;
    }

    public A addToVcenters(VCenter ... items) {
        if (this.vcenters == null) {
            this.vcenters = new ArrayList();
        }
        for (VCenter item : items) {
            VCenterBuilder builder = new VCenterBuilder(item);
            this._visitables.get("vcenters").add(builder);
            this.vcenters.add(builder);
        }
        return (A)this;
    }

    public A addAllToVcenters(Collection<VCenter> items) {
        if (this.vcenters == null) {
            this.vcenters = new ArrayList();
        }
        for (VCenter item : items) {
            VCenterBuilder builder = new VCenterBuilder(item);
            this._visitables.get("vcenters").add(builder);
            this.vcenters.add(builder);
        }
        return (A)this;
    }

    public A removeFromVcenters(VCenter ... items) {
        if (this.vcenters == null) {
            return (A)this;
        }
        for (VCenter item : items) {
            VCenterBuilder builder = new VCenterBuilder(item);
            this._visitables.get("vcenters").remove(builder);
            this.vcenters.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVcenters(Collection<VCenter> items) {
        if (this.vcenters == null) {
            return (A)this;
        }
        for (VCenter item : items) {
            VCenterBuilder builder = new VCenterBuilder(item);
            this._visitables.get("vcenters").remove(builder);
            this.vcenters.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVcenters(Predicate<VCenterBuilder> predicate) {
        if (this.vcenters == null) {
            return (A)this;
        }
        Iterator<VCenterBuilder> each = this.vcenters.iterator();
        Object visitables = this._visitables.get("vcenters");
        while (each.hasNext()) {
            VCenterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<VCenter> buildVcenters() {
        return this.vcenters != null ? PlatformFluent.build(this.vcenters) : null;
    }

    public VCenter buildVcenter(int index) {
        return this.vcenters.get(index).build();
    }

    public VCenter buildFirstVcenter() {
        return this.vcenters.get(0).build();
    }

    public VCenter buildLastVcenter() {
        return this.vcenters.get(this.vcenters.size() - 1).build();
    }

    public VCenter buildMatchingVcenter(Predicate<VCenterBuilder> predicate) {
        for (VCenterBuilder item : this.vcenters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVcenter(Predicate<VCenterBuilder> predicate) {
        for (VCenterBuilder item : this.vcenters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVcenters(List<VCenter> vcenters) {
        if (this.vcenters != null) {
            this._visitables.get("vcenters").clear();
        }
        if (vcenters != null) {
            this.vcenters = new ArrayList();
            for (VCenter item : vcenters) {
                this.addToVcenters(item);
            }
        } else {
            this.vcenters = null;
        }
        return (A)this;
    }

    public A withVcenters(VCenter ... vcenters) {
        if (this.vcenters != null) {
            this.vcenters.clear();
            this._visitables.remove("vcenters");
        }
        if (vcenters != null) {
            for (VCenter item : vcenters) {
                this.addToVcenters(item);
            }
        }
        return (A)this;
    }

    public boolean hasVcenters() {
        return this.vcenters != null && !this.vcenters.isEmpty();
    }

    public VcentersNested<A> addNewVcenter() {
        return new VcentersNested(-1, null);
    }

    public VcentersNested<A> addNewVcenterLike(VCenter item) {
        return new VcentersNested(-1, item);
    }

    public VcentersNested<A> setNewVcenterLike(int index, VCenter item) {
        return new VcentersNested(index, item);
    }

    public VcentersNested<A> editVcenter(int index) {
        if (this.vcenters.size() <= index) {
            throw new RuntimeException("Can't edit vcenters. Index exceeds size.");
        }
        return this.setNewVcenterLike(index, this.buildVcenter(index));
    }

    public VcentersNested<A> editFirstVcenter() {
        if (this.vcenters.size() == 0) {
            throw new RuntimeException("Can't edit first vcenters. The list is empty.");
        }
        return this.setNewVcenterLike(0, this.buildVcenter(0));
    }

    public VcentersNested<A> editLastVcenter() {
        int index = this.vcenters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last vcenters. The list is empty.");
        }
        return this.setNewVcenterLike(index, this.buildVcenter(index));
    }

    public VcentersNested<A> editMatchingVcenter(Predicate<VCenterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.vcenters.size(); ++i) {
            if (!predicate.test(this.vcenters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching vcenters. No match found.");
        }
        return this.setNewVcenterLike(index, this.buildVcenter(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)o;
        if (!Objects.equals(this.apiVIP, that.apiVIP)) {
            return false;
        }
        if (!Objects.equals(this.apiVIPs, that.apiVIPs)) {
            return false;
        }
        if (!Objects.equals(this.cluster, that.cluster)) {
            return false;
        }
        if (!Objects.equals(this.clusterOSImage, that.clusterOSImage)) {
            return false;
        }
        if (!Objects.equals(this.datacenter, that.datacenter)) {
            return false;
        }
        if (!Objects.equals(this.defaultDatastore, that.defaultDatastore)) {
            return false;
        }
        if (!Objects.equals(this.defaultMachinePlatform, that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.diskType, that.diskType)) {
            return false;
        }
        if (!Objects.equals(this.failureDomains, that.failureDomains)) {
            return false;
        }
        if (!Objects.equals(this.folder, that.folder)) {
            return false;
        }
        if (!Objects.equals(this.ingressVIP, that.ingressVIP)) {
            return false;
        }
        if (!Objects.equals(this.ingressVIPs, that.ingressVIPs)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancer, that.loadBalancer)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (!Objects.equals(this.resourcePool, that.resourcePool)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        if (!Objects.equals(this.vCenter, that.vCenter)) {
            return false;
        }
        if (!Objects.equals(this.vcenters, that.vcenters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVIP, this.apiVIPs, this.cluster, this.clusterOSImage, this.datacenter, this.defaultDatastore, this.defaultMachinePlatform, this.diskType, this.failureDomains, this.folder, this.ingressVIP, this.ingressVIPs, this.loadBalancer, this.network, this.password, this.resourcePool, this.username, this.vCenter, this.vcenters, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVIP != null) {
            sb.append("apiVIP:");
            sb.append(this.apiVIP + ",");
        }
        if (this.apiVIPs != null && !this.apiVIPs.isEmpty()) {
            sb.append("apiVIPs:");
            sb.append(this.apiVIPs + ",");
        }
        if (this.cluster != null) {
            sb.append("cluster:");
            sb.append(this.cluster + ",");
        }
        if (this.clusterOSImage != null) {
            sb.append("clusterOSImage:");
            sb.append(this.clusterOSImage + ",");
        }
        if (this.datacenter != null) {
            sb.append("datacenter:");
            sb.append(this.datacenter + ",");
        }
        if (this.defaultDatastore != null) {
            sb.append("defaultDatastore:");
            sb.append(this.defaultDatastore + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.diskType != null) {
            sb.append("diskType:");
            sb.append(this.diskType + ",");
        }
        if (this.failureDomains != null && !this.failureDomains.isEmpty()) {
            sb.append("failureDomains:");
            sb.append(this.failureDomains + ",");
        }
        if (this.folder != null) {
            sb.append("folder:");
            sb.append(this.folder + ",");
        }
        if (this.ingressVIP != null) {
            sb.append("ingressVIP:");
            sb.append(this.ingressVIP + ",");
        }
        if (this.ingressVIPs != null && !this.ingressVIPs.isEmpty()) {
            sb.append("ingressVIPs:");
            sb.append(this.ingressVIPs + ",");
        }
        if (this.loadBalancer != null) {
            sb.append("loadBalancer:");
            sb.append(this.loadBalancer + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password + ",");
        }
        if (this.resourcePool != null) {
            sb.append("resourcePool:");
            sb.append(this.resourcePool + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.vCenter != null) {
            sb.append("vCenter:");
            sb.append(this.vCenter + ",");
        }
        if (this.vcenters != null && !this.vcenters.isEmpty()) {
            sb.append("vcenters:");
            sb.append(this.vcenters + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VcentersNested<N>
    extends VCenterFluent<VcentersNested<N>>
    implements Nested<N> {
        VCenterBuilder builder;
        int index;

        VcentersNested(int index, VCenter item) {
            this.index = index;
            this.builder = new VCenterBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.setToVcenters(this.index, this.builder.build());
        }

        public N endVcenter() {
            return this.and();
        }
    }

    public class FailureDomainsNested<N>
    extends FailureDomainFluent<FailureDomainsNested<N>>
    implements Nested<N> {
        FailureDomainBuilder builder;
        int index;

        FailureDomainsNested(int index, FailureDomain item) {
            this.index = index;
            this.builder = new FailureDomainBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.setToFailureDomains(this.index, this.builder.build());
        }

        public N endFailureDomain() {
            return this.and();
        }
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

