/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10.config.v1;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.openshift.api.model.v6_10.config.v1.ClusterVersionCapabilitiesSpec;
import io.fabric8.openshift.api.model.v6_10.config.v1.ClusterVersionCapabilitiesSpecBuilder;
import io.fabric8.openshift.api.model.v6_10.config.v1.ClusterVersionCapabilitiesSpecFluent;
import io.fabric8.openshift.api.model.v6_10.config.v1.ClusterVersionSpec;
import io.fabric8.openshift.api.model.v6_10.config.v1.ComponentOverride;
import io.fabric8.openshift.api.model.v6_10.config.v1.ComponentOverrideBuilder;
import io.fabric8.openshift.api.model.v6_10.config.v1.ComponentOverrideFluent;
import io.fabric8.openshift.api.model.v6_10.config.v1.Update;
import io.fabric8.openshift.api.model.v6_10.config.v1.UpdateBuilder;
import io.fabric8.openshift.api.model.v6_10.config.v1.UpdateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterVersionSpecFluent<A extends ClusterVersionSpecFluent<A>>
extends BaseFluent<A> {
    private ClusterVersionCapabilitiesSpecBuilder capabilities;
    private String channel;
    private String clusterID;
    private UpdateBuilder desiredUpdate;
    private ArrayList<ComponentOverrideBuilder> overrides = new ArrayList();
    private String upstream;
    private Map<String, Object> additionalProperties;

    public ClusterVersionSpecFluent() {
    }

    public ClusterVersionSpecFluent(ClusterVersionSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterVersionSpec instance) {
        ClusterVersionSpec clusterVersionSpec = instance = instance != null ? instance : new ClusterVersionSpec();
        if (instance != null) {
            this.withCapabilities(instance.getCapabilities());
            this.withChannel(instance.getChannel());
            this.withClusterID(instance.getClusterID());
            this.withDesiredUpdate(instance.getDesiredUpdate());
            this.withOverrides(instance.getOverrides());
            this.withUpstream(instance.getUpstream());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClusterVersionCapabilitiesSpec buildCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    public A withCapabilities(ClusterVersionCapabilitiesSpec capabilities) {
        this._visitables.remove("capabilities");
        if (capabilities != null) {
            this.capabilities = new ClusterVersionCapabilitiesSpecBuilder(capabilities);
            this._visitables.get("capabilities").add(this.capabilities);
        } else {
            this.capabilities = null;
            this._visitables.get("capabilities").remove(this.capabilities);
        }
        return (A)this;
    }

    public boolean hasCapabilities() {
        return this.capabilities != null;
    }

    public CapabilitiesNested<A> withNewCapabilities() {
        return new CapabilitiesNested(null);
    }

    public CapabilitiesNested<A> withNewCapabilitiesLike(ClusterVersionCapabilitiesSpec item) {
        return new CapabilitiesNested(item);
    }

    public CapabilitiesNested<A> editCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(null));
    }

    public CapabilitiesNested<A> editOrNewCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(new ClusterVersionCapabilitiesSpecBuilder().build()));
    }

    public CapabilitiesNested<A> editOrNewCapabilitiesLike(ClusterVersionCapabilitiesSpec item) {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(item));
    }

    public String getChannel() {
        return this.channel;
    }

    public A withChannel(String channel) {
        this.channel = channel;
        return (A)this;
    }

    public boolean hasChannel() {
        return this.channel != null;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public A withClusterID(String clusterID) {
        this.clusterID = clusterID;
        return (A)this;
    }

    public boolean hasClusterID() {
        return this.clusterID != null;
    }

    public Update buildDesiredUpdate() {
        return this.desiredUpdate != null ? this.desiredUpdate.build() : null;
    }

    public A withDesiredUpdate(Update desiredUpdate) {
        this._visitables.remove("desiredUpdate");
        if (desiredUpdate != null) {
            this.desiredUpdate = new UpdateBuilder(desiredUpdate);
            this._visitables.get("desiredUpdate").add(this.desiredUpdate);
        } else {
            this.desiredUpdate = null;
            this._visitables.get("desiredUpdate").remove(this.desiredUpdate);
        }
        return (A)this;
    }

    public boolean hasDesiredUpdate() {
        return this.desiredUpdate != null;
    }

    public A withNewDesiredUpdate(String architecture, Boolean force, String image, String version) {
        return this.withDesiredUpdate(new Update(architecture, force, image, version));
    }

    public DesiredUpdateNested<A> withNewDesiredUpdate() {
        return new DesiredUpdateNested(null);
    }

    public DesiredUpdateNested<A> withNewDesiredUpdateLike(Update item) {
        return new DesiredUpdateNested(item);
    }

    public DesiredUpdateNested<A> editDesiredUpdate() {
        return this.withNewDesiredUpdateLike(Optional.ofNullable(this.buildDesiredUpdate()).orElse(null));
    }

    public DesiredUpdateNested<A> editOrNewDesiredUpdate() {
        return this.withNewDesiredUpdateLike(Optional.ofNullable(this.buildDesiredUpdate()).orElse(new UpdateBuilder().build()));
    }

    public DesiredUpdateNested<A> editOrNewDesiredUpdateLike(Update item) {
        return this.withNewDesiredUpdateLike(Optional.ofNullable(this.buildDesiredUpdate()).orElse(item));
    }

    public A addToOverrides(int index, ComponentOverride item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
        if (index < 0 || index >= this.overrides.size()) {
            this._visitables.get("overrides").add(builder);
            this.overrides.add(builder);
        } else {
            this._visitables.get("overrides").add(index, builder);
            this.overrides.add(index, builder);
        }
        return (A)this;
    }

    public A setToOverrides(int index, ComponentOverride item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
        if (index < 0 || index >= this.overrides.size()) {
            this._visitables.get("overrides").add(builder);
            this.overrides.add(builder);
        } else {
            this._visitables.get("overrides").set(index, builder);
            this.overrides.set(index, builder);
        }
        return (A)this;
    }

    public A addToOverrides(ComponentOverride ... items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        for (ComponentOverride item : items) {
            ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
            this._visitables.get("overrides").add(builder);
            this.overrides.add(builder);
        }
        return (A)this;
    }

    public A addAllToOverrides(Collection<ComponentOverride> items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        for (ComponentOverride item : items) {
            ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
            this._visitables.get("overrides").add(builder);
            this.overrides.add(builder);
        }
        return (A)this;
    }

    public A removeFromOverrides(ComponentOverride ... items) {
        if (this.overrides == null) {
            return (A)this;
        }
        for (ComponentOverride item : items) {
            ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
            this._visitables.get("overrides").remove(builder);
            this.overrides.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromOverrides(Collection<ComponentOverride> items) {
        if (this.overrides == null) {
            return (A)this;
        }
        for (ComponentOverride item : items) {
            ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
            this._visitables.get("overrides").remove(builder);
            this.overrides.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromOverrides(Predicate<ComponentOverrideBuilder> predicate) {
        if (this.overrides == null) {
            return (A)this;
        }
        Iterator<ComponentOverrideBuilder> each = this.overrides.iterator();
        Object visitables = this._visitables.get("overrides");
        while (each.hasNext()) {
            ComponentOverrideBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ComponentOverride> buildOverrides() {
        return this.overrides != null ? ClusterVersionSpecFluent.build(this.overrides) : null;
    }

    public ComponentOverride buildOverride(int index) {
        return this.overrides.get(index).build();
    }

    public ComponentOverride buildFirstOverride() {
        return this.overrides.get(0).build();
    }

    public ComponentOverride buildLastOverride() {
        return this.overrides.get(this.overrides.size() - 1).build();
    }

    public ComponentOverride buildMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
        for (ComponentOverrideBuilder item : this.overrides) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
        for (ComponentOverrideBuilder item : this.overrides) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOverrides(List<ComponentOverride> overrides) {
        if (this.overrides != null) {
            this._visitables.get("overrides").clear();
        }
        if (overrides != null) {
            this.overrides = new ArrayList();
            for (ComponentOverride item : overrides) {
                this.addToOverrides(item);
            }
        } else {
            this.overrides = null;
        }
        return (A)this;
    }

    public A withOverrides(ComponentOverride ... overrides) {
        if (this.overrides != null) {
            this.overrides.clear();
            this._visitables.remove("overrides");
        }
        if (overrides != null) {
            for (ComponentOverride item : overrides) {
                this.addToOverrides(item);
            }
        }
        return (A)this;
    }

    public boolean hasOverrides() {
        return this.overrides != null && !this.overrides.isEmpty();
    }

    public A addNewOverride(String group, String kind, String name, String namespace, Boolean unmanaged) {
        return this.addToOverrides(new ComponentOverride(group, kind, name, namespace, unmanaged));
    }

    public OverridesNested<A> addNewOverride() {
        return new OverridesNested(-1, null);
    }

    public OverridesNested<A> addNewOverrideLike(ComponentOverride item) {
        return new OverridesNested(-1, item);
    }

    public OverridesNested<A> setNewOverrideLike(int index, ComponentOverride item) {
        return new OverridesNested(index, item);
    }

    public OverridesNested<A> editOverride(int index) {
        if (this.overrides.size() <= index) {
            throw new RuntimeException("Can't edit overrides. Index exceeds size.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    public OverridesNested<A> editFirstOverride() {
        if (this.overrides.size() == 0) {
            throw new RuntimeException("Can't edit first overrides. The list is empty.");
        }
        return this.setNewOverrideLike(0, this.buildOverride(0));
    }

    public OverridesNested<A> editLastOverride() {
        int index = this.overrides.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last overrides. The list is empty.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    public OverridesNested<A> editMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.overrides.size(); ++i) {
            if (!predicate.test(this.overrides.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching overrides. No match found.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    public String getUpstream() {
        return this.upstream;
    }

    public A withUpstream(String upstream) {
        this.upstream = upstream;
        return (A)this;
    }

    public boolean hasUpstream() {
        return this.upstream != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterVersionSpecFluent that = (ClusterVersionSpecFluent)o;
        if (!Objects.equals(this.capabilities, that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.channel, that.channel)) {
            return false;
        }
        if (!Objects.equals(this.clusterID, that.clusterID)) {
            return false;
        }
        if (!Objects.equals(this.desiredUpdate, that.desiredUpdate)) {
            return false;
        }
        if (!Objects.equals(this.overrides, that.overrides)) {
            return false;
        }
        if (!Objects.equals(this.upstream, that.upstream)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.capabilities, this.channel, this.clusterID, this.desiredUpdate, this.overrides, this.upstream, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.capabilities != null) {
            sb.append("capabilities:");
            sb.append(this.capabilities + ",");
        }
        if (this.channel != null) {
            sb.append("channel:");
            sb.append(this.channel + ",");
        }
        if (this.clusterID != null) {
            sb.append("clusterID:");
            sb.append(this.clusterID + ",");
        }
        if (this.desiredUpdate != null) {
            sb.append("desiredUpdate:");
            sb.append(this.desiredUpdate + ",");
        }
        if (this.overrides != null && !this.overrides.isEmpty()) {
            sb.append("overrides:");
            sb.append(this.overrides + ",");
        }
        if (this.upstream != null) {
            sb.append("upstream:");
            sb.append(this.upstream + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OverridesNested<N>
    extends ComponentOverrideFluent<OverridesNested<N>>
    implements Nested<N> {
        ComponentOverrideBuilder builder;
        int index;

        OverridesNested(int index, ComponentOverride item) {
            this.index = index;
            this.builder = new ComponentOverrideBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterVersionSpecFluent.this.setToOverrides(this.index, this.builder.build());
        }

        public N endOverride() {
            return this.and();
        }
    }

    public class DesiredUpdateNested<N>
    extends UpdateFluent<DesiredUpdateNested<N>>
    implements Nested<N> {
        UpdateBuilder builder;

        DesiredUpdateNested(Update item) {
            this.builder = new UpdateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterVersionSpecFluent.this.withDesiredUpdate(this.builder.build());
        }

        public N endDesiredUpdate() {
            return this.and();
        }
    }

    public class CapabilitiesNested<N>
    extends ClusterVersionCapabilitiesSpecFluent<CapabilitiesNested<N>>
    implements Nested<N> {
        ClusterVersionCapabilitiesSpecBuilder builder;

        CapabilitiesNested(ClusterVersionCapabilitiesSpec item) {
            this.builder = new ClusterVersionCapabilitiesSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterVersionSpecFluent.this.withCapabilities(this.builder.build());
        }

        public N endCapabilities() {
            return this.and();
        }
    }
}

