/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_10.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_10.ObjectMetaFluent;
import io.fabric8.openshift.api.model.v6_10.AllowedFlexVolume;
import io.fabric8.openshift.api.model.v6_10.AllowedFlexVolumeBuilder;
import io.fabric8.openshift.api.model.v6_10.AllowedFlexVolumeFluent;
import io.fabric8.openshift.api.model.v6_10.FSGroupStrategyOptions;
import io.fabric8.openshift.api.model.v6_10.FSGroupStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.v6_10.FSGroupStrategyOptionsFluent;
import io.fabric8.openshift.api.model.v6_10.RunAsUserStrategyOptions;
import io.fabric8.openshift.api.model.v6_10.RunAsUserStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.v6_10.RunAsUserStrategyOptionsFluent;
import io.fabric8.openshift.api.model.v6_10.SELinuxContextStrategyOptions;
import io.fabric8.openshift.api.model.v6_10.SELinuxContextStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.v6_10.SELinuxContextStrategyOptionsFluent;
import io.fabric8.openshift.api.model.v6_10.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v6_10.SupplementalGroupsStrategyOptions;
import io.fabric8.openshift.api.model.v6_10.SupplementalGroupsStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.v6_10.SupplementalGroupsStrategyOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SecurityContextConstraintsFluent<A extends SecurityContextConstraintsFluent<A>>
extends BaseFluent<A> {
    private Boolean allowHostDirVolumePlugin;
    private Boolean allowHostIPC;
    private Boolean allowHostNetwork;
    private Boolean allowHostPID;
    private Boolean allowHostPorts;
    private Boolean allowPrivilegeEscalation;
    private Boolean allowPrivilegedContainer;
    private List<String> allowedCapabilities = new ArrayList<String>();
    private ArrayList<AllowedFlexVolumeBuilder> allowedFlexVolumes = new ArrayList();
    private List<String> allowedUnsafeSysctls = new ArrayList<String>();
    private String apiVersion;
    private List<String> defaultAddCapabilities = new ArrayList<String>();
    private Boolean defaultAllowPrivilegeEscalation;
    private List<String> forbiddenSysctls = new ArrayList<String>();
    private FSGroupStrategyOptionsBuilder fsGroup;
    private List<String> groups = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private Integer priority;
    private Boolean readOnlyRootFilesystem;
    private List<String> requiredDropCapabilities = new ArrayList<String>();
    private RunAsUserStrategyOptionsBuilder runAsUser;
    private SELinuxContextStrategyOptionsBuilder seLinuxContext;
    private List<String> seccompProfiles = new ArrayList<String>();
    private SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
    private List<String> users = new ArrayList<String>();
    private List<String> volumes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public SecurityContextConstraintsFluent() {
    }

    public SecurityContextConstraintsFluent(SecurityContextConstraints instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SecurityContextConstraints instance) {
        SecurityContextConstraints securityContextConstraints = instance = instance != null ? instance : new SecurityContextConstraints();
        if (instance != null) {
            this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin());
            this.withAllowHostIPC(instance.getAllowHostIPC());
            this.withAllowHostNetwork(instance.getAllowHostNetwork());
            this.withAllowHostPID(instance.getAllowHostPID());
            this.withAllowHostPorts(instance.getAllowHostPorts());
            this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
            this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer());
            this.withAllowedCapabilities(instance.getAllowedCapabilities());
            this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
            this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());
            this.withApiVersion(instance.getApiVersion());
            this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
            this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());
            this.withForbiddenSysctls(instance.getForbiddenSysctls());
            this.withFsGroup(instance.getFsGroup());
            this.withGroups(instance.getGroups());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withPriority(instance.getPriority());
            this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
            this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
            this.withRunAsUser(instance.getRunAsUser());
            this.withSeLinuxContext(instance.getSeLinuxContext());
            this.withSeccompProfiles(instance.getSeccompProfiles());
            this.withSupplementalGroups(instance.getSupplementalGroups());
            this.withUsers(instance.getUsers());
            this.withVolumes(instance.getVolumes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin;
    }

    public A withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        return (A)this;
    }

    public boolean hasAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin != null;
    }

    public Boolean getAllowHostIPC() {
        return this.allowHostIPC;
    }

    public A withAllowHostIPC(Boolean allowHostIPC) {
        this.allowHostIPC = allowHostIPC;
        return (A)this;
    }

    public boolean hasAllowHostIPC() {
        return this.allowHostIPC != null;
    }

    public Boolean getAllowHostNetwork() {
        return this.allowHostNetwork;
    }

    public A withAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
        return (A)this;
    }

    public boolean hasAllowHostNetwork() {
        return this.allowHostNetwork != null;
    }

    public Boolean getAllowHostPID() {
        return this.allowHostPID;
    }

    public A withAllowHostPID(Boolean allowHostPID) {
        this.allowHostPID = allowHostPID;
        return (A)this;
    }

    public boolean hasAllowHostPID() {
        return this.allowHostPID != null;
    }

    public Boolean getAllowHostPorts() {
        return this.allowHostPorts;
    }

    public A withAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
        return (A)this;
    }

    public boolean hasAllowHostPorts() {
        return this.allowHostPorts != null;
    }

    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return (A)this;
    }

    public boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    public Boolean getAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer;
    }

    public A withAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        return (A)this;
    }

    public boolean hasAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer != null;
    }

    public A addToAllowedCapabilities(int index, String item) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        this.allowedCapabilities.add(index, item);
        return (A)this;
    }

    public A setToAllowedCapabilities(int index, String item) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        this.allowedCapabilities.set(index, item);
        return (A)this;
    }

    public A addToAllowedCapabilities(String ... items) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    public A addAllToAllowedCapabilities(Collection<String> items) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    public A removeFromAllowedCapabilities(String ... items) {
        if (this.allowedCapabilities == null) {
            return (A)this;
        }
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAllowedCapabilities(Collection<String> items) {
        if (this.allowedCapabilities == null) {
            return (A)this;
        }
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    public String getAllowedCapability(int index) {
        return this.allowedCapabilities.get(index);
    }

    public String getFirstAllowedCapability() {
        return this.allowedCapabilities.get(0);
    }

    public String getLastAllowedCapability() {
        return this.allowedCapabilities.get(this.allowedCapabilities.size() - 1);
    }

    public String getMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedCapabilities(List<String> allowedCapabilities) {
        if (allowedCapabilities != null) {
            this.allowedCapabilities = new ArrayList<String>();
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        } else {
            this.allowedCapabilities = null;
        }
        return (A)this;
    }

    public A withAllowedCapabilities(String ... allowedCapabilities) {
        if (this.allowedCapabilities != null) {
            this.allowedCapabilities.clear();
            this._visitables.remove("allowedCapabilities");
        }
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)this;
    }

    public boolean hasAllowedCapabilities() {
        return this.allowedCapabilities != null && !this.allowedCapabilities.isEmpty();
    }

    public A addToAllowedFlexVolumes(int index, AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList();
        }
        AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
        if (index < 0 || index >= this.allowedFlexVolumes.size()) {
            this._visitables.get("allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        } else {
            this._visitables.get("allowedFlexVolumes").add(index, builder);
            this.allowedFlexVolumes.add(index, builder);
        }
        return (A)this;
    }

    public A setToAllowedFlexVolumes(int index, AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList();
        }
        AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
        if (index < 0 || index >= this.allowedFlexVolumes.size()) {
            this._visitables.get("allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        } else {
            this._visitables.get("allowedFlexVolumes").set(index, builder);
            this.allowedFlexVolumes.set(index, builder);
        }
        return (A)this;
    }

    public A addToAllowedFlexVolumes(AllowedFlexVolume ... items) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList();
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        }
        return (A)this;
    }

    public A addAllToAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList();
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        }
        return (A)this;
    }

    public A removeFromAllowedFlexVolumes(AllowedFlexVolume ... items) {
        if (this.allowedFlexVolumes == null) {
            return (A)this;
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").remove(builder);
            this.allowedFlexVolumes.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
        if (this.allowedFlexVolumes == null) {
            return (A)this;
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get("allowedFlexVolumes").remove(builder);
            this.allowedFlexVolumes.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAllowedFlexVolumes(Predicate<AllowedFlexVolumeBuilder> predicate) {
        if (this.allowedFlexVolumes == null) {
            return (A)this;
        }
        Iterator<AllowedFlexVolumeBuilder> each = this.allowedFlexVolumes.iterator();
        Object visitables = this._visitables.get("allowedFlexVolumes");
        while (each.hasNext()) {
            AllowedFlexVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AllowedFlexVolume> buildAllowedFlexVolumes() {
        return this.allowedFlexVolumes != null ? SecurityContextConstraintsFluent.build(this.allowedFlexVolumes) : null;
    }

    public AllowedFlexVolume buildAllowedFlexVolume(int index) {
        return this.allowedFlexVolumes.get(index).build();
    }

    public AllowedFlexVolume buildFirstAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(0).build();
    }

    public AllowedFlexVolume buildLastAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(this.allowedFlexVolumes.size() - 1).build();
    }

    public AllowedFlexVolume buildMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        for (AllowedFlexVolumeBuilder item : this.allowedFlexVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        for (AllowedFlexVolumeBuilder item : this.allowedFlexVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedFlexVolumes(List<AllowedFlexVolume> allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) {
            this._visitables.get("allowedFlexVolumes").clear();
        }
        if (allowedFlexVolumes != null) {
            this.allowedFlexVolumes = new ArrayList();
            for (AllowedFlexVolume item : allowedFlexVolumes) {
                this.addToAllowedFlexVolumes(item);
            }
        } else {
            this.allowedFlexVolumes = null;
        }
        return (A)this;
    }

    public A withAllowedFlexVolumes(AllowedFlexVolume ... allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) {
            this.allowedFlexVolumes.clear();
            this._visitables.remove("allowedFlexVolumes");
        }
        if (allowedFlexVolumes != null) {
            for (AllowedFlexVolume item : allowedFlexVolumes) {
                this.addToAllowedFlexVolumes(item);
            }
        }
        return (A)this;
    }

    public boolean hasAllowedFlexVolumes() {
        return this.allowedFlexVolumes != null && !this.allowedFlexVolumes.isEmpty();
    }

    public A addNewAllowedFlexVolume(String driver) {
        return this.addToAllowedFlexVolumes(new AllowedFlexVolume(driver));
    }

    public AllowedFlexVolumesNested<A> addNewAllowedFlexVolume() {
        return new AllowedFlexVolumesNested(-1, null);
    }

    public AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(AllowedFlexVolume item) {
        return new AllowedFlexVolumesNested(-1, item);
    }

    public AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(int index, AllowedFlexVolume item) {
        return new AllowedFlexVolumesNested(index, item);
    }

    public AllowedFlexVolumesNested<A> editAllowedFlexVolume(int index) {
        if (this.allowedFlexVolumes.size() <= index) {
            throw new RuntimeException("Can't edit allowedFlexVolumes. Index exceeds size.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    public AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume() {
        if (this.allowedFlexVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first allowedFlexVolumes. The list is empty.");
        }
        return this.setNewAllowedFlexVolumeLike(0, this.buildAllowedFlexVolume(0));
    }

    public AllowedFlexVolumesNested<A> editLastAllowedFlexVolume() {
        int index = this.allowedFlexVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedFlexVolumes. The list is empty.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    public AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedFlexVolumes.size(); ++i) {
            if (!predicate.test(this.allowedFlexVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedFlexVolumes. No match found.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    public A addToAllowedUnsafeSysctls(int index, String item) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        this.allowedUnsafeSysctls.add(index, item);
        return (A)this;
    }

    public A setToAllowedUnsafeSysctls(int index, String item) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        this.allowedUnsafeSysctls.set(index, item);
        return (A)this;
    }

    public A addToAllowedUnsafeSysctls(String ... items) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.add(item);
        }
        return (A)this;
    }

    public A addAllToAllowedUnsafeSysctls(Collection<String> items) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.add(item);
        }
        return (A)this;
    }

    public A removeFromAllowedUnsafeSysctls(String ... items) {
        if (this.allowedUnsafeSysctls == null) {
            return (A)this;
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAllowedUnsafeSysctls(Collection<String> items) {
        if (this.allowedUnsafeSysctls == null) {
            return (A)this;
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.remove(item);
        }
        return (A)this;
    }

    public List<String> getAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls;
    }

    public String getAllowedUnsafeSysctl(int index) {
        return this.allowedUnsafeSysctls.get(index);
    }

    public String getFirstAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(0);
    }

    public String getLastAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(this.allowedUnsafeSysctls.size() - 1);
    }

    public String getMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
        for (String item : this.allowedUnsafeSysctls) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
        for (String item : this.allowedUnsafeSysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls) {
        if (allowedUnsafeSysctls != null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
            for (String item : allowedUnsafeSysctls) {
                this.addToAllowedUnsafeSysctls(item);
            }
        } else {
            this.allowedUnsafeSysctls = null;
        }
        return (A)this;
    }

    public A withAllowedUnsafeSysctls(String ... allowedUnsafeSysctls) {
        if (this.allowedUnsafeSysctls != null) {
            this.allowedUnsafeSysctls.clear();
            this._visitables.remove("allowedUnsafeSysctls");
        }
        if (allowedUnsafeSysctls != null) {
            for (String item : allowedUnsafeSysctls) {
                this.addToAllowedUnsafeSysctls(item);
            }
        }
        return (A)this;
    }

    public boolean hasAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls != null && !this.allowedUnsafeSysctls.isEmpty();
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToDefaultAddCapabilities(int index, String item) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        this.defaultAddCapabilities.add(index, item);
        return (A)this;
    }

    public A setToDefaultAddCapabilities(int index, String item) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        this.defaultAddCapabilities.set(index, item);
        return (A)this;
    }

    public A addToDefaultAddCapabilities(String ... items) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    public A addAllToDefaultAddCapabilities(Collection<String> items) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    public A removeFromDefaultAddCapabilities(String ... items) {
        if (this.defaultAddCapabilities == null) {
            return (A)this;
        }
        for (String item : items) {
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromDefaultAddCapabilities(Collection<String> items) {
        if (this.defaultAddCapabilities == null) {
            return (A)this;
        }
        for (String item : items) {
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    public List<String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    public String getDefaultAddCapability(int index) {
        return this.defaultAddCapabilities.get(index);
    }

    public String getFirstDefaultAddCapability() {
        return this.defaultAddCapabilities.get(0);
    }

    public String getLastDefaultAddCapability() {
        return this.defaultAddCapabilities.get(this.defaultAddCapabilities.size() - 1);
    }

    public String getMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        if (defaultAddCapabilities != null) {
            this.defaultAddCapabilities = new ArrayList<String>();
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        } else {
            this.defaultAddCapabilities = null;
        }
        return (A)this;
    }

    public A withDefaultAddCapabilities(String ... defaultAddCapabilities) {
        if (this.defaultAddCapabilities != null) {
            this.defaultAddCapabilities.clear();
            this._visitables.remove("defaultAddCapabilities");
        }
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)this;
    }

    public boolean hasDefaultAddCapabilities() {
        return this.defaultAddCapabilities != null && !this.defaultAddCapabilities.isEmpty();
    }

    public Boolean getDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation;
    }

    public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation) {
        this.defaultAllowPrivilegeEscalation = defaultAllowPrivilegeEscalation;
        return (A)this;
    }

    public boolean hasDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation != null;
    }

    public A addToForbiddenSysctls(int index, String item) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        this.forbiddenSysctls.add(index, item);
        return (A)this;
    }

    public A setToForbiddenSysctls(int index, String item) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        this.forbiddenSysctls.set(index, item);
        return (A)this;
    }

    public A addToForbiddenSysctls(String ... items) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.forbiddenSysctls.add(item);
        }
        return (A)this;
    }

    public A addAllToForbiddenSysctls(Collection<String> items) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.forbiddenSysctls.add(item);
        }
        return (A)this;
    }

    public A removeFromForbiddenSysctls(String ... items) {
        if (this.forbiddenSysctls == null) {
            return (A)this;
        }
        for (String item : items) {
            this.forbiddenSysctls.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromForbiddenSysctls(Collection<String> items) {
        if (this.forbiddenSysctls == null) {
            return (A)this;
        }
        for (String item : items) {
            this.forbiddenSysctls.remove(item);
        }
        return (A)this;
    }

    public List<String> getForbiddenSysctls() {
        return this.forbiddenSysctls;
    }

    public String getForbiddenSysctl(int index) {
        return this.forbiddenSysctls.get(index);
    }

    public String getFirstForbiddenSysctl() {
        return this.forbiddenSysctls.get(0);
    }

    public String getLastForbiddenSysctl() {
        return this.forbiddenSysctls.get(this.forbiddenSysctls.size() - 1);
    }

    public String getMatchingForbiddenSysctl(Predicate<String> predicate) {
        for (String item : this.forbiddenSysctls) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingForbiddenSysctl(Predicate<String> predicate) {
        for (String item : this.forbiddenSysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withForbiddenSysctls(List<String> forbiddenSysctls) {
        if (forbiddenSysctls != null) {
            this.forbiddenSysctls = new ArrayList<String>();
            for (String item : forbiddenSysctls) {
                this.addToForbiddenSysctls(item);
            }
        } else {
            this.forbiddenSysctls = null;
        }
        return (A)this;
    }

    public A withForbiddenSysctls(String ... forbiddenSysctls) {
        if (this.forbiddenSysctls != null) {
            this.forbiddenSysctls.clear();
            this._visitables.remove("forbiddenSysctls");
        }
        if (forbiddenSysctls != null) {
            for (String item : forbiddenSysctls) {
                this.addToForbiddenSysctls(item);
            }
        }
        return (A)this;
    }

    public boolean hasForbiddenSysctls() {
        return this.forbiddenSysctls != null && !this.forbiddenSysctls.isEmpty();
    }

    public FSGroupStrategyOptions buildFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    public A withFsGroup(FSGroupStrategyOptions fsGroup) {
        this._visitables.remove("fsGroup");
        if (fsGroup != null) {
            this.fsGroup = new FSGroupStrategyOptionsBuilder(fsGroup);
            this._visitables.get("fsGroup").add(this.fsGroup);
        } else {
            this.fsGroup = null;
            this._visitables.get("fsGroup").remove(this.fsGroup);
        }
        return (A)this;
    }

    public boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    public FsGroupNested<A> withNewFsGroup() {
        return new FsGroupNested(null);
    }

    public FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item) {
        return new FsGroupNested(item);
    }

    public FsGroupNested<A> editFsGroup() {
        return this.withNewFsGroupLike(Optional.ofNullable(this.buildFsGroup()).orElse(null));
    }

    public FsGroupNested<A> editOrNewFsGroup() {
        return this.withNewFsGroupLike(Optional.ofNullable(this.buildFsGroup()).orElse(new FSGroupStrategyOptionsBuilder().build()));
    }

    public FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item) {
        return this.withNewFsGroupLike(Optional.ofNullable(this.buildFsGroup()).orElse(item));
    }

    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    public A setToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    public A removeFromGroups(String ... items) {
        if (this.groups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromGroups(Collection<String> items) {
        if (this.groups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getGroup(int index) {
        return this.groups.get(index);
    }

    public String getFirstGroup() {
        return this.groups.get(0);
    }

    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
            this._visitables.remove("groups");
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public Integer getPriority() {
        return this.priority;
    }

    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    public boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    public A addToRequiredDropCapabilities(int index, String item) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        this.requiredDropCapabilities.add(index, item);
        return (A)this;
    }

    public A setToRequiredDropCapabilities(int index, String item) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        this.requiredDropCapabilities.set(index, item);
        return (A)this;
    }

    public A addToRequiredDropCapabilities(String ... items) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    public A addAllToRequiredDropCapabilities(Collection<String> items) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    public A removeFromRequiredDropCapabilities(String ... items) {
        if (this.requiredDropCapabilities == null) {
            return (A)this;
        }
        for (String item : items) {
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRequiredDropCapabilities(Collection<String> items) {
        if (this.requiredDropCapabilities == null) {
            return (A)this;
        }
        for (String item : items) {
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    public List<String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    public String getRequiredDropCapability(int index) {
        return this.requiredDropCapabilities.get(index);
    }

    public String getFirstRequiredDropCapability() {
        return this.requiredDropCapabilities.get(0);
    }

    public String getLastRequiredDropCapability() {
        return this.requiredDropCapabilities.get(this.requiredDropCapabilities.size() - 1);
    }

    public String getMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        if (requiredDropCapabilities != null) {
            this.requiredDropCapabilities = new ArrayList<String>();
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        } else {
            this.requiredDropCapabilities = null;
        }
        return (A)this;
    }

    public A withRequiredDropCapabilities(String ... requiredDropCapabilities) {
        if (this.requiredDropCapabilities != null) {
            this.requiredDropCapabilities.clear();
            this._visitables.remove("requiredDropCapabilities");
        }
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)this;
    }

    public boolean hasRequiredDropCapabilities() {
        return this.requiredDropCapabilities != null && !this.requiredDropCapabilities.isEmpty();
    }

    public RunAsUserStrategyOptions buildRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    public A withRunAsUser(RunAsUserStrategyOptions runAsUser) {
        this._visitables.remove("runAsUser");
        if (runAsUser != null) {
            this.runAsUser = new RunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.get("runAsUser").add(this.runAsUser);
        } else {
            this.runAsUser = null;
            this._visitables.get("runAsUser").remove(this.runAsUser);
        }
        return (A)this;
    }

    public boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    public A withNewRunAsUser(String type, Long uid, Long uidRangeMax, Long uidRangeMin) {
        return this.withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }

    public RunAsUserNested<A> withNewRunAsUser() {
        return new RunAsUserNested(null);
    }

    public RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return new RunAsUserNested(item);
    }

    public RunAsUserNested<A> editRunAsUser() {
        return this.withNewRunAsUserLike(Optional.ofNullable(this.buildRunAsUser()).orElse(null));
    }

    public RunAsUserNested<A> editOrNewRunAsUser() {
        return this.withNewRunAsUserLike(Optional.ofNullable(this.buildRunAsUser()).orElse(new RunAsUserStrategyOptionsBuilder().build()));
    }

    public RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return this.withNewRunAsUserLike(Optional.ofNullable(this.buildRunAsUser()).orElse(item));
    }

    public SELinuxContextStrategyOptions buildSeLinuxContext() {
        return this.seLinuxContext != null ? this.seLinuxContext.build() : null;
    }

    public A withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        this._visitables.remove("seLinuxContext");
        if (seLinuxContext != null) {
            this.seLinuxContext = new SELinuxContextStrategyOptionsBuilder(seLinuxContext);
            this._visitables.get("seLinuxContext").add(this.seLinuxContext);
        } else {
            this.seLinuxContext = null;
            this._visitables.get("seLinuxContext").remove(this.seLinuxContext);
        }
        return (A)this;
    }

    public boolean hasSeLinuxContext() {
        return this.seLinuxContext != null;
    }

    public SeLinuxContextNested<A> withNewSeLinuxContext() {
        return new SeLinuxContextNested(null);
    }

    public SeLinuxContextNested<A> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
        return new SeLinuxContextNested(item);
    }

    public SeLinuxContextNested<A> editSeLinuxContext() {
        return this.withNewSeLinuxContextLike(Optional.ofNullable(this.buildSeLinuxContext()).orElse(null));
    }

    public SeLinuxContextNested<A> editOrNewSeLinuxContext() {
        return this.withNewSeLinuxContextLike(Optional.ofNullable(this.buildSeLinuxContext()).orElse(new SELinuxContextStrategyOptionsBuilder().build()));
    }

    public SeLinuxContextNested<A> editOrNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
        return this.withNewSeLinuxContextLike(Optional.ofNullable(this.buildSeLinuxContext()).orElse(item));
    }

    public A addToSeccompProfiles(int index, String item) {
        if (this.seccompProfiles == null) {
            this.seccompProfiles = new ArrayList<String>();
        }
        this.seccompProfiles.add(index, item);
        return (A)this;
    }

    public A setToSeccompProfiles(int index, String item) {
        if (this.seccompProfiles == null) {
            this.seccompProfiles = new ArrayList<String>();
        }
        this.seccompProfiles.set(index, item);
        return (A)this;
    }

    public A addToSeccompProfiles(String ... items) {
        if (this.seccompProfiles == null) {
            this.seccompProfiles = new ArrayList<String>();
        }
        for (String item : items) {
            this.seccompProfiles.add(item);
        }
        return (A)this;
    }

    public A addAllToSeccompProfiles(Collection<String> items) {
        if (this.seccompProfiles == null) {
            this.seccompProfiles = new ArrayList<String>();
        }
        for (String item : items) {
            this.seccompProfiles.add(item);
        }
        return (A)this;
    }

    public A removeFromSeccompProfiles(String ... items) {
        if (this.seccompProfiles == null) {
            return (A)this;
        }
        for (String item : items) {
            this.seccompProfiles.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSeccompProfiles(Collection<String> items) {
        if (this.seccompProfiles == null) {
            return (A)this;
        }
        for (String item : items) {
            this.seccompProfiles.remove(item);
        }
        return (A)this;
    }

    public List<String> getSeccompProfiles() {
        return this.seccompProfiles;
    }

    public String getSeccompProfile(int index) {
        return this.seccompProfiles.get(index);
    }

    public String getFirstSeccompProfile() {
        return this.seccompProfiles.get(0);
    }

    public String getLastSeccompProfile() {
        return this.seccompProfiles.get(this.seccompProfiles.size() - 1);
    }

    public String getMatchingSeccompProfile(Predicate<String> predicate) {
        for (String item : this.seccompProfiles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSeccompProfile(Predicate<String> predicate) {
        for (String item : this.seccompProfiles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSeccompProfiles(List<String> seccompProfiles) {
        if (seccompProfiles != null) {
            this.seccompProfiles = new ArrayList<String>();
            for (String item : seccompProfiles) {
                this.addToSeccompProfiles(item);
            }
        } else {
            this.seccompProfiles = null;
        }
        return (A)this;
    }

    public A withSeccompProfiles(String ... seccompProfiles) {
        if (this.seccompProfiles != null) {
            this.seccompProfiles.clear();
            this._visitables.remove("seccompProfiles");
        }
        if (seccompProfiles != null) {
            for (String item : seccompProfiles) {
                this.addToSeccompProfiles(item);
            }
        }
        return (A)this;
    }

    public boolean hasSeccompProfiles() {
        return this.seccompProfiles != null && !this.seccompProfiles.isEmpty();
    }

    public SupplementalGroupsStrategyOptions buildSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
        this._visitables.remove("supplementalGroups");
        if (supplementalGroups != null) {
            this.supplementalGroups = new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups);
            this._visitables.get("supplementalGroups").add(this.supplementalGroups);
        } else {
            this.supplementalGroups = null;
            this._visitables.get("supplementalGroups").remove(this.supplementalGroups);
        }
        return (A)this;
    }

    public boolean hasSupplementalGroups() {
        return this.supplementalGroups != null;
    }

    public SupplementalGroupsNested<A> withNewSupplementalGroups() {
        return new SupplementalGroupsNested(null);
    }

    public SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return new SupplementalGroupsNested(item);
    }

    public SupplementalGroupsNested<A> editSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(Optional.ofNullable(this.buildSupplementalGroups()).orElse(null));
    }

    public SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(Optional.ofNullable(this.buildSupplementalGroups()).orElse(new SupplementalGroupsStrategyOptionsBuilder().build()));
    }

    public SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return this.withNewSupplementalGroupsLike(Optional.ofNullable(this.buildSupplementalGroups()).orElse(item));
    }

    public A addToUsers(int index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.add(index, item);
        return (A)this;
    }

    public A setToUsers(int index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.set(index, item);
        return (A)this;
    }

    public A addToUsers(String ... items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    public A addAllToUsers(Collection<String> items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    public A removeFromUsers(String ... items) {
        if (this.users == null) {
            return (A)this;
        }
        for (String item : items) {
            this.users.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromUsers(Collection<String> items) {
        if (this.users == null) {
            return (A)this;
        }
        for (String item : items) {
            this.users.remove(item);
        }
        return (A)this;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public String getUser(int index) {
        return this.users.get(index);
    }

    public String getFirstUser() {
        return this.users.get(0);
    }

    public String getLastUser() {
        return this.users.get(this.users.size() - 1);
    }

    public String getMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUsers(List<String> users) {
        if (users != null) {
            this.users = new ArrayList<String>();
            for (String item : users) {
                this.addToUsers(item);
            }
        } else {
            this.users = null;
        }
        return (A)this;
    }

    public A withUsers(String ... users) {
        if (this.users != null) {
            this.users.clear();
            this._visitables.remove("users");
        }
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    public boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    public A addToVolumes(int index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    public A setToVolumes(int index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.set(index, item);
        return (A)this;
    }

    public A addToVolumes(String ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    public A addAllToVolumes(Collection<String> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    public A removeFromVolumes(String ... items) {
        if (this.volumes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVolumes(Collection<String> items) {
        if (this.volumes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)this;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public String getVolume(int index) {
        return this.volumes.get(index);
    }

    public String getFirstVolume() {
        return this.volumes.get(0);
    }

    public String getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    public String getMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<String> volumes) {
        if (volumes != null) {
            this.volumes = new ArrayList<String>();
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    public A withVolumes(String ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove("volumes");
        }
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityContextConstraintsFluent that = (SecurityContextConstraintsFluent)o;
        if (!Objects.equals(this.allowHostDirVolumePlugin, that.allowHostDirVolumePlugin)) {
            return false;
        }
        if (!Objects.equals(this.allowHostIPC, that.allowHostIPC)) {
            return false;
        }
        if (!Objects.equals(this.allowHostNetwork, that.allowHostNetwork)) {
            return false;
        }
        if (!Objects.equals(this.allowHostPID, that.allowHostPID)) {
            return false;
        }
        if (!Objects.equals(this.allowHostPorts, that.allowHostPorts)) {
            return false;
        }
        if (!Objects.equals(this.allowPrivilegeEscalation, that.allowPrivilegeEscalation)) {
            return false;
        }
        if (!Objects.equals(this.allowPrivilegedContainer, that.allowPrivilegedContainer)) {
            return false;
        }
        if (!Objects.equals(this.allowedCapabilities, that.allowedCapabilities)) {
            return false;
        }
        if (!Objects.equals(this.allowedFlexVolumes, that.allowedFlexVolumes)) {
            return false;
        }
        if (!Objects.equals(this.allowedUnsafeSysctls, that.allowedUnsafeSysctls)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.defaultAddCapabilities, that.defaultAddCapabilities)) {
            return false;
        }
        if (!Objects.equals(this.defaultAllowPrivilegeEscalation, that.defaultAllowPrivilegeEscalation)) {
            return false;
        }
        if (!Objects.equals(this.forbiddenSysctls, that.forbiddenSysctls)) {
            return false;
        }
        if (!Objects.equals(this.fsGroup, that.fsGroup)) {
            return false;
        }
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.readOnlyRootFilesystem, that.readOnlyRootFilesystem)) {
            return false;
        }
        if (!Objects.equals(this.requiredDropCapabilities, that.requiredDropCapabilities)) {
            return false;
        }
        if (!Objects.equals(this.runAsUser, that.runAsUser)) {
            return false;
        }
        if (!Objects.equals(this.seLinuxContext, that.seLinuxContext)) {
            return false;
        }
        if (!Objects.equals(this.seccompProfiles, that.seccompProfiles)) {
            return false;
        }
        if (!Objects.equals(this.supplementalGroups, that.supplementalGroups)) {
            return false;
        }
        if (!Objects.equals(this.users, that.users)) {
            return false;
        }
        if (!Objects.equals(this.volumes, that.volumes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowHostDirVolumePlugin, this.allowHostIPC, this.allowHostNetwork, this.allowHostPID, this.allowHostPorts, this.allowPrivilegeEscalation, this.allowPrivilegedContainer, this.allowedCapabilities, this.allowedFlexVolumes, this.allowedUnsafeSysctls, this.apiVersion, this.defaultAddCapabilities, this.defaultAllowPrivilegeEscalation, this.forbiddenSysctls, this.fsGroup, this.groups, this.kind, this.metadata, this.priority, this.readOnlyRootFilesystem, this.requiredDropCapabilities, this.runAsUser, this.seLinuxContext, this.seccompProfiles, this.supplementalGroups, this.users, this.volumes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowHostDirVolumePlugin != null) {
            sb.append("allowHostDirVolumePlugin:");
            sb.append(this.allowHostDirVolumePlugin + ",");
        }
        if (this.allowHostIPC != null) {
            sb.append("allowHostIPC:");
            sb.append(this.allowHostIPC + ",");
        }
        if (this.allowHostNetwork != null) {
            sb.append("allowHostNetwork:");
            sb.append(this.allowHostNetwork + ",");
        }
        if (this.allowHostPID != null) {
            sb.append("allowHostPID:");
            sb.append(this.allowHostPID + ",");
        }
        if (this.allowHostPorts != null) {
            sb.append("allowHostPorts:");
            sb.append(this.allowHostPorts + ",");
        }
        if (this.allowPrivilegeEscalation != null) {
            sb.append("allowPrivilegeEscalation:");
            sb.append(this.allowPrivilegeEscalation + ",");
        }
        if (this.allowPrivilegedContainer != null) {
            sb.append("allowPrivilegedContainer:");
            sb.append(this.allowPrivilegedContainer + ",");
        }
        if (this.allowedCapabilities != null && !this.allowedCapabilities.isEmpty()) {
            sb.append("allowedCapabilities:");
            sb.append(this.allowedCapabilities + ",");
        }
        if (this.allowedFlexVolumes != null && !this.allowedFlexVolumes.isEmpty()) {
            sb.append("allowedFlexVolumes:");
            sb.append(this.allowedFlexVolumes + ",");
        }
        if (this.allowedUnsafeSysctls != null && !this.allowedUnsafeSysctls.isEmpty()) {
            sb.append("allowedUnsafeSysctls:");
            sb.append(this.allowedUnsafeSysctls + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.defaultAddCapabilities != null && !this.defaultAddCapabilities.isEmpty()) {
            sb.append("defaultAddCapabilities:");
            sb.append(this.defaultAddCapabilities + ",");
        }
        if (this.defaultAllowPrivilegeEscalation != null) {
            sb.append("defaultAllowPrivilegeEscalation:");
            sb.append(this.defaultAllowPrivilegeEscalation + ",");
        }
        if (this.forbiddenSysctls != null && !this.forbiddenSysctls.isEmpty()) {
            sb.append("forbiddenSysctls:");
            sb.append(this.forbiddenSysctls + ",");
        }
        if (this.fsGroup != null) {
            sb.append("fsGroup:");
            sb.append(this.fsGroup + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.readOnlyRootFilesystem != null) {
            sb.append("readOnlyRootFilesystem:");
            sb.append(this.readOnlyRootFilesystem + ",");
        }
        if (this.requiredDropCapabilities != null && !this.requiredDropCapabilities.isEmpty()) {
            sb.append("requiredDropCapabilities:");
            sb.append(this.requiredDropCapabilities + ",");
        }
        if (this.runAsUser != null) {
            sb.append("runAsUser:");
            sb.append(this.runAsUser + ",");
        }
        if (this.seLinuxContext != null) {
            sb.append("seLinuxContext:");
            sb.append(this.seLinuxContext + ",");
        }
        if (this.seccompProfiles != null && !this.seccompProfiles.isEmpty()) {
            sb.append("seccompProfiles:");
            sb.append(this.seccompProfiles + ",");
        }
        if (this.supplementalGroups != null) {
            sb.append("supplementalGroups:");
            sb.append(this.supplementalGroups + ",");
        }
        if (this.users != null && !this.users.isEmpty()) {
            sb.append("users:");
            sb.append(this.users + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllowHostDirVolumePlugin() {
        return this.withAllowHostDirVolumePlugin(true);
    }

    public A withAllowHostIPC() {
        return this.withAllowHostIPC(true);
    }

    public A withAllowHostNetwork() {
        return this.withAllowHostNetwork(true);
    }

    public A withAllowHostPID() {
        return this.withAllowHostPID(true);
    }

    public A withAllowHostPorts() {
        return this.withAllowHostPorts(true);
    }

    public A withAllowPrivilegeEscalation() {
        return this.withAllowPrivilegeEscalation(true);
    }

    public A withAllowPrivilegedContainer() {
        return this.withAllowPrivilegedContainer(true);
    }

    public A withDefaultAllowPrivilegeEscalation() {
        return this.withDefaultAllowPrivilegeEscalation(true);
    }

    public A withReadOnlyRootFilesystem() {
        return this.withReadOnlyRootFilesystem(true);
    }

    public class SupplementalGroupsNested<N>
    extends SupplementalGroupsStrategyOptionsFluent<SupplementalGroupsNested<N>>
    implements Nested<N> {
        SupplementalGroupsStrategyOptionsBuilder builder;

        SupplementalGroupsNested(SupplementalGroupsStrategyOptions item) {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluent.this.withSupplementalGroups(this.builder.build());
        }

        public N endSupplementalGroups() {
            return this.and();
        }
    }

    public class SeLinuxContextNested<N>
    extends SELinuxContextStrategyOptionsFluent<SeLinuxContextNested<N>>
    implements Nested<N> {
        SELinuxContextStrategyOptionsBuilder builder;

        SeLinuxContextNested(SELinuxContextStrategyOptions item) {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluent.this.withSeLinuxContext(this.builder.build());
        }

        public N endSeLinuxContext() {
            return this.and();
        }
    }

    public class RunAsUserNested<N>
    extends RunAsUserStrategyOptionsFluent<RunAsUserNested<N>>
    implements Nested<N> {
        RunAsUserStrategyOptionsBuilder builder;

        RunAsUserNested(RunAsUserStrategyOptions item) {
            this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluent.this.withRunAsUser(this.builder.build());
        }

        public N endRunAsUser() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class FsGroupNested<N>
    extends FSGroupStrategyOptionsFluent<FsGroupNested<N>>
    implements Nested<N> {
        FSGroupStrategyOptionsBuilder builder;

        FsGroupNested(FSGroupStrategyOptions item) {
            this.builder = new FSGroupStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluent.this.withFsGroup(this.builder.build());
        }

        public N endFsGroup() {
            return this.and();
        }
    }

    public class AllowedFlexVolumesNested<N>
    extends AllowedFlexVolumeFluent<AllowedFlexVolumesNested<N>>
    implements Nested<N> {
        AllowedFlexVolumeBuilder builder;
        int index;

        AllowedFlexVolumesNested(int index, AllowedFlexVolume item) {
            this.index = index;
            this.builder = new AllowedFlexVolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluent.this.setToAllowedFlexVolumes(this.index, this.builder.build());
        }

        public N endAllowedFlexVolume() {
            return this.and();
        }
    }
}

