/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.kubernetes.api.model.v6_10.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_10.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_10.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.v6_10.SecretBuildSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SecretBuildSourceFluent<A extends SecretBuildSourceFluent<A>>
extends BaseFluent<A> {
    private String destinationDir;
    private LocalObjectReferenceBuilder secret;
    private Map<String, Object> additionalProperties;

    public SecretBuildSourceFluent() {
    }

    public SecretBuildSourceFluent(SecretBuildSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SecretBuildSource instance) {
        SecretBuildSource secretBuildSource = instance = instance != null ? instance : new SecretBuildSource();
        if (instance != null) {
            this.withDestinationDir(instance.getDestinationDir());
            this.withSecret(instance.getSecret());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDestinationDir() {
        return this.destinationDir;
    }

    public A withDestinationDir(String destinationDir) {
        this.destinationDir = destinationDir;
        return (A)this;
    }

    public boolean hasDestinationDir() {
        return this.destinationDir != null;
    }

    public LocalObjectReference buildSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    public A withSecret(LocalObjectReference secret) {
        this._visitables.remove("secret");
        if (secret != null) {
            this.secret = new LocalObjectReferenceBuilder(secret);
            this._visitables.get("secret").add(this.secret);
        } else {
            this.secret = null;
            this._visitables.get("secret").remove(this.secret);
        }
        return (A)this;
    }

    public boolean hasSecret() {
        return this.secret != null;
    }

    public A withNewSecret(String name) {
        return this.withSecret(new LocalObjectReference(name));
    }

    public SecretNested<A> withNewSecret() {
        return new SecretNested(null);
    }

    public SecretNested<A> withNewSecretLike(LocalObjectReference item) {
        return new SecretNested(item);
    }

    public SecretNested<A> editSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(null));
    }

    public SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public SecretNested<A> editOrNewSecretLike(LocalObjectReference item) {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretBuildSourceFluent that = (SecretBuildSourceFluent)o;
        if (!Objects.equals(this.destinationDir, that.destinationDir)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.destinationDir, this.secret, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destinationDir != null) {
            sb.append("destinationDir:");
            sb.append(this.destinationDir + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(this.secret + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretNested<N>
    extends LocalObjectReferenceFluent<SecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecretBuildSourceFluent.this.withSecret(this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }
}

