/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.openshift.api.model.v6_10.RouteIngress;
import io.fabric8.openshift.api.model.v6_10.RouteIngressBuilder;
import io.fabric8.openshift.api.model.v6_10.RouteIngressFluent;
import io.fabric8.openshift.api.model.v6_10.RouteStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteStatusFluent<A extends RouteStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RouteIngressBuilder> ingress = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RouteStatusFluent() {
    }

    public RouteStatusFluent(RouteStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RouteStatus instance) {
        RouteStatus routeStatus = instance = instance != null ? instance : new RouteStatus();
        if (instance != null) {
            this.withIngress(instance.getIngress());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToIngress(int index, RouteIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        RouteIngressBuilder builder = new RouteIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(index, builder);
            this.ingress.add(index, builder);
        }
        return (A)this;
    }

    public A setToIngress(int index, RouteIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        RouteIngressBuilder builder = new RouteIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").set(index, builder);
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    public A addToIngress(RouteIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    public A addAllToIngress(Collection<RouteIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    public A removeFromIngress(RouteIngress ... items) {
        if (this.ingress == null) {
            return (A)this;
        }
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromIngress(Collection<RouteIngress> items) {
        if (this.ingress == null) {
            return (A)this;
        }
        for (RouteIngress item : items) {
            RouteIngressBuilder builder = new RouteIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromIngress(Predicate<RouteIngressBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<RouteIngressBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            RouteIngressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RouteIngress> buildIngress() {
        return this.ingress != null ? RouteStatusFluent.build(this.ingress) : null;
    }

    public RouteIngress buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    public RouteIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    public RouteIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    public RouteIngress buildMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        for (RouteIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        for (RouteIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngress(List<RouteIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (RouteIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    public A withIngress(RouteIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove("ingress");
        }
        if (ingress != null) {
            for (RouteIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    public boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    public IngressNested<A> addNewIngress() {
        return new IngressNested(-1, null);
    }

    public IngressNested<A> addNewIngressLike(RouteIngress item) {
        return new IngressNested(-1, item);
    }

    public IngressNested<A> setNewIngressLike(int index, RouteIngress item) {
        return new IngressNested(index, item);
    }

    public IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    public IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteStatusFluent that = (RouteStatusFluent)o;
        if (!Objects.equals(this.ingress, that.ingress)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ingress, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ingress != null && !this.ingress.isEmpty()) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class IngressNested<N>
    extends RouteIngressFluent<IngressNested<N>>
    implements Nested<N> {
        RouteIngressBuilder builder;
        int index;

        IngressNested(int index, RouteIngress item) {
            this.index = index;
            this.builder = new RouteIngressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteStatusFluent.this.setToIngress(this.index, this.builder.build());
        }

        public N endIngress() {
            return this.and();
        }
    }
}

