/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_10;

import io.fabric8.kubernetes.api.builder.v6_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_10.Nested;
import io.fabric8.openshift.api.model.v6_10.RouteIngress;
import io.fabric8.openshift.api.model.v6_10.RouteIngressCondition;
import io.fabric8.openshift.api.model.v6_10.RouteIngressConditionBuilder;
import io.fabric8.openshift.api.model.v6_10.RouteIngressConditionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteIngressFluent<A extends RouteIngressFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RouteIngressConditionBuilder> conditions = new ArrayList();
    private String host;
    private String routerCanonicalHostname;
    private String routerName;
    private String wildcardPolicy;
    private Map<String, Object> additionalProperties;

    public RouteIngressFluent() {
    }

    public RouteIngressFluent(RouteIngress instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RouteIngress instance) {
        RouteIngress routeIngress = instance = instance != null ? instance : new RouteIngress();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withHost(instance.getHost());
            this.withRouterCanonicalHostname(instance.getRouterCanonicalHostname());
            this.withRouterName(instance.getRouterName());
            this.withWildcardPolicy(instance.getWildcardPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, RouteIngressCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, RouteIngressCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(RouteIngressCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<RouteIngressCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(RouteIngressCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<RouteIngressCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<RouteIngressConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<RouteIngressConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            RouteIngressConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RouteIngressCondition> buildConditions() {
        return this.conditions != null ? RouteIngressFluent.build(this.conditions) : null;
    }

    public RouteIngressCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public RouteIngressCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public RouteIngressCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public RouteIngressCondition buildMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        for (RouteIngressConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        for (RouteIngressConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<RouteIngressCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (RouteIngressCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(RouteIngressCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (RouteIngressCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(RouteIngressCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, RouteIngressCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public String getRouterCanonicalHostname() {
        return this.routerCanonicalHostname;
    }

    public A withRouterCanonicalHostname(String routerCanonicalHostname) {
        this.routerCanonicalHostname = routerCanonicalHostname;
        return (A)this;
    }

    public boolean hasRouterCanonicalHostname() {
        return this.routerCanonicalHostname != null;
    }

    public String getRouterName() {
        return this.routerName;
    }

    public A withRouterName(String routerName) {
        this.routerName = routerName;
        return (A)this;
    }

    public boolean hasRouterName() {
        return this.routerName != null;
    }

    public String getWildcardPolicy() {
        return this.wildcardPolicy;
    }

    public A withWildcardPolicy(String wildcardPolicy) {
        this.wildcardPolicy = wildcardPolicy;
        return (A)this;
    }

    public boolean hasWildcardPolicy() {
        return this.wildcardPolicy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteIngressFluent that = (RouteIngressFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.routerCanonicalHostname, that.routerCanonicalHostname)) {
            return false;
        }
        if (!Objects.equals(this.routerName, that.routerName)) {
            return false;
        }
        if (!Objects.equals(this.wildcardPolicy, that.wildcardPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.host, this.routerCanonicalHostname, this.routerName, this.wildcardPolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.routerCanonicalHostname != null) {
            sb.append("routerCanonicalHostname:");
            sb.append(this.routerCanonicalHostname + ",");
        }
        if (this.routerName != null) {
            sb.append("routerName:");
            sb.append(this.routerName + ",");
        }
        if (this.wildcardPolicy != null) {
            sb.append("wildcardPolicy:");
            sb.append(this.wildcardPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends RouteIngressConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        RouteIngressConditionBuilder builder;
        int index;

        ConditionsNested(int index, RouteIngressCondition item) {
            this.index = index;
            this.builder = new RouteIngressConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteIngressFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

